/*
 * Decompiled with CFR 0.152.
 */
package com.gyee.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils {
    private static final String format = "yyyy-MM-dd";
    private static final String format1 = "yyyy-MM-dd HH:mm:ss";
    private static final String format2 = "MM/dd/yyyy HH:mm:ss";
    private static final String format3 = "yyyy-MM";
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();

    public static SimpleDateFormat getFormat() {
        SimpleDateFormat df = threadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(format);
            threadLocal.set(df);
        }
        return df;
    }

    public static SimpleDateFormat getFormat1() {
        SimpleDateFormat df1 = threadLocal.get();
        if (df1 == null) {
            df1 = new SimpleDateFormat(format1);
            threadLocal.set(df1);
        }
        return df1;
    }

    public static SimpleDateFormat getFormat2() {
        SimpleDateFormat df2 = threadLocal.get();
        if (df2 == null) {
            df2 = new SimpleDateFormat(format2);
            threadLocal.set(df2);
        }
        return df2;
    }

    public static SimpleDateFormat getFormat3() {
        SimpleDateFormat df3 = threadLocal.get();
        if (df3 == null) {
            df3 = new SimpleDateFormat(format3);
            threadLocal.set(df3);
        }
        return df3;
    }

    private DateUtils() {
    }

    public static Date today() {
        return DateUtils.truncate(DateUtils.now());
    }

    public static Date now() {
        return new Date();
    }

    public static Date cons(int y, int m, int d) {
        Calendar cal = Calendar.getInstance();
        cal.set(y, m, d, 0, 0, 0);
        return cal.getTime();
    }

    public static String toDate(Date date) {
        return DateUtils.getFormat1().format(date);
    }

    public static String toDate2(Date date) {
        return DateUtils.getFormat2().format(date);
    }

    public static String toDate1(Date date) {
        return DateUtils.getFormat().format(date);
    }

    public static Date cons(int y, int m, int d, int h, int mi, int s) {
        Calendar cal = Calendar.getInstance();
        cal.set(y, m, d, h, mi, s);
        return cal.getTime();
    }

    public static Calendar getCal(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Integer getCurrentYear() {
        Calendar date = Calendar.getInstance();
        int year = date.get(1);
        return year;
    }

    public static Date truncate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date truncDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date truncMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addDays(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, month);
        return cal.getTime();
    }

    public static Date addYears(Date date, int year) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, year);
        return cal.getTime();
    }

    public static Date addHours(Date date, int hour) {
        return new Date(date.getTime() + (long)(hour * 3600 * 1000));
    }

    public static Date addMinutes(Date date, int m) {
        return new Date(date.getTime() + (long)(m * 60 * 1000));
    }

    public static Date addSeconds(Date date, int s) {
        return new Date(date.getTime() + (long)(s * 1000));
    }

    public static int daysDiff(Date d1, Date d2) {
        return (int)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 86400000L);
    }

    public static int hoursDiff(Date d1, Date d2) {
        return (int)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 3600000L);
    }

    public static double hoursDiff1(Date d1, Date d2) {
        return Math.floor((double)Math.abs(d1.getTime() - d2.getTime()) / 3600000.0);
    }

    public static double hoursDiff2(Date d1, Date d2) {
        return (double)Math.abs(d1.getTime() - d2.getTime()) / 3600000.0;
    }

    public static int minutesDiff(Date d1, Date d2) {
        return (int)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 60000L);
    }

    public static double minutesDiff2(Date d1, Date d2) {
        return Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 60000L);
    }

    public static long millisecondDiff(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime());
    }

    public static int secondsDiff(Date d1, Date d2) {
        return (int)Math.floor(Math.abs(d1.getTime() - d2.getTime()) / 1000L);
    }

    public static int monthsDiff(Date d1, Date d2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(d1);
        cal2.setTime(d2);
        return Math.abs((cal1.get(1) - cal2.get(1)) * 12 + cal1.get(2) - cal2.get(2));
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getFirstAndLastDayOfMonth(Date date) throws Exception {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        cale.setTime(date);
        cale.add(2, 0);
        cale.set(5, 1);
        String firstDayOfMonth = formatter.format(cale.getTime());
        return DateUtils.parseDate(firstDayOfMonth);
    }

    public static Date getSeasonStartDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        calendar.set(2, month / 3 * 3);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getYearBegin(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static int getDay(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        return cd.get(5);
    }

    public static int getCurrentMonthLastDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int getMonthDays(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.set(DateUtils.getYear(date), DateUtils.getMonth(date), DateUtils.getDay(date));
        int dayst = cal.getActualMaximum(5);
        return dayst;
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        return date;
    }

    public static Date getMonthFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int month = DateUtils.getMonth(date);
        int year = DateUtils.getYear(date);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMinimum(5));
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static String getCurrtenFirstDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        return DateUtils.getFormat().format(c.getTime());
    }

    public static String getCurrtenLastDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return DateUtils.getFormat().format(ca.getTime());
    }

    public static Date getCurrtenFirstDate() {
        Calendar c = Calendar.getInstance();
        c.set(5, c.getActualMinimum(5));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 1);
        return c.getTime();
    }

    public static Date getCurrtenLastDate() {
        Calendar c = Calendar.getInstance();
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static Date parseDate(String date) {
        try {
            return DateUtils.getFormat().parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate1(String date) {
        try {
            return DateUtils.getFormat1().parse(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate2(String date) {
        try {
            return DateUtils.getFormat2().parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate3(String date) {
        try {
            return DateUtils.getFormat3().parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseLongToDate(long time) {
        return new Date(time);
    }

    public static List<Date> getBetweenDates(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.add(5, 1);
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public static Date getYestmonthLastday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static String convertEdnaTime2(String pointTime, Boolean isNoSec) {
        StringBuffer sb = new StringBuffer();
        String[] dt = pointTime.split(" ");
        String[] ymd = dt[0].split("-");
        String[] hms = dt[1].split(":");
        sb.append(ymd[0]).append("-");
        if (ymd[1].length() == 1) {
            sb.append("0").append(ymd[1]);
        } else {
            sb.append(ymd[1]);
        }
        if (ymd[2].length() == 1) {
            sb.append("-").append("0").append(ymd[2]);
        } else {
            sb.append("-").append(ymd[2]);
        }
        if (hms[0].length() == 1) {
            sb.append(" ").append("0").append(hms[0]);
        } else {
            sb.append(" ").append(hms[0]);
        }
        if (hms[1].length() == 1) {
            sb.append(":").append("0").append(hms[1]);
        } else {
            sb.append(":").append(hms[1]);
        }
        if (isNoSec.booleanValue()) {
            sb.append(":").append("00");
        } else if (hms[2].length() == 1) {
            sb.append(":").append("0").append(hms[2]);
        } else {
            sb.append(":").append(hms[2]);
        }
        return sb.toString();
    }

    public static String convertEdnaTime(String pointTime, Boolean isNoSec) {
        String date = DateUtils.getFormat().format(new Date());
        StringBuffer sb = new StringBuffer();
        String[] dt = pointTime.split(" ");
        String[] ymd = dt[0].split("/");
        String[] hms = dt[1].split(":");
        if (ymd[2].length() == 2) {
            sb.append(date.substring(0, 2)).append(ymd[2]).append("-");
        }
        if (ymd[0].length() == 1) {
            sb.append("0").append(ymd[0]);
        } else {
            sb.append(ymd[0]);
        }
        if (ymd[1].length() == 1) {
            sb.append("-").append("0").append(ymd[1]);
        } else {
            sb.append("-").append(ymd[1]);
        }
        if (hms[0].length() == 1) {
            sb.append(" ").append("0").append(hms[0]);
        } else {
            sb.append(" ").append(hms[0]);
        }
        if (hms[1].length() == 1) {
            sb.append(":").append("0").append(hms[1]);
        } else {
            sb.append(":").append(hms[1]);
        }
        if (isNoSec.booleanValue()) {
            sb.append(":").append("00");
        } else if (hms[2].length() == 1) {
            sb.append(":").append("0").append(hms[2]);
        } else {
            sb.append(":").append(hms[2]);
        }
        return sb.toString();
    }

    public static List<String> getBetweenDays(String startTime, String endTime) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date start = df.parse(startTime);
        Date end = df.parse(endTime);
        ArrayList<String> result = new ArrayList<String>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(6, 1);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        result.add(sdf.format(start));
        while (tempStart.before(tempEnd)) {
            result.add(sdf.format(tempStart.getTime()));
            tempStart.add(6, 1);
        }
        return result;
    }

    public static String convertEdnaTime(String pointTime) {
        return DateUtils.convertEdnaTime2(pointTime, false);
    }

    public static Date getYesterdayStart() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format1);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        SimpleDateFormat format = DateUtils.getDateFormat(format);
        StringBuffer time = new StringBuffer();
        String dateString = format.format(date);
        time.append(dateString).append(" ").append("00:00:00");
        return sdf.parse(time.toString());
    }

    public static Date subOneYear(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, -1);
        return calendar.getTime();
    }

    public static Date getYesterdayEnd() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format1);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        SimpleDateFormat format = DateUtils.getDateFormat(format);
        StringBuffer time = new StringBuffer();
        String dateString = format.format(date);
        time.append(dateString).append(" ").append("23:59:59");
        return sdf.parse(time.toString());
    }

    public static SimpleDateFormat getDateFormat(String parttern) throws RuntimeException {
        return new SimpleDateFormat(parttern);
    }

    public static String getYesterdayStr(String format) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return new SimpleDateFormat(format).format(cal.getTime());
    }

    public static Date getYestday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getMonthDays(DateUtils.today()));
    }

    public static List<String> getDays(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static int getMonth(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        return cd.get(2) + 1;
    }

    public static int getYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        return cd.get(1);
    }

    public static Date getMonthLast(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int month = DateUtils.getMonth(date);
        int year = DateUtils.getYear(date);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }
}

