/*
 * Decompiled with CFR 0.152.
 */
package com.gyee.common.util;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

public class JSONUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String objectToJson(Object data) throws IOException {
        try {
            String string = MAPPER.writeValueAsString(data);
            return string;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T jsonToPojo(String jsonData, Class<T> beanType) {
        try {
            Object t = MAPPER.readValue(jsonData, beanType);
            return (T)t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> jsonToList(String jsonData, Class<T> beanType) {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{beanType});
        try {
            List list = (List)MAPPER.readValue(jsonData, javaType);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

