/*
 * Decompiled with CFR 0.152.
 */
package com.gyee.common.model;

import com.gyee.common.model.StrFormatter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.text.StrBuilder;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final String NULLSTR = "";
    private static final char SEPARATOR = '_';

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return StringUtils.isNull(coll) || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !StringUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Object[] objects) {
        return StringUtils.isNull(objects) || objects.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return !StringUtils.isEmpty(objects);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return StringUtils.isNull(map) || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !StringUtils.isEmpty(map);
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isNull(str) || NULLSTR.equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return !StringUtils.isNull(object);
    }

    public static boolean isArray(Object object) {
        return StringUtils.isNotNull(object) && object.getClass().isArray();
    }

    public static String trim(String str) {
        return str == null ? NULLSTR : str.trim();
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return NULLSTR;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return NULLSTR;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return NULLSTR;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return NULLSTR;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String format(String template, Object ... params) {
        if (StringUtils.isEmpty(params) || StringUtils.isEmpty(template)) {
            return template;
        }
        return StrFormatter.format(template, params);
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StrBuilder(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String toUnderScoreCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtils.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String convertToCamelCase(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return NULLSTR;
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String firstUpperCase(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    public static String firstLowerCase(String name) {
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }

    public static String upperCase_(String name, boolean firstCase) {
        if (StringUtils.isEmpty(name)) {
            return NULLSTR;
        }
        String[] s = name.split("_");
        StringBuffer stringBuffer = new StringBuffer();
        for (String s1 : s) {
            stringBuffer.append(s1.substring(0, 1).toUpperCase() + s1.substring(1));
        }
        if (!firstCase) {
            return StringUtils.firstLowerCase(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static String columnToJava(String columnName) {
        return WordUtils.capitalizeFully((String)columnName, (char[])new char[]{'_'}).replace("_", NULLSTR);
    }

    public static String tableToJava(String tableName, String tablePrefix) {
        if (StringUtils.isNotBlank((CharSequence)tablePrefix)) {
            tableName = tableName.replaceFirst(tablePrefix, NULLSTR);
        }
        return StringUtils.columnToJava(tableName);
    }

    public static double round(double num, int digit) {
        return new BigDecimal(num).setScale(digit, RoundingMode.HALF_UP).doubleValue();
    }

    public static String getUUID() {
        String uuid = UUID.randomUUID().toString().trim().replaceAll("-", NULLSTR);
        return uuid;
    }

    public static boolean empty(Object obj) {
        if (obj == null) {
            return true;
        }
        String str = obj instanceof String ? (String)obj : obj.toString();
        return str.length() == 0;
    }

    public static boolean notEmp(Object obj) {
        return !StringUtils.empty(obj);
    }
}

