/*
 * Decompiled with CFR 0.152.
 */
package com.gyee.common.util;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private RestTemplateUtil() {
    }

    public static RestTemplate getInstance() {
        return SingletonRestTemplate.INSTANCE;
    }

    public static String get(String url, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Content-Encoding", "UTF-8");
        headers.add("Content-Type", "application/json; charset=UTF-8");
        if (token != null) {
            headers.add("token", token);
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = RestTemplateUtil.getInstance().exchange(url, HttpMethod.GET, requestEntity, String.class, new Object[0]);
        String responseInfo = (String)response.getBody();
        return responseInfo;
    }

    public static String post(String url, String data, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Content-Encoding", "UTF-8");
        headers.add("Content-Type", "application/json; charset=UTF-8");
        if (token != null) {
            headers.add("Authorization", token);
        }
        HttpEntity requestEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        return (String)RestTemplateUtil.getInstance().postForObject(url, (Object)requestEntity, String.class, new Object[0]);
    }

    public static void main(String[] args) {
    }

    private static class SingletonRestTemplate {
        static final RestTemplate INSTANCE = new RestTemplate();

        private SingletonRestTemplate() {
        }
    }
}

