/*
 * Decompiled with CFR 0.152.
 */
package com.gyee.common.util.algorithm;

import com.gyee.common.model.StringUtils;
import com.gyee.common.model.algorithm.PointVo;
import java.util.ArrayList;
import java.util.List;

public class LineBuild {
    public static List<PointVo> buildLine(double[] arrX, double[] arrY, int length, int dimension, double scale) {
        ArrayList<PointVo> points = new ArrayList<PointVo>();
        if (arrX.length != arrY.length || arrX.length < 3) {
            return points;
        }
        double minValue = arrY[0];
        double maxValue = arrY[arrY.length - 1];
        double min = 0.0;
        double max = 0.0;
        double[] coefficient = LineBuild.multiLine(arrX, arrY, length, dimension);
        for (double i = arrX[0]; i <= arrX[arrX.length - 1]; i += scale) {
            PointVo point = new PointVo();
            point.setX(StringUtils.round(i, 2));
            for (int j = 0; j < coefficient.length; ++j) {
                Double y = point.getY();
                if (y == null) {
                    y = 0.0;
                }
                y = y + (double)((float)(coefficient[j] * Math.pow(point.getX(), j)));
                point.setY(y);
            }
            if (point.getY() < minValue) {
                point.setY(minValue);
            }
            if (point.getY() > maxValue) {
                point.setY(maxValue);
            }
            if (point.getY() < min) {
                min = point.getY();
            }
            if (point.getY() > max) {
                max = point.getY();
            }
            points.add(point);
        }
        LineBuild.builder(points, min, max);
        return points;
    }

    private static void builder(List<PointVo> points, double min, double max) {
        int i;
        boolean b = false;
        for (i = 0; i < points.size(); ++i) {
            if (b) {
                points.get(i).setY(max);
                continue;
            }
            if (max != points.get(i).getY()) continue;
            b = true;
        }
        for (i = points.size() - 1; i > -1; --i) {
            if (!b) {
                points.get(i).setY(min);
                continue;
            }
            if (min != points.get(i).getY()) continue;
            b = false;
        }
    }

    public static double[] multiLine(double[] arrX, double[] arrY, int length, int dimension) {
        int n = dimension + 1;
        double[][] guass = new double[n][n + 1];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                guass[i][j] = LineBuild.SumArr(arrX, j + i, length);
            }
            guass[i][j] = LineBuild.SumArr(arrX, i, arrY, 1, length);
        }
        return LineBuild.computGauss(guass, n);
    }

    public static double SumArr(double[] arr, int n, int length) {
        double s = 0.0;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != 0.0 || n != 0) {
                s += Math.pow(arr[i], n);
                continue;
            }
            s += 1.0;
        }
        return s;
    }

    public static double SumArr(double[] arr1, int n1, double[] arr2, int n2, int length) {
        double s = 0.0;
        for (int i = 0; i < length; ++i) {
            if (!(arr1[i] == 0.0 && n1 == 0 || arr2[i] == 0.0 && n2 == 0)) {
                s += Math.pow(arr1[i], n1) * Math.pow(arr2[i], n2);
                continue;
            }
            s += 1.0;
        }
        return s;
    }

    public static double[] computGauss(double[][] guass, int n) {
        double s;
        int j;
        int i;
        double[] x = new double[n];
        for (i = 0; i < n; ++i) {
            x[i] = 0.0;
        }
        for (j = 0; j < n; ++j) {
            int m;
            double max = 0.0;
            int k = j;
            for (i = j; i < n; ++i) {
                if (!(Math.abs(guass[i][j]) > max)) continue;
                max = guass[i][j];
                k = i;
            }
            if (k != j) {
                for (m = j; m < n + 1; ++m) {
                    double temp = guass[j][m];
                    guass[j][m] = guass[k][m];
                    guass[k][m] = temp;
                }
            }
            if (0.0 == max) {
                return x;
            }
            for (i = j + 1; i < n; ++i) {
                s = guass[i][j];
                for (m = j; m < n + 1; ++m) {
                    guass[i][m] = guass[i][m] - guass[j][m] * s / guass[j][j];
                }
            }
        }
        for (i = n - 1; i >= 0; --i) {
            s = 0.0;
            for (j = i + 1; j < n; ++j) {
                s += guass[i][j] * x[j];
            }
            x[i] = (guass[i][n] - s) / guass[i][i];
        }
        return x;
    }
}

