/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.IllegalSignatureException;
import com.excelsior.xFunction.IllegalStructureException;
import com.excelsior.xFunction.SLField;
import com.excelsior.xFunction.Structure;
import com.excelsior.xFunction.xParser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

class StructureLayout {
    protected int size;
    protected int boundaryRequirement;
    protected SLField[] arr;
    protected Class structClass;
    private static Map knownStructs = new Hashtable(16);
    private static List deferred = new ArrayList();
    private boolean processed;

    private StructureLayout(Class clazz) {
        this.structClass = clazz;
        this.processed = false;
    }

    private StructureLayout() {
        this.boundaryRequirement = 4;
        this.size = 0;
    }

    private void parseSignature(String string) throws IllegalStructureException {
        Object object;
        String string2 = string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        int n2 = 1;
        try {
            xParser xParser2 = xParser.getParser();
            xParser2.init(string2, 8);
            while (xParser2.parseStructField()) {
                object = SLField.create(this.structClass, xParser2, n);
                n = ((SLField)object).offset + ((SLField)object).size;
                int n3 = Math.min(((SLField)object).getBoundaryRequirement(), xParser2.pack);
                if (n3 > n2) {
                    n2 = n3;
                }
                arrayList.add(object);
            }
            if (xParser2.error) {
                throw new IllegalStructureException("Can't parse signature record in '" + this.structClass.getName() + "' class.", xParser2.errorInfo, string2, xParser2.errorPos);
            }
            xParser.freeParser(xParser2);
        }
        catch (IllegalSignatureException illegalSignatureException) {
            throw new IllegalStructureException(illegalSignatureException.getMessage());
        }
        this.boundaryRequirement = n2;
        int n4 = arrayList.size();
        if (n4 == 0) {
            throw new IllegalStructureException("Empty structures are not allowed.");
        }
        this.arr = new SLField[n4];
        object = arrayList.iterator();
        int n5 = 0;
        while (n5 < n4) {
            this.arr[n5] = (SLField)object.next();
            ++n5;
        }
        int n6 = n4 - 1;
        this.size = SLField.align(n, n2);
    }

    protected static void check(Class clazz) throws IllegalStructureException {
        StructureLayout structureLayout = StructureLayout.getLayout(clazz);
        if (!structureLayout.processed) {
            throw new IllegalStructureException("Recursive structure definition: " + clazz.getName());
        }
    }

    protected static StructureLayout getLayout(Class clazz) throws IllegalStructureException {
        StructureLayout structureLayout = StructureLayout.getLayout0(clazz);
        return structureLayout;
    }

    private static StructureLayout getLayout0(Class clazz) throws IllegalStructureException {
        StructureLayout structureLayout;
        Map map = knownStructs;
        synchronized (map) {
            structureLayout = (StructureLayout)knownStructs.get(clazz);
            if (structureLayout == null) {
                Object object;
                Structure structure = null;
                try {
                    object = clazz.getDeclaredConstructor(null);
                    ((AccessibleObject)object).setAccessible(true);
                    structure = (Structure)((Constructor)object).newInstance(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (structure == null) {
                    throw new IllegalStructureException("Structure subclass '" + clazz.getName() + "' must have constructor without arguments");
                }
                object = structure.defineLayout();
                structureLayout = new StructureLayout(clazz);
                knownStructs.put(clazz, structureLayout);
                structureLayout.parseSignature((String)object);
                structureLayout.processed = true;
            }
        }
        return structureLayout;
    }

    protected static void addDeferred(Class clazz) {
        List list = deferred;
        synchronized (list) {
            if (!deferred.contains(clazz)) {
                deferred.add(clazz);
            }
        }
    }

    protected static void processDeferred() throws IllegalStructureException {
        List list = deferred;
        synchronized (list) {
            while (deferred.size() != 0) {
                int n = deferred.size() - 1;
                Class clazz = (Class)deferred.get(n);
                deferred.remove(n);
                StructureLayout.check(clazz);
            }
        }
    }

    protected void fromByteArray(Structure structure, byte[] byArray) {
        if (byArray.length != this.size) {
            throw new Error("xFunction internal error: corrupt structure object !!!");
        }
        int n = this.arr.length;
        int n2 = 0;
        while (n2 < n) {
            this.arr[n2].fromByteArray(structure, byArray);
            ++n2;
        }
    }

    protected byte[] toByteArray(Structure structure, List list) {
        byte[] byArray = new byte[this.size];
        int n = this.arr.length;
        int n2 = 0;
        while (n2 < n) {
            this.arr[n2].toByteArray(structure, byArray, list);
            ++n2;
        }
        return byArray;
    }
}

