/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.IllegalStructureException;
import com.excelsior.xFunction.StructureLayout;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.util.List;

public abstract class Structure {
    public static final int DEFAULT_PACK = 8;
    private StructureLayout layout;

    public abstract String defineLayout();

    protected final byte[] toByteArray(List list) {
        return this.layout.toByteArray(this, list);
    }

    protected static Structure fromByteArray(Class clazz, byte[] byArray) {
        Structure structure = Structure.newInstance(clazz);
        structure.prepareSafe();
        if (byArray.length != structure.layout.size) {
            throw new Error("xFunction internal error: corrupt structure object");
        }
        structure.layout.fromByteArray(structure, byArray);
        return structure;
    }

    private static Structure newInstance(Class clazz) {
        Structure structure = null;
        try {
            Constructor constructor = clazz.getDeclaredConstructor(null);
            ((AccessibleObject)constructor).setAccessible(true);
            structure = (Structure)constructor.newInstance(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return structure;
    }

    protected static int getSizeOfStructAsRetVal(Class clazz) {
        int n = Structure.getSize(clazz);
        if (n > 8 || n <= 4) {
            return 4;
        }
        return 8;
    }

    protected static int getSize(Class clazz) {
        try {
            StructureLayout structureLayout = StructureLayout.getLayout(clazz);
            return structureLayout.size;
        }
        catch (IllegalStructureException illegalStructureException) {
            throw new Error("xFunction internal error: unexpected exception occured: " + illegalStructureException);
        }
    }

    protected static int getBoundaryRequirement(Class clazz) {
        try {
            StructureLayout structureLayout = StructureLayout.getLayout(clazz);
            return structureLayout.boundaryRequirement;
        }
        catch (IllegalStructureException illegalStructureException) {
            throw new Error("xFunction internal error: unexpected exception occured: " + illegalStructureException);
        }
    }

    protected final void prepare() throws IllegalStructureException {
        if (this.layout == null) {
            this.layout = StructureLayout.getLayout(this.getClass());
            StructureLayout.processDeferred();
        }
    }

    protected final void prepareSafe() {
        try {
            this.prepare();
        }
        catch (IllegalStructureException illegalStructureException) {
            throw new Error("xFunction internal error: unexpected IllegalStructureException occured. Exception message is '" + illegalStructureException.getMessage() + "'.");
        }
    }
}

