/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.ArgType;
import com.excelsior.xFunction.CLField;
import com.excelsior.xFunction.Callback;
import com.excelsior.xFunction.IllegalCallbackException;
import com.excelsior.xFunction.IllegalSignatureException;
import com.excelsior.xFunction.IllegalStructureException;
import com.excelsior.xFunction.StructureLayout;
import com.excelsior.xFunction.xParser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

class CallbackLayout {
    protected int size;
    protected int isFloat;
    private static Map knownCallbacks = new Hashtable(16);
    private int argNum;
    private CLField[] arr;
    private ArgType retType;
    private String funcName;
    private Callback callback;
    private Method method;

    private CallbackLayout(Callback callback) throws IllegalCallbackException {
        this.callback = callback;
        String string = callback.defineSignature();
        Class<?> clazz = callback.getClass();
        this.parseSignature(string);
        Class[] classArray = new Class[this.argNum];
        this.size = 0;
        int n = 0;
        while (n < this.argNum) {
            classArray[n] = this.arr[n].type.getArgClass();
            this.size += this.arr[n].getSize();
            ++n;
        }
        try {
            this.method = clazz.getDeclaredMethod(this.funcName, classArray);
            ((AccessibleObject)this.method).setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalCallbackException("Can't find method '" + this.funcName + "' with the specified parameters types in class " + clazz.getName());
        }
        catch (SecurityException securityException) {
            throw new IllegalCallbackException("Can't access method '" + this.funcName + "': Security exception occured");
        }
        Class<?> clazz2 = this.method.getReturnType();
        if (!clazz2.isPrimitive()) {
            throw new IllegalCallbackException("Return type should be primitive for callbacks, please correct method '" + this.funcName + "'.");
        }
        if (this.retType == null && !clazz2.equals(ArgType.voidClass) || this.retType != null && !this.retType.getArgClass().equals(clazz2)) {
            String string2 = this.retType == null ? "void" : this.retType.getArgClass().getName();
            throw new IllegalCallbackException("Return type of method '" + this.funcName + "' should be '" + string2 + "'");
        }
        this.isFloat = this.retType != null && this.retType.isFloat() ? 1 : 0;
    }

    protected static CallbackLayout getLayout(Callback callback) throws IllegalCallbackException {
        CallbackLayout callbackLayout;
        Class<?> clazz = callback.getClass();
        Map map = knownCallbacks;
        synchronized (map) {
            callbackLayout = (CallbackLayout)knownCallbacks.get(clazz);
            if (callbackLayout == null) {
                callbackLayout = new CallbackLayout(callback);
                knownCallbacks.put(clazz, callbackLayout);
            }
        }
        return callbackLayout;
    }

    protected long invokeLong(byte[] byArray) {
        Object[] objectArray = new Object[this.argNum];
        int n = 0;
        while (n < this.argNum) {
            objectArray[n] = this.arr[n].fromByteArray(byArray);
            ++n;
        }
        try {
            Object object = this.method.invoke((Object)this.callback, objectArray);
            if (this.retType != null) {
                if (this.retType.isFloat()) {
                    throw new Error("xFunction internal error: unexpected return type");
                }
                return ((Number)object).longValue();
            }
            return 0L;
        }
        catch (Exception exception) {
            throw new Error("xFunction internal error: unexpected exception " + exception);
        }
    }

    protected double invokeDouble(byte[] byArray) {
        Object[] objectArray = new Object[this.argNum];
        int n = 0;
        while (n < this.argNum) {
            objectArray[n] = this.arr[n].fromByteArray(byArray);
            ++n;
        }
        try {
            Object object = this.method.invoke((Object)this.callback, objectArray);
            if (this.retType == null || !this.retType.isFloat()) {
                throw new Error("xFunction internal error: unexpected return type");
            }
            return ((Number)object).doubleValue();
        }
        catch (Exception exception) {
            throw new Error("xFunction internal error: unexpected exception " + exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSignature(String string) throws IllegalCallbackException {
        Object object;
        xParser xParser2 = xParser.getParser();
        ArrayList<CLField> arrayList = null;
        xParser2.init(string);
        if (!xParser2.parseSignature() && xParser2.error) {
            throw new IllegalCallbackException("Can't parse signature.", xParser2.errorInfo, string, xParser2.errorPos);
        }
        try {
            if (ArgType.ptName[0].equals(xParser2.baseType)) {
                if (xParser2.pDepth != 0) throw new IllegalCallbackException("Pointers to 'void' are not alowed as return value. You should use pointers to 'int' instead.");
                this.retType = null;
            } else {
                this.retType = ArgType.getArgType(xParser2.baseType, xParser2.pDepth);
            }
            this.funcName = xParser2.name;
            object = null;
            while (xParser2.parseSignature()) {
                ArgType argType = ArgType.getArgType(xParser2.baseType, xParser2.pDepth);
                object = new CLField(argType, object == null ? 0 : ((CLField)object).getOffset() + ((CLField)object).getSize());
                if (arrayList == null) {
                    arrayList = new ArrayList<CLField>();
                }
                arrayList.add((CLField)object);
            }
        }
        catch (IllegalSignatureException illegalSignatureException) {
            throw new IllegalCallbackException(illegalSignatureException.getMessage());
        }
        if (xParser2.error) {
            throw new IllegalCallbackException("Can't parse signature.", xParser2.errorInfo, string, xParser2.errorPos);
        }
        xParser.freeParser(xParser2);
        if (arrayList == null) {
            this.arr = new CLField[0];
        } else {
            this.argNum = arrayList.size();
            this.arr = new CLField[this.argNum];
            object = arrayList.iterator();
            int n = 0;
            while (n < this.argNum) {
                this.arr[n] = (CLField)object.next();
                ++n;
            }
        }
        try {
            StructureLayout.processDeferred();
            return;
        }
        catch (IllegalStructureException illegalStructureException) {
            throw new IllegalCallbackException(illegalStructureException.getMessage());
        }
    }
}

