/*
 * Decompiled with CFR 0.152.
 */
package com.excelsior.xFunction;

import com.excelsior.xFunction.ArgType;
import com.excelsior.xFunction.Callback;
import com.excelsior.xFunction.ConvPrim;
import com.excelsior.xFunction.GettingPointerValueException;
import com.excelsior.xFunction.IllegalCallbackException;
import com.excelsior.xFunction.IllegalSignatureException;
import com.excelsior.xFunction.IllegalStringConversionException;
import com.excelsior.xFunction.IllegalStructureException;
import com.excelsior.xFunction.Pointer;
import com.excelsior.xFunction.Structure;
import com.excelsior.xFunction.TypesDifferentException;
import com.excelsior.xFunction.xFunctionException;
import java.util.ArrayList;
import java.util.List;

public class Argument {
    public static final int UNICODESTRING = 20;
    public static final int CSTRING = 30;
    public static final int BSTR = 40;
    protected byte[] value;
    protected int pointer = 0;
    protected int buf_pointer = 0;
    protected int buf_size = 0;
    protected ArgType type;
    protected List anchors;

    protected Argument() {
    }

    public Argument(int n) {
        try {
            this.type = ArgType.getArgType("int");
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        this.value = ConvPrim.toByteArray(n);
    }

    public Argument(char c) {
        try {
            this.type = ArgType.getArgType("char");
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        this.value = ConvPrim.toByteArray(c & 0xFF);
    }

    public Argument(short s) {
        try {
            this.type = ArgType.getArgType("short");
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        this.value = ConvPrim.toByteArray(s);
    }

    public Argument(long l) {
        try {
            this.type = ArgType.getArgType("long");
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        this.value = ConvPrim.toByteArray(l);
    }

    public Argument(float f) {
        try {
            this.type = ArgType.getArgType("float");
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        this.value = ConvPrim.toByteArray(f);
    }

    public Argument(double d) {
        try {
            this.type = ArgType.getArgType("double");
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        this.value = ConvPrim.toByteArray(d);
    }

    public Argument(String string, int n) throws IllegalStringConversionException {
        int n2 = string.length() + 1;
        if (n == 20) {
            n2 *= 2;
        } else if (n == 40) {
            n2 = n2 * 2 + 4;
        }
        this.constructStrArg(string, n, n2);
    }

    public Argument(String string, int n, int n2) throws IllegalStringConversionException {
        this.constructStrArg(string, n, n2);
    }

    public Argument(Structure structure) throws IllegalStructureException {
        structure.prepare();
        Class<?> clazz = structure.getClass();
        try {
            this.type = ArgType.getArgType(clazz.getName());
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        this.anchors = new ArrayList();
        this.value = structure.toByteArray(this.anchors);
    }

    public Argument(Callback callback) throws IllegalCallbackException {
        callback.check();
        Class<?> clazz = callback.getClass();
        try {
            this.type = ArgType.getArgType(clazz.getName());
        }
        catch (xFunctionException xFunctionException2) {
            throw new Error("xFunction internal error: unexpected exception: " + xFunctionException2);
        }
        int n = callback.lockGate();
        this.value = ConvPrim.toByteArray(n);
    }

    public Object getValue() throws GettingPointerValueException {
        this.refresh();
        byte[] byArray = null;
        switch (this.type.type) {
            case 4: {
                return new Integer(ConvPrim.byteArrayToInt(this.value));
            }
            case 2: {
                return new Character((char)(ConvPrim.byteArrayToInt(this.value) & 0xFF));
            }
            case 3: {
                return new Short((short)ConvPrim.byteArrayToInt(this.value));
            }
            case 5: {
                return new Long(ConvPrim.byteArrayToLong(this.value));
            }
            case 6: {
                return new Float(ConvPrim.byteArrayToFloat(this.value));
            }
            case 7: {
                return new Double(ConvPrim.byteArrayToDouble(this.value));
            }
            case 30: {
                throw new GettingPointerValueException();
            }
            case 20: {
                return Structure.fromByteArray(this.type.baseClass, this.value);
            }
            case 21: {
                return null;
            }
            case 8: {
                byArray = Argument.derefString(ConvPrim.byteArrayToInt(this.value), 30);
                return ConvPrim.ASCII2String(byArray);
            }
            case 9: {
                byArray = Argument.derefString(ConvPrim.byteArrayToInt(this.value), 20);
                return ConvPrim.Unicode2String(byArray);
            }
            case 10: {
                byArray = Argument.derefString(ConvPrim.byteArrayToInt(this.value), 40);
                return ConvPrim.BSTR2String(byArray);
            }
        }
        throw new Error("xFunction internal error: unknown case");
    }

    public Pointer createPointer() {
        Pointer pointer = new Pointer();
        pointer.type = ArgType.getPointerArgType(this.type);
        if (this.pointer == 0) {
            this.lock();
        }
        pointer.value = ConvPrim.toByteArray(this.pointer);
        pointer.objArg = this;
        return pointer;
    }

    static Argument create0(ArgType argType, Object object) throws TypesDifferentException, IllegalStringConversionException {
        if (argType.type == 30) {
            if (object instanceof Pointer) {
                return (Pointer)object;
            }
            Pointer pointer = new Pointer();
            pointer.type = argType;
            ArgType argType2 = ArgType.getFictionArgType();
            pointer.anchors = new ArrayList();
            byte[] byArray = pointer.type.check_and_calc(object, pointer.anchors);
            Argument argument = new Argument(byArray, argType2);
            argument.lock();
            pointer.objArg = argument;
            pointer.value = ConvPrim.toByteArray(argument.pointer);
            return pointer;
        }
        if (argType.isStringType()) {
            int n;
            int n2;
            if (!(object instanceof String)) {
                throw new TypesDifferentException("String expected");
            }
            String string = (String)object;
            if (argType.type == 8) {
                n2 = 30;
                n = string.length() + 1;
            } else if (argType.type == 9) {
                n2 = 20;
                n = 2 * (string.length() + 1);
            } else {
                n2 = 40;
                n = 2 * (string.length() + 1) + 4;
            }
            Argument argument = new Argument();
            argument.constructStrArg(string, n2, n);
            return argument;
        }
        Argument argument = new Argument();
        argument.type = argType;
        argument.anchors = new ArrayList();
        argument.value = argument.type.check_and_calc(object, argument.anchors);
        return argument;
    }

    public static Argument create(String string, Object object) throws IllegalSignatureException, TypesDifferentException, IllegalStringConversionException {
        ArgType argType = ArgType.parseArgType(string);
        return Argument.create0(argType, object);
    }

    Argument(byte[] byArray, ArgType argType) {
        this.value = byArray;
        this.type = argType;
    }

    static Argument createFromPacked(byte[] byArray, ArgType argType) {
        if (argType.type == 30) {
            throw new Error("xFunction internal error: unexpected argument type");
        }
        if (argType.type == 2) {
            return new Argument((char)(byArray[0] & 0xFF));
        }
        if (argType.type == 3) {
            return new Argument(ConvPrim.byteArrayToShort(byArray));
        }
        return new Argument(byArray, argType);
    }

    private void constructStrArg(String string, int n, int n2) throws IllegalStringConversionException {
        byte[] byArray;
        n2 = n2 + 3 & 0xFFFFFFFC;
        switch (n) {
            case 30: {
                try {
                    this.type = ArgType.getArgType("CSTRING");
                }
                catch (xFunctionException xFunctionException2) {
                    throw new Error("xFunction internal error: unexpected exception " + xFunctionException2);
                }
                byArray = ConvPrim.String2ASCII(string);
                break;
            }
            case 20: {
                try {
                    this.type = ArgType.getArgType("UNICODESTRING");
                }
                catch (xFunctionException xFunctionException3) {
                    throw new Error("xFunction internal error: unexpected exception " + xFunctionException3);
                }
                byArray = ConvPrim.String2Unicode(string);
                break;
            }
            case 40: {
                try {
                    this.type = ArgType.getArgType("BSTR");
                }
                catch (xFunctionException xFunctionException4) {
                    throw new Error("xFunction internal error: unexpected exception " + xFunctionException4);
                }
                byArray = ConvPrim.String2BSTR(string);
                break;
            }
            default: {
                throw new IllegalStringConversionException("Unknown string type");
            }
        }
        this.buf_size = n2;
        this.buf_pointer = Argument.allocate(this.buf_size, byArray, byArray.length);
        this.value = ConvPrim.toByteArray(n == 40 ? this.buf_pointer + 4 : this.buf_pointer);
    }

    protected static native int allocate(int var0, byte[] var1, int var2);

    protected static native void free(int var0);

    protected static native int lockByteArray(byte[] var0);

    protected void lock() {
        this.pointer = Argument.lockByteArray(this.value);
    }

    protected static native int refreshByteArray(byte[] var0, int var1);

    protected void refresh() {
        if (this.pointer != 0) {
            this.pointer = Argument.refreshByteArray(this.value, this.pointer);
        }
    }

    protected static native void releaseByteArray(byte[] var0, int var1);

    protected void release() {
        if (this.pointer != 0) {
            Argument.releaseByteArray(this.value, this.pointer);
        }
    }

    byte[] getAsByteArray() {
        this.refresh();
        return this.value;
    }

    protected static native byte[] derefString(int var0, int var1);

    protected void finalize() {
        if (this.buf_pointer != 0) {
            Argument.free(this.buf_pointer);
        }
        this.release();
    }

    static {
        System.loadLibrary("xFunction");
    }
}

