/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.util.UtilBufferedDataConsumer;
import com.microsoft.util.UtilDataConsumer;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilPacketizingDataConsumer;

public class SQLServerPacketizingDataConsumer
extends UtilPacketizingDataConsumer {
    private static String footprint = "$Revision:   1.11  $";
    private static int DEFAULT_PACKET_SIZE = 4096;
    private int messageType;
    int savedStatusFieldPos;

    public SQLServerPacketizingDataConsumer(UtilBufferedDataConsumer utilBufferedDataConsumer) {
        super((UtilDataConsumer)utilBufferedDataConsumer, DEFAULT_PACKET_SIZE);
        super.setSendPacketWhenFull(false);
    }

    public void send() throws UtilException {
        if (this.messageType == 13 || this.messageType == 6) {
            this.signalStartOfPacket();
        }
        super.send();
    }

    public void setMessageType(int n) {
        this.messageType = n;
    }

    public void signalEndOfPacket(boolean bl) throws UtilException {
        if (bl) {
            ((UtilBufferedDataConsumer)this.dataConsumerObject).setPosition(this.savedStatusFieldPos);
            this.writeInt8(1);
        } else {
            ((UtilBufferedDataConsumer)this.dataConsumerObject).setPosition(this.savedStatusFieldPos + 1);
        }
        this.writeInt16(this.numBytesInCurrentPacket);
        ((UtilBufferedDataConsumer)this.dataConsumerObject).setPosition(Integer.MAX_VALUE);
    }

    protected void signalStartOfPacket() throws UtilException {
        this.writeInt8(this.messageType);
        this.savedStatusFieldPos = ((UtilBufferedDataConsumer)this.dataConsumerObject).getPosition();
        this.writeInt8(4);
        this.writeInt16(DEFAULT_PACKET_SIZE);
        this.writeInt16(0);
        this.writeInt8(this.numPacketsCreatedSinceSend + 1);
        this.writeInt8(0);
        this.numBytesInCurrentPacket += 8;
    }
}

