/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.NumberValue;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class IntegerValue
extends NumberValue
implements ParsedThing {
    private static Logger logger = Logger.getLogger(IntegerValue.class);
    private double value;
    private boolean outOfRange;

    public IntegerValue() {
        this.outOfRange = false;
    }

    public IntegerValue(String s) {
        try {
            this.value = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            logger.warn(e, e);
            this.value = 0.0;
        }
        short v = (short)this.value;
        this.outOfRange = this.value != (double)v;
    }

    public int read(byte[] data, int pos) {
        this.value = IntegerHelper.getInt(data[pos], data[pos + 1]);
        return 2;
    }

    byte[] getBytes() {
        byte[] data = new byte[3];
        data[0] = Token.INTEGER.getCode();
        IntegerHelper.getTwoBytes((int)this.value, data, 1);
        return data;
    }

    public double getValue() {
        return this.value;
    }

    boolean isOutOfRange() {
        return this.outOfRange;
    }

    void handleImportedCellReferences() {
    }
}

