/*
 * Decompiled with CFR 0.152.
 */
package jofc2.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.path.PathTrackingWriter;
import jofc2.model.elements.BarChart;
import jofc2.model.elements.FilledBarChart;
import jofc2.model.elements.SketchBarChart;
import jofc2.util.ConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarConverter
extends ConverterBase<BarChart.Bar> {
    @Override
    public void convert(BarChart.Bar b, PathTrackingWriter writer, MarshallingContext mc) {
        this.writeNode(writer, "top", b.getTop(), false);
        this.writeNode(writer, "bottom", b.getBottom(), true);
        this.writeNode(writer, "colour", b.getColour(), true);
        this.writeNode(writer, "tip", b.getTooltip(), true);
        if (b instanceof FilledBarChart.Bar) {
            this.writeNode(writer, "outline-colour", ((FilledBarChart.Bar)b).getOutlineColour(), true);
        }
        if (b instanceof SketchBarChart.Bar) {
            this.writeNode(writer, "offset", ((SketchBarChart.Bar)b).getFunFactor(), true);
        }
    }

    public boolean canConvert(Class clazz) {
        return BarChart.Bar.class.isAssignableFrom(clazz);
    }
}

