/*
 * Decompiled with CFR 0.152.
 */
package jofc2.model.elements;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jofc2.model.elements.Element;
import jofc2.model.metadata.Converter;
import jofc2.util.HorizontalBarChartBarConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalBarChart
extends Element {
    private static final long serialVersionUID = 3320580794787784639L;
    private String colour;

    public HorizontalBarChart() {
        super("hbar");
    }

    public String getColour() {
        return this.colour;
    }

    public HorizontalBarChart setColour(String colour) {
        this.colour = colour;
        return this;
    }

    public HorizontalBarChart addBars(Bar ... bars) {
        this.getValues().addAll((Collection<Object>)Arrays.asList(bars));
        return this;
    }

    public HorizontalBarChart addBars(List<Bar> bars) {
        this.getValues().addAll(bars);
        return this;
    }

    public HorizontalBarChart addValues(Number ... rightValues) {
        Bar[] values = new Bar[rightValues.length];
        int i = 0;
        while (i < rightValues.length) {
            values[i] = new Bar(rightValues[i]);
            ++i;
        }
        return this.addBars(values);
    }

    public HorizontalBarChart addValues(List<Number> rightValues) {
        for (Number number : rightValues) {
            if (number == null) continue;
            this.addBars(new Bar(number));
        }
        return this;
    }

    public HorizontalBarChart addBar(Number left, Number right) {
        return this.addBars(new Bar(left, right));
    }

    @Converter(value=HorizontalBarChartBarConverter.class)
    public static class Bar {
        private final Number right;
        private Number left;

        public Bar(Number right) {
            this(null, right);
        }

        public Bar(Number left, Number right) {
            if (right == null) {
                throw new NullPointerException("Field is mandatory.");
            }
            this.right = right;
            this.setLeft(left);
        }

        public Number getRight() {
            return this.right;
        }

        public Number getLeft() {
            return this.left;
        }

        public Bar setLeft(Number left) {
            this.left = left;
            return this;
        }
    }
}

