/*
 * Decompiled with CFR 0.152.
 */
package jofc2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import jofc2.OFC;
import jofc2.OFCException;
import jofc2.model.Text;
import jofc2.model.axis.XAxis;
import jofc2.model.axis.YAxis;
import jofc2.model.elements.Element;
import jofc2.model.elements.Legend;
import jofc2.model.elements.Tooltip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart
implements Serializable {
    private static final long serialVersionUID = -1868082240169089976L;
    private Text title;
    private XAxis x_axis;
    private YAxis y_axis;
    private YAxis y_axis_right;
    private Text y_legend;
    private Text x_legend;
    private String bg_colour;
    private int is_decimal_separator_comma = 0;
    private int is_fixed_num_decimals_forced = 0;
    private int is_thousand_separator_disabled = 0;
    private int num_decimals = 2;
    private Collection<Element> elements = new ArrayList<Element>();
    private Legend legend;
    private Tooltip tooltip;

    public XAxis getXAxis() {
        return this.x_axis;
    }

    public Chart() {
    }

    public Chart(String titleText) {
        this(titleText, null);
    }

    public Chart(String titleText, String style) {
        this.setTitle(new Text(titleText, style));
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public Chart setXAxis(XAxis x_axis) {
        this.x_axis = x_axis;
        return this;
    }

    public YAxis getYAxis() {
        return this.y_axis;
    }

    public Chart setYAxis(YAxis y_axis) {
        this.y_axis = y_axis;
        return this;
    }

    public Chart setYAxisRight(YAxis y_axis_right) {
        this.y_axis_right = y_axis_right;
        return this;
    }

    public YAxis getYAxisRight() {
        return this.y_axis_right;
    }

    public Text getTitle() {
        return this.title;
    }

    public Chart setTitle(Text title) {
        this.title = title;
        return this;
    }

    public Text getXLegend() {
        return this.x_legend;
    }

    public Chart setXLegend(Text x_legend) {
        this.x_legend = x_legend;
        return this;
    }

    public Text getYLegend() {
        return this.y_legend;
    }

    public Chart setYLegend(Text y_legend) {
        this.y_legend = y_legend;
        return this;
    }

    public String getBackgroundColour() {
        return this.bg_colour;
    }

    public Chart setBackgroundColour(String bg_colour) {
        this.bg_colour = bg_colour;
        return this;
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    public Chart setElements(Collection<Element> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        return this;
    }

    public Chart addElements(Element ... e) {
        this.elements.addAll((Collection<Element>)Arrays.asList(e));
        return this;
    }

    public Chart addElements(Collection<Element> coll) {
        this.elements.addAll(coll);
        return this;
    }

    public boolean removeElement(Element e) {
        return this.elements.remove(e);
    }

    public Element getElementByText(String text) {
        for (Element e : this.getElements()) {
            if (!text.equals(e.getText())) continue;
            return e;
        }
        return null;
    }

    public String toString() throws OFCException {
        return OFC.getInstance().render(this);
    }

    public String toDebugString() {
        return OFC.getInstance().prettyPrint(this, 3);
    }

    public boolean isDecimalSeparatorComma() {
        return this.is_decimal_separator_comma == 1;
    }

    public void setDecimalSeparatorIsComma(boolean is_decimal_separator_comma) {
        this.is_decimal_separator_comma = is_decimal_separator_comma ? 1 : 0;
    }

    public boolean isFixedNumDecimalsForced() {
        return this.is_fixed_num_decimals_forced == 1;
    }

    public void setFixedNumDecimalsForced(boolean is_fixed_num_decimals_forced) {
        this.is_fixed_num_decimals_forced = is_fixed_num_decimals_forced ? 1 : 0;
    }

    public boolean isThousandSeparatorDisabled() {
        return this.is_thousand_separator_disabled == 1;
    }

    public void setThousandSeparatorDisabled(boolean is_thousand_separator_disabled) {
        this.is_thousand_separator_disabled = is_thousand_separator_disabled ? 1 : 0;
    }

    public int getNumDecimals() {
        return this.num_decimals;
    }

    public void setNumDecimals(int num_decimals) {
        this.num_decimals = num_decimals;
    }

    public void computeYAxisRange(int steps) {
        Double min = null;
        double max = 0.0;
        double stepWidth = 1.0;
        if (this.getElements() != null) {
            if (this.getYAxis() == null) {
                YAxis ya = new YAxis();
                this.setYAxis(ya);
            }
            for (Element e : this.getElements()) {
                max = Math.max(max, e.getMaxValue());
                min = this.nullSafeMin(min, e.getMinValue());
            }
            if (min == null) {
                min = 0.0;
            }
            stepWidth = this.getStepWidth(Math.abs(max - min), steps);
            min = Math.floor(min / stepWidth) * stepWidth;
            max = Math.ceil(max / stepWidth) * stepWidth;
            this.getYAxis().setRange(min, max, stepWidth);
        }
    }

    private Double nullSafeMin(Double min, double doubleValue) {
        if (min == null) {
            min = doubleValue;
        }
        min = Math.min(min, doubleValue);
        return min;
    }

    private double getStepWidth(double distance, int steps) {
        double exponent;
        double result = distance / (double)steps;
        result = (result /= Math.pow(10.0, exponent = Math.floor(Math.log10(result)) + 1.0)) > 0.5 ? 1.0 : (result > 0.25 ? 0.5 : 0.25);
        return result * Math.pow(10.0, exponent);
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }
}

