/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonElementVisitor;
import com.google.gson.JsonEscapingVisitor;
import com.google.gson.JsonFormatter;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonTreeNavigator;
import java.io.PrintWriter;

final class JsonCompactFormatter
implements JsonFormatter {
    JsonCompactFormatter() {
    }

    public void format(JsonElement root, PrintWriter writer, boolean serializeNulls) {
        if (root == null) {
            return;
        }
        JsonEscapingVisitor visitor = new JsonEscapingVisitor(new FormattingVisitor(writer, serializeNulls));
        JsonTreeNavigator navigator = new JsonTreeNavigator(visitor, serializeNulls);
        navigator.navigate(root);
    }

    private static class FormattingVisitor
    implements JsonElementVisitor {
        private final PrintWriter writer;
        private final boolean serializeNulls;

        FormattingVisitor(PrintWriter writer, boolean serializeNulls) {
            this.writer = writer;
            this.serializeNulls = serializeNulls;
        }

        public void visitPrimitive(JsonPrimitive primitive) {
            this.writer.append(primitive.toString());
        }

        public void visitNull() {
            this.writer.append("null");
        }

        public void startArray(JsonArray array) {
            this.writer.append('[');
        }

        public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) {
            if (!isFirst) {
                this.writer.append(',');
            }
            this.writer.append(member.toString());
        }

        public void visitArrayMember(JsonArray parent, JsonArray member, boolean isFirst) {
            if (!isFirst) {
                this.writer.append(',');
            }
        }

        public void visitArrayMember(JsonArray parent, JsonObject member, boolean isFirst) {
            if (!isFirst) {
                this.writer.append(',');
            }
        }

        public void visitNullArrayMember(JsonArray parent, boolean isFirst) {
            if (!isFirst) {
                this.writer.append(',');
            }
        }

        public void endArray(JsonArray array) {
            this.writer.append(']');
        }

        public void startObject(JsonObject object) {
            this.writer.append('{');
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) {
            if (!isFirst) {
                this.writer.append(',');
            }
            this.writer.append('\"');
            this.writer.append(memberName);
            this.writer.append("\":");
            this.writer.append(member.toString());
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonArray member, boolean isFirst) {
            if (!isFirst) {
                this.writer.append(',');
            }
            this.writer.append('\"');
            this.writer.append(memberName);
            this.writer.append("\":");
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonObject member, boolean isFirst) {
            if (!isFirst) {
                this.writer.append(',');
            }
            this.writer.append('\"');
            this.writer.append(memberName);
            this.writer.append("\":");
        }

        public void visitNullObjectMember(JsonObject parent, String memberName, boolean isFirst) {
            if (this.serializeNulls) {
                this.visitObjectMember(parent, memberName, (JsonObject)null, isFirst);
            }
        }

        public void endObject(JsonObject object) {
            this.writer.append('}');
        }
    }
}

