/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElementVisitor;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.Preconditions;

class DelegatingJsonElementVisitor
implements JsonElementVisitor {
    private final JsonElementVisitor delegate;

    protected DelegatingJsonElementVisitor(JsonElementVisitor delegate) {
        Preconditions.checkNotNull(delegate);
        this.delegate = delegate;
    }

    public void endArray(JsonArray array) {
        this.delegate.endArray(array);
    }

    public void endObject(JsonObject object) {
        this.delegate.endObject(object);
    }

    public void startArray(JsonArray array) {
        this.delegate.startArray(array);
    }

    public void startObject(JsonObject object) {
        this.delegate.startObject(object);
    }

    public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) {
        this.delegate.visitArrayMember(parent, member, isFirst);
    }

    public void visitArrayMember(JsonArray parent, JsonArray member, boolean isFirst) {
        this.delegate.visitArrayMember(parent, member, isFirst);
    }

    public void visitArrayMember(JsonArray parent, JsonObject member, boolean isFirst) {
        this.delegate.visitArrayMember(parent, member, isFirst);
    }

    public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) {
        this.delegate.visitObjectMember(parent, memberName, member, isFirst);
    }

    public void visitObjectMember(JsonObject parent, String memberName, JsonArray member, boolean isFirst) {
        this.delegate.visitObjectMember(parent, memberName, member, isFirst);
    }

    public void visitObjectMember(JsonObject parent, String memberName, JsonObject member, boolean isFirst) {
        this.delegate.visitObjectMember(parent, memberName, member, isFirst);
    }

    public void visitNullObjectMember(JsonObject parent, String memberName, boolean isFirst) {
        this.delegate.visitNullObjectMember(parent, memberName, isFirst);
    }

    public void visitPrimitive(JsonPrimitive primitive) {
        this.delegate.visitPrimitive(primitive);
    }

    public void visitNull() {
        this.delegate.visitNull();
    }

    public void visitNullArrayMember(JsonArray parent, boolean isFirst) {
        this.delegate.visitNullArrayMember(parent, isFirst);
    }
}

