/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.services.messaging.ThrottleManagerControl;
import flex.messaging.MessageException;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.services.messaging.MessageFrequency;
import java.util.HashMap;
import java.util.Map;

public class ThrottleManager
extends ManageableComponent {
    public static final String LOG_CATEGORY = "Transport.Throttle";
    public static final String TYPE = "ThrottleManager";
    private static final Object classMutex = new Object();
    private static int instanceCount = 0;
    protected ThrottleSettings settings;
    private Map<String, MessageFrequency> inboundClientMarks;
    private MessageFrequency inboundDestinationMark;
    private MessageFrequency outboundDestinationMark;

    public ThrottleManager() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThrottleManager(boolean enableManagement) {
        super(enableManagement);
        Object object = classMutex;
        synchronized (object) {
            super.setId(TYPE + ++instanceCount);
        }
    }

    public void start() {
        if (this.settings == null) {
            this.settings = new ThrottleSettings();
        }
        if (this.settings.isDestinationThrottleEnabled()) {
            this.inboundDestinationMark = new MessageFrequency(this.settings.getIncomingDestinationFrequency());
            this.outboundDestinationMark = new MessageFrequency(this.settings.getOutgoingDestinationFrequency());
        }
        if (this.settings.isInboundClientThrottleEnabled()) {
            this.inboundClientMarks = new HashMap<String, MessageFrequency>();
        }
    }

    public void stop() {
        super.stop();
        if (this.isManaged() && this.getControl() != null) {
            this.getControl().unregister();
            this.setControl(null);
            this.setManaged(false);
        }
    }

    public static ThrottleResult.Result getResult(ThrottleSettings.Policy policy) {
        if (ThrottleSettings.Policy.IGNORE == policy) {
            return ThrottleResult.Result.IGNORE;
        }
        if (ThrottleSettings.Policy.ERROR == policy) {
            return ThrottleResult.Result.ERROR;
        }
        if (ThrottleSettings.Policy.BUFFER == policy) {
            return ThrottleResult.Result.BUFFER;
        }
        if (ThrottleSettings.Policy.CONFLATE == policy) {
            return ThrottleResult.Result.CONFLATE;
        }
        return ThrottleResult.Result.OK;
    }

    public ThrottleSettings.Policy getOutboundPolicy() {
        return this.settings == null ? null : this.settings.getOutboundPolicy();
    }

    public void setId(String id) {
    }

    public void removeClientThrottleMark(Object clientId) {
        if (this.inboundClientMarks != null) {
            this.inboundClientMarks.remove(clientId);
        }
    }

    public void setThrottleSettings(ThrottleSettings throttleSettings) {
        ThrottleSettings.Policy outPolicy = throttleSettings.getOutboundPolicy();
        if (outPolicy != ThrottleSettings.Policy.NONE && outPolicy != ThrottleSettings.Policy.IGNORE) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("Invalid outbound throttle policy '" + (Object)((Object)outPolicy) + "' for destination '" + throttleSettings.getDestinationName() + "'. Valid values are 'NONE' and 'IGNORE'.");
            throw ex;
        }
        this.settings = throttleSettings;
    }

    public boolean throttleIncomingMessage(Message message) {
        boolean throttled;
        ThrottleResult throttleResult = this.throttleDestinationLevel(message, true);
        if (throttleResult.getResult() == ThrottleResult.Result.OK) {
            boolean throttled2;
            throttleResult = this.throttleIncomingClientLevel(message);
            this.handleIncomingThrottleResult(message, throttleResult, true);
            boolean bl = throttled2 = throttleResult.getResult() != ThrottleResult.Result.OK;
            if (!throttled2) {
                this.updateMessageFrequencyDestinationLevel(true);
                this.updateMessageFrequencyIncomingClientLevel(message);
            }
            return throttled2;
        }
        this.handleIncomingThrottleResult(message, throttleResult, false);
        boolean bl = throttled = throttleResult.getResult() != ThrottleResult.Result.OK;
        if (!throttled) {
            this.updateMessageFrequencyDestinationLevel(true);
            this.updateMessageFrequencyIncomingClientLevel(message);
        }
        return throttled;
    }

    public ThrottleResult throttleOutgoingMessage(Message message) {
        ThrottleResult throttleResult = this.throttleDestinationLevel(message, false);
        this.handleOutgoingThrottleResult(message, throttleResult, false);
        return throttleResult;
    }

    public void handleOutgoingThrottleResult(Message message, ThrottleResult throttleResult, boolean isClientLevel) {
        ThrottleResult.Result result = throttleResult.getResult();
        if (result != ThrottleResult.Result.OK && this.isManaged()) {
            if (isClientLevel) {
                ((ThrottleManagerControl)this.getControl()).incrementClientOutgoingMessageThrottleCount();
            } else {
                ((ThrottleManagerControl)this.getControl()).incrementDestinationOutgoingMessageThrottleCount();
            }
        }
        if (result == ThrottleResult.Result.IGNORE) {
            if (isClientLevel) {
                throttleResult.setDetail("Message '" + message.getMessageId() + "' ignored: Too many messages sent to client '" + message.getClientId() + "' in too small of a time interval " + throttleResult.getDetail());
            } else {
                throttleResult.setDetail("Message '" + message.getMessageId() + "' throttled: Too many messages routed by destination '" + message.getDestination() + "' in too small of a time interval " + throttleResult.getDetail());
            }
            if (Log.isInfo()) {
                Log.getLogger((String)LOG_CATEGORY).info(throttleResult.getDetail());
            }
        }
    }

    public ThrottleResult throttleDestinationLevel(Message message, boolean incoming) {
        if (incoming && this.settings.isInboundDestinationThrottleEnabled()) {
            ThrottleResult result = this.inboundDestinationMark.checkLimit(this.settings.getIncomingDestinationFrequency(), this.settings.getInboundPolicy());
            return result;
        }
        if (!incoming && this.settings.isOutboundDestinationThrottleEnabled()) {
            ThrottleResult result = this.outboundDestinationMark.checkLimit(this.settings.getOutgoingDestinationFrequency(), this.settings.getOutboundPolicy());
            return result;
        }
        return new ThrottleResult();
    }

    public void updateMessageFrequencyDestinationLevel(boolean incoming) {
        if (incoming && this.settings.isInboundDestinationThrottleEnabled()) {
            this.inboundDestinationMark.updateMessageFrequency();
        } else if (!incoming && this.settings.isOutboundDestinationThrottleEnabled()) {
            this.outboundDestinationMark.updateMessageFrequency();
        }
    }

    public void updateMessageFrequencyIncomingClientLevel(Message message) {
        MessageFrequency clientLevelMark;
        String clientId = (String)message.getClientId();
        if (this.settings.isInboundClientThrottleEnabled() && (clientLevelMark = this.inboundClientMarks.get(clientId)) != null) {
            clientLevelMark.updateMessageFrequency();
        }
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void handleIncomingThrottleResult(Message message, ThrottleResult throttleResult, boolean isClientLevel) {
        ThrottleResult.Result result = throttleResult.getResult();
        if (result != ThrottleResult.Result.OK && this.isManaged()) {
            if (isClientLevel) {
                ((ThrottleManagerControl)this.getControl()).incrementClientIncomingMessageThrottleCount();
            } else {
                ((ThrottleManagerControl)this.getControl()).incrementDestinationIncomingMessageThrottleCount();
            }
        }
        if (result == ThrottleResult.Result.IGNORE || result == ThrottleResult.Result.ERROR) {
            if (isClientLevel) {
                throttleResult.setDetail("Message '" + message.getMessageId() + "' throttled: Too many messages sent by the client '" + message.getClientId() + "' in too small of a time interval " + throttleResult.getDetail());
            } else {
                throttleResult.setDetail("Message '" + message.getMessageId() + "' throttled: Too many messages sent to destination '" + message.getDestination() + "' in too small of a time interval " + throttleResult.getDetail());
            }
            String detail = throttleResult.getDetail();
            if (result == ThrottleResult.Result.ERROR) {
                if (Log.isError()) {
                    Log.getLogger((String)LOG_CATEGORY).error(detail);
                }
                MessageException me = new MessageException(detail);
                throw me;
            }
            if (Log.isInfo()) {
                Log.getLogger((String)LOG_CATEGORY).info(detail);
            }
        }
    }

    protected ThrottleResult throttleIncomingClientLevel(Message message) {
        String clientId = (String)message.getClientId();
        if (this.settings.isInboundClientThrottleEnabled()) {
            MessageFrequency clientLevelMark = this.inboundClientMarks.get(clientId);
            if (clientLevelMark == null) {
                clientLevelMark = new MessageFrequency(this.settings.getIncomingClientFrequency());
            }
            ThrottleResult result = clientLevelMark.checkLimit(this.settings.getIncomingClientFrequency(), this.settings.getInboundPolicy());
            this.inboundClientMarks.put(clientId, clientLevelMark);
            return result;
        }
        return new ThrottleResult();
    }

    public static class ThrottleResult {
        private String detail;
        private Result result;

        public ThrottleResult() {
            this(Result.OK);
        }

        public ThrottleResult(Result result) {
            this.result = result;
        }

        public ThrottleResult(Result result, String detail) {
            this(result);
            this.detail = detail;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Result {
            OK,
            IGNORE,
            ERROR,
            BUFFER,
            CONFLATE;

        }
    }
}

