/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.management.runtime.messaging.MessageDestinationControl;
import flex.management.runtime.messaging.services.MessageServiceControl;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.MessageClient;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.MessageRoutedNotifier;
import flex.messaging.client.FlushResult;
import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ServerSettings;
import flex.messaging.log.Log;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.services.AbstractService;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.messaging.MessagingConstants;
import flex.messaging.services.messaging.RemoteSubscriptionManager;
import flex.messaging.services.messaging.SubscriptionManager;
import flex.messaging.services.messaging.Subtopic;
import flex.messaging.services.messaging.ThrottleManager;
import flex.messaging.services.messaging.adapters.MessagingAdapter;
import flex.messaging.services.messaging.adapters.MessagingSecurityConstraintManager;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MessageService
extends AbstractService
implements MessagingConstants {
    public static final String LOG_CATEGORY = "Service.Message";
    public static final String TIMING_LOG_CATEGORY = "Message.Timing";
    public static final String NOT_SUBSCRIBED_CODE = "Server.Processing.NotSubscribed";
    private static final int BAD_SELECTOR = 10550;
    private static final int NOT_SUBSCRIBED = 10551;
    private static final int UNKNOWN_COMMAND = 10552;
    private boolean debug;
    private MessageServiceControl controller;
    private ReadWriteLock subscribeLock = new ReentrantReadWriteLock();

    public MessageService() {
        super(false);
    }

    public MessageService(boolean enableManagement) {
        super(enableManagement);
    }

    public void start() {
        MessageDestination dest;
        String serviceType = this.getClass().getName();
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        super.start();
        for (String destName : this.destinations.keySet()) {
            dest = (MessageDestination)this.getDestination(destName);
            if (dest.getServerSettings().isBroadcastRoutingMode() || !dest.isClustered()) continue;
            this.initRemoteSubscriptions(destName);
        }
        for (String destName : this.destinations.keySet()) {
            dest = (MessageDestination)this.getDestination(destName);
            if (dest.getServerSettings().isBroadcastRoutingMode() || !dest.isClustered()) continue;
            List members = clm.getClusterMemberAddresses(serviceType, destName);
            for (Object addr : members) {
                if (clm.getLocalAddress(serviceType, destName).equals(addr)) continue;
                RemoteSubscriptionManager subMgr = dest.getRemoteSubscriptionManager();
                subMgr.waitForSubscriptions(addr);
            }
        }
        this.debug = Log.isDebug();
    }

    public Destination createDestination(String id) {
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Destination", "Service"});
            throw ex;
        }
        this.getMessageBroker().isDestinationRegistered(id, this.getId(), true);
        MessageDestination destination = new MessageDestination();
        destination.setId(id);
        destination.setManaged(this.isManaged());
        destination.setService(this);
        return destination;
    }

    public void addDestination(Destination destination) {
        MessageDestination messageDestination = (MessageDestination)destination;
        super.addDestination(messageDestination);
    }

    public Object serviceMessage(Message message) {
        return this.serviceMessage(message, true);
    }

    public Object serviceMessage(Message message, boolean throttle) {
        return this.serviceMessage(message, throttle, null);
    }

    public Object serviceMessage(Message message, boolean throttle, MessageDestination dest) {
        MessagingSecurityConstraintManager manager;
        ServiceAdapter serviceAdapter;
        ServerSettings destServerSettings;
        ThrottleManager throttleManager;
        if (this.managed) {
            this.incrementMessageCount(false, message);
        }
        if (throttle && (throttleManager = (dest = (MessageDestination)this.getDestination(message)).getThrottleManager()) != null && throttleManager.throttleIncomingMessage(message)) {
            return null;
        }
        List<Object> subtopicObj = message.getHeader("DSSubtopic");
        ArrayList<Subtopic> subtopics = null;
        if (subtopicObj != null) {
            if (subtopicObj instanceof Object[]) {
                subtopicObj = Arrays.asList((Object[])subtopicObj);
            }
            if (subtopicObj instanceof String) {
                String subtopicString = (String)((Object)subtopicObj);
                if (subtopicString != null && subtopicString.length() > 0) {
                    if (dest == null) {
                        dest = (MessageDestination)this.getDestination(message);
                    }
                    Subtopic subtopic = this.testProducerSubtopic(dest.getServerSettings().getSubtopicSeparator(), subtopicString);
                    if (subtopics == null) {
                        subtopics = new ArrayList<Subtopic>();
                    }
                    subtopics.add(subtopic);
                }
            } else if (subtopicObj instanceof List) {
                List<Object> subtopicList = subtopicObj;
                String subtopicSeperator = null;
                for (String string : subtopicList) {
                    if (string == null || string.length() <= 0) continue;
                    if (dest == null) {
                        dest = (MessageDestination)this.getDestination(message);
                    }
                    subtopicSeperator = dest.getServerSettings().getSubtopicSeparator();
                    Subtopic subtopic = this.testProducerSubtopic(subtopicSeperator, string);
                    if (subtopics == null) {
                        subtopics = new ArrayList();
                    }
                    subtopics.add(subtopic);
                }
            }
        }
        if (dest == null) {
            dest = (MessageDestination)this.getDestination(message);
        }
        if ((destServerSettings = dest.getServerSettings()).getMessageTTL() >= 0L) {
            message.setTimeToLive(destServerSettings.getMessageTTL());
        }
        long start = 0L;
        if (this.debug) {
            start = System.currentTimeMillis();
        }
        if ((serviceAdapter = dest.getAdapter()) instanceof MessagingAdapter && (manager = ((MessagingAdapter)serviceAdapter).getSecurityConstraintManager()) != null) {
            manager.assertSendAuthorization();
        }
        MessagePerformanceUtils.markServerPreAdapterTime(message);
        Object result = serviceAdapter.invoke(message);
        MessagePerformanceUtils.markServerPostAdapterTime(message);
        if (this.debug) {
            long end = System.currentTimeMillis();
            Log.getLogger((String)TIMING_LOG_CATEGORY).debug("After invoke service: " + this.getId() + "; execution time = " + (end - start) + "ms");
        }
        return result;
    }

    public Object serviceCommand(CommandMessage message) {
        Object commandResult;
        if (this.managed) {
            this.incrementMessageCount(true, message);
        }
        if ((commandResult = super.serviceCommonCommands(message)) == null) {
            commandResult = this.manageSubscriptions(message);
        }
        return commandResult;
    }

    public void serviceMessageFromAdapter(Message message, boolean sendToAllSubscribers) {
        MessageDestinationControl destinationControl;
        MessageDestination destination;
        if (this.managed && (destination = (MessageDestination)this.getDestination(message.getDestination())) != null && destination.isManaged() && (destinationControl = (MessageDestinationControl)destination.getControl()) != null) {
            destinationControl.incrementServiceMessageFromAdapterCount();
        }
        if (sendToAllSubscribers) {
            this.pushMessageToClients(message, false);
            this.sendPushMessageFromPeer(message, false);
        } else {
            TreeSet<Object> subscriberIds = new TreeSet<Object>();
            subscriberIds.add(message.getClientId());
            this.pushMessageToClients(subscriberIds, message, false);
        }
    }

    public void sendPushMessageFromPeer(Message message, boolean evalSelector) {
        this.sendPushMessageFromPeer(message, (MessageDestination)this.getDestination(message), evalSelector);
    }

    public void sendPushMessageFromPeer(Message message, MessageDestination destination, boolean evalSelector) {
        if (!destination.isClustered()) {
            return;
        }
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        if (destination.getServerSettings().isBroadcastRoutingMode()) {
            if (this.debug) {
                Log.getLogger((String)LOG_CATEGORY).debug("Broadcasting message to peer servers: " + message + " evalSelector: " + evalSelector);
            }
            clm.invokeServiceOperation(this.getClass().getName(), message.getDestination(), "pushMessageFromPeer", new Object[]{message, evalSelector});
        } else {
            RemoteSubscriptionManager mgr = destination.getRemoteSubscriptionManager();
            Set<Object> serverAddresses = mgr.getSubscriberIds(message, evalSelector);
            if (this.debug) {
                Log.getLogger((String)LOG_CATEGORY).debug("Sending message to peer servers: " + serverAddresses + StringUtils.NEWLINE + " message: " + message + StringUtils.NEWLINE + " evalSelector: " + evalSelector);
            }
            for (Object remoteAddress : serverAddresses) {
                clm.invokePeerToPeerOperation(this.getClass().getName(), message.getDestination(), "pushMessageFromPeerToPeer", new Object[]{message, evalSelector}, remoteAddress);
            }
        }
    }

    public void pushMessageFromPeerToPeer(AsyncMessage message, Boolean evalSelector, Object address) {
        this.pushMessageFromPeer(message, evalSelector);
    }

    public void pushMessageFromPeer(AsyncMessage message, Boolean evalSelector) {
        if (!this.isStarted()) {
            Log.getLogger((String)LOG_CATEGORY).debug("Received message from peer server before server is started - ignoring: " + message + " evalSelector: " + evalSelector);
            return;
        }
        if (this.debug) {
            Log.getLogger((String)LOG_CATEGORY).debug("Received message from peer server: " + message + " evalSelector: " + evalSelector);
        }
        FlexContext.setMessageFromPeer(true);
        this.pushMessageToClients(message, evalSelector);
        FlexContext.setMessageFromPeer(false);
    }

    public void pushMessageToClients(Message message, boolean evalSelector) {
        MessageDestination destination = (MessageDestination)this.getDestination(message);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        Set<Object> subscriberIds = subscriptionManager.getSubscriberIds(message, evalSelector);
        if (this.debug) {
            Log.getLogger((String)LOG_CATEGORY).debug("Sending message: " + message + StringUtils.NEWLINE + "    to subscribed clientIds: " + subscriberIds);
        }
        if (subscriberIds != null && !subscriberIds.isEmpty()) {
            this.pushMessageToClients(destination, subscriberIds, message, false);
        }
    }

    public Set getSubscriberIds(Message message, boolean evalSelector) {
        MessageDestination destination = (MessageDestination)this.getDestination(message);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        return subscriptionManager.getSubscriberIds(message, evalSelector);
    }

    public Set getSubscriberIds(String destinationId, String subtopicPattern, Map messageHeaders) {
        MessageDestination destination = (MessageDestination)this.getDestination(destinationId);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        return subscriptionManager.getSubscriberIds(subtopicPattern, messageHeaders);
    }

    public void pushMessageToClients(Set subscriberIds, Message message, boolean evalSelector) {
        MessageDestination destination = (MessageDestination)this.getDestination(message);
        this.pushMessageToClients(destination, subscriberIds, message, evalSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessageToClients(MessageDestination destination, Set subscriberIds, Message message, boolean evalSelector) {
        if (subscriberIds != null) {
            try {
                MessageRoutedNotifier routingNotifier = new MessageRoutedNotifier(message);
                FlexContext.setMessageRoutedNotifier(routingNotifier);
                SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
                for (Object clientId : subscriberIds) {
                    MessageClient client = subscriptionManager.getSubscriber(clientId);
                    if (client == null || !client.isValid()) {
                        if (!this.debug) continue;
                        Log.getLogger((String)LOG_CATEGORY).debug("Warning: could not find MessageClient for clientId in pushMessageToClients: " + clientId + " for destination: " + destination.getId());
                        continue;
                    }
                    this.pushMessageToClient(client, destination, message, evalSelector);
                }
                routingNotifier.notifyMessageRouted();
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                FlexContext.setMessageRoutedNotifier(null);
                throw throwable;
            }
            FlexContext.setMessageRoutedNotifier(null);
            {
            }
        }
    }

    void pushMessageToClient(MessageClient client, MessageDestination destination, Message message, boolean evalSelector) {
        if (evalSelector && !client.testMessage(message, destination)) {
            return;
        }
        try {
            Object header;
            if (!(message instanceof CommandMessage)) {
                client.updateLastUse();
            }
            Map messageHeaders = message.getHeaders();
            messageHeaders.remove("DSId");
            messageHeaders.remove("DSEndpoint");
            int priority = destination.getServerSettings().getPriority();
            if (priority != -1 && (header = message.getHeader("DSPriority")) == null) {
                message.setHeader("DSPriority", priority);
            }
            Message messageForClient = (Message)message.clone();
            MessagePerformanceUtils.markServerPrePushTime(message);
            MessagePerformanceUtils.markServerPostAdapterTime(message);
            MessagePerformanceUtils.markServerPostAdapterExternalTime(message);
            messageForClient.setClientId(client.getClientId());
            if (this.debug) {
                Log.getLogger((String)LOG_CATEGORY).debug("Routing message to FlexClient id:" + client.getFlexClient().getId() + "', MessageClient id: " + client.getClientId());
            }
            this.getMessageBroker().routeMessageToMessageClient(messageForClient, client);
        }
        catch (MessageException ignore) {
            // empty catch block
        }
    }

    public void initRemoteSubscriptions(String destinationId) {
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        String serviceType = this.getClass().getName();
        MessageDestination dest = (MessageDestination)this.getDestination(destinationId);
        Cluster cluster = clm.getCluster(serviceType, destinationId);
        if (cluster != null) {
            cluster.addRemoveNodeListener(dest.getRemoteSubscriptionManager());
        }
        List members = clm.getClusterMemberAddresses(serviceType, destinationId);
        for (int i = 0; i < members.size(); ++i) {
            Object addr = members.get(i);
            if (clm.getLocalAddress(serviceType, destinationId).equals(addr)) continue;
            this.requestSubscriptions(destinationId, addr);
        }
    }

    public void requestSubscriptions(String destinationId, Object remoteAddress) {
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        clm.invokePeerToPeerOperation(this.getClass().getName(), destinationId, "sendSubscriptions", new Object[]{destinationId}, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSubscriptions(String destinationId, Object remoteAddress) {
        MessageDestination destination = (MessageDestination)this.getDestination(destinationId);
        if (destination == null) {
            if (Log.isError()) {
                Log.getLogger((String)LOG_CATEGORY).error("Destination: " + destinationId + " does not exist on this server but we received a request for the subscription info from a peer server where the destination exists as clustered.  Check the cluster configuration for this destination and make sure it matches on all servers.");
            }
            return;
        }
        if (!destination.isClustered()) {
            if (Log.isError()) {
                Log.getLogger((String)LOG_CATEGORY).error("Destination: " + destinationId + " is not clustered on this server but we received a request for the subscription info from a peer server which is clustered.  Check the cluster configuration for this destination and make sure it matches on all servers.");
            }
            return;
        }
        RemoteSubscriptionManager subMgr = destination.getRemoteSubscriptionManager();
        subMgr.setSubscriptionState(Collections.EMPTY_LIST, remoteAddress);
        try {
            this.subscribeLock.writeLock().lock();
            Object subscriptions = destination.getSubscriptionManager().getSubscriptionState();
            ClusterManager clm = this.getMessageBroker().getClusterManager();
            clm.invokePeerToPeerOperation(this.getClass().getName(), destinationId, "receiveSubscriptions", new Object[]{destinationId, subscriptions}, remoteAddress);
            Object var8_7 = null;
            this.subscribeLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.subscribeLock.writeLock().unlock();
            throw throwable;
        }
    }

    public void receiveSubscriptions(String destinationId, Object subscriptions, Object senderAddress) {
        Destination destination = this.getDestination(destinationId);
        if (destination instanceof MessageDestination) {
            ((MessageDestination)destination).getRemoteSubscriptionManager().setSubscriptionState(subscriptions, senderAddress);
        } else if (subscriptions != null && Log.isError()) {
            Log.getLogger((String)LOG_CATEGORY).error("receiveSubscriptions called with non-null value but destination: " + destinationId + " is not a MessageDestination");
        }
    }

    public void sendSubscribeFromPeer(String destinationId, Boolean subscribe, String selector, String subtopic) {
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        String serviceType = this.getClass().getName();
        clm.invokeServiceOperation(serviceType, destinationId, "subscribeFromPeer", new Object[]{destinationId, subscribe, selector, subtopic, clm.getLocalAddress(serviceType, destinationId)});
    }

    public void subscribeFromPeer(String destinationId, Boolean subscribe, String selector, String subtopic, Object remoteAddress) {
        Destination destination = this.getDestination(destinationId);
        RemoteSubscriptionManager subMgr = ((MessageDestination)destination).getRemoteSubscriptionManager();
        if (destination instanceof MessageDestination) {
            if (this.debug) {
                Log.getLogger((String)LOG_CATEGORY).debug("Received subscription from peer: " + remoteAddress + " subscribe? " + subscribe + " selector: " + selector + " subtopic: " + subtopic);
            }
            if (subscribe.booleanValue()) {
                subMgr.addSubscriber(remoteAddress, selector, subtopic, null);
            } else {
                subMgr.removeSubscriber(remoteAddress, selector, subtopic, null);
            }
        } else if (Log.isError()) {
            Log.getLogger((String)LOG_CATEGORY).error("subscribeFromPeer called with destination: " + destinationId + " that is not a MessageDestination");
        }
    }

    protected void incrementMessageCount(boolean commandMessage, Message message) {
        MessageDestinationControl destinationControl;
        MessageDestination destination;
        if (this.managed && (destination = (MessageDestination)this.getDestination(message.getDestination())) != null && destination.isManaged() && (destinationControl = (MessageDestinationControl)destination.getControl()) != null) {
            if (commandMessage) {
                destinationControl.incrementServiceCommandCount();
            } else {
                destinationControl.incrementServiceMessageCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message manageSubscriptions(CommandMessage command) {
        Message replyMessage = null;
        MessageDestination destination = (MessageDestination)this.getDestination(command);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        Object clientId = command.getClientId();
        String endpointId = (String)command.getHeader("DSEndpoint");
        String subtopicString = (String)command.getHeader("DSSubtopic");
        ServiceAdapter adapter = destination.getAdapter();
        if (command.getOperation() == 0) {
            MessagingSecurityConstraintManager manager;
            String selectorExpr = (String)command.getHeader("DSSelector");
            this.getMessageBroker().inspectChannel(command, destination);
            if (adapter instanceof MessagingAdapter && (manager = ((MessagingAdapter)adapter).getSecurityConstraintManager()) != null) {
                manager.assertSubscribeAuthorization();
            }
            try {
                this.subscribeLock.readLock().lock();
                if (adapter.handlesSubscriptions()) {
                    replyMessage = (Message)adapter.manage(command);
                } else {
                    this.testSelector(selectorExpr, command);
                }
                int maxFrequency = this.processMaxFrequencyHeader(command);
                subscriptionManager.addSubscriber(clientId, selectorExpr, subtopicString, endpointId, maxFrequency);
                Object var12_19 = null;
                this.subscribeLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                this.subscribeLock.readLock().unlock();
                throw throwable;
            }
            if (replyMessage == null) {
                replyMessage = new AcknowledgeMessage();
            }
        } else if (command.getOperation() == 1) {
            MessagingSecurityConstraintManager manager;
            if (adapter instanceof MessagingAdapter && command.getHeader("DSSubscriptionInvalidated") == null && (manager = ((MessagingAdapter)adapter).getSecurityConstraintManager()) != null) {
                manager.assertSubscribeAuthorization();
            }
            String selectorExpr = (String)command.getHeader("DSSelector");
            try {
                this.subscribeLock.readLock().lock();
                if (adapter.handlesSubscriptions()) {
                    replyMessage = (Message)adapter.manage(command);
                }
                subscriptionManager.removeSubscriber(clientId, selectorExpr, subtopicString, endpointId);
                Object var14_28 = null;
                this.subscribeLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var14_29 = null;
                this.subscribeLock.readLock().unlock();
                throw throwable;
            }
            if (replyMessage == null) {
                replyMessage = new AcknowledgeMessage();
            }
        } else if (command.getOperation() == 11) {
            MessagingSecurityConstraintManager manager;
            this.getMessageBroker().inspectChannel(command, destination);
            if (adapter instanceof MessagingAdapter && (manager = ((MessagingAdapter)adapter).getSecurityConstraintManager()) != null) {
                manager.assertSubscribeAuthorization();
            }
            try {
                this.subscribeLock.readLock().lock();
                if (adapter.handlesSubscriptions()) {
                    replyMessage = (Message)adapter.manage(command);
                }
                Object[] adds = this.getObjectArrayFromHeader(command.getHeader("DSAddSub"));
                Object[] rems = this.getObjectArrayFromHeader(command.getHeader("DSRemSub"));
                if (adds != null) {
                    int maxFrequency = this.processMaxFrequencyHeader(command);
                    for (int i = 0; i < adds.length; ++i) {
                        int ix2;
                        int maxFrequencyPerSubscription = maxFrequency;
                        String ss = (String)adds[i];
                        int ix = ss.indexOf("_;_");
                        if (ix == -1) continue;
                        String subtopic = ix == 0 ? null : ss.substring(0, ix);
                        String selector = null;
                        String selectorAndMaxFrequency = ss.substring(ix + "_;_".length());
                        if (selectorAndMaxFrequency.length() != 0 && (ix2 = selectorAndMaxFrequency.indexOf("_;_")) != -1) {
                            selector = ix2 == 0 ? null : selectorAndMaxFrequency.substring(0, ix2);
                            String maxFrequencyString = selectorAndMaxFrequency.substring(ix2 + "_;_".length());
                            if (maxFrequencyString.length() != 0) {
                                int maxFrequencyCandidate = Integer.parseInt(maxFrequencyString);
                                maxFrequencyPerSubscription = maxFrequencyPerSubscription == 0 ? maxFrequencyCandidate : Math.min(maxFrequencyPerSubscription, maxFrequencyCandidate);
                            }
                        }
                        subscriptionManager.addSubscriber(clientId, selector, subtopic, endpointId, maxFrequencyPerSubscription);
                    }
                }
                if (rems != null) {
                    for (int i = 0; i < rems.length; ++i) {
                        int ix2;
                        String ss = (String)rems[i];
                        int ix = ss.indexOf("_;_");
                        if (ix == -1) continue;
                        String subtopic = ix == 0 ? null : ss.substring(0, ix);
                        String selector = null;
                        String selectorAndMaxFrequency = ss.substring(ix + "_;_".length());
                        if (selectorAndMaxFrequency.length() != 0 && (ix2 = selectorAndMaxFrequency.indexOf("_;_")) != -1) {
                            selector = ix2 == 0 ? null : selectorAndMaxFrequency.substring(0, ix2);
                        }
                        subscriptionManager.removeSubscriber(clientId, selector, subtopic, endpointId);
                    }
                }
                Object var23_43 = null;
                this.subscribeLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var23_44 = null;
                this.subscribeLock.readLock().unlock();
                throw throwable;
            }
            if (replyMessage == null) {
                replyMessage = new AcknowledgeMessage();
            }
        } else if (command.getOperation() == 2) {
            MessageClient client = null;
            try {
                client = subscriptionManager.getMessageClient(clientId, endpointId);
                if (client != null) {
                    FlushResult flushResult;
                    List<Message> messagesToReturn;
                    List missedMessages;
                    if (adapter.handlesSubscriptions() && (missedMessages = (List)adapter.manage(command)) != null && !missedMessages.isEmpty()) {
                        MessageBroker broker = this.getMessageBroker();
                        Iterator iter = missedMessages.iterator();
                        while (iter.hasNext()) {
                            broker.routeMessageToMessageClient((Message)iter.next(), client);
                        }
                    }
                    List<Message> list = messagesToReturn = (flushResult = client.getFlexClient().poll(client)) != null ? flushResult.getMessages() : null;
                    if (messagesToReturn != null && !messagesToReturn.isEmpty()) {
                        replyMessage = new CommandMessage(4);
                        replyMessage.setBody(messagesToReturn.toArray());
                    } else {
                        replyMessage = new AcknowledgeMessage();
                    }
                } else {
                    ServiceException se = new ServiceException();
                    se.setCode(NOT_SUBSCRIBED_CODE);
                    se.setMessage(10551, new Object[]{destination.getId()});
                    throw se;
                }
                Object var25_46 = null;
                subscriptionManager.releaseMessageClient(client);
            }
            catch (Throwable throwable) {
                Object var25_47 = null;
                subscriptionManager.releaseMessageClient(client);
                throw throwable;
            }
        } else {
            ServiceException se = new ServiceException();
            se.setMessage(10552, new Object[]{new Integer(command.getOperation())});
            throw se;
        }
        return replyMessage;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupServiceControl(MessageBroker broker) {
        this.controller = new MessageServiceControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }

    private void testSelector(String selectorExpression, Message msg) {
        try {
            JMSSelector selector = new JMSSelector(selectorExpression);
            selector.match(msg);
        }
        catch (Exception e) {
            ServiceException se = new ServiceException();
            se.setMessage(10550, new Object[]{selectorExpression});
            se.setRootCause(e);
            throw se;
        }
    }

    private int processMaxFrequencyHeader(CommandMessage command) {
        Object maxFrequencyHeader = command.getHeader("DSMaxFrequency");
        if (maxFrequencyHeader != null) {
            return (Integer)maxFrequencyHeader;
        }
        return 0;
    }

    private Subtopic testProducerSubtopic(String subtopicSeparator, String subtopicString) {
        Subtopic subtopic = new Subtopic(subtopicString, subtopicSeparator);
        if (subtopic.containsSubtopicWildcard()) {
            ServiceException se = new ServiceException();
            se.setMessage(10556, new Object[]{subtopicString});
            throw se;
        }
        return subtopic;
    }

    private Object[] getObjectArrayFromHeader(Object header) {
        if (header instanceof Object[]) {
            return (Object[])header;
        }
        if (header instanceof List) {
            return ((List)header).toArray();
        }
        if (header == null) {
            return null;
        }
        ServiceException se = new ServiceException();
        se.setMessage("Invalid header: " + header + " in message.  expected array or list and found: " + header.getClass().getName());
        throw se;
    }
}

