/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.io.amfx.AmfxTypes;
import flex.messaging.util.Hex;
import flex.messaging.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class AmfxOutput
extends AbstractAmfOutput
implements AmfxTypes {
    protected IdentityHashMap objectTable = new IdentityHashMap(64);
    protected HashMap traitsTable = new HashMap(10);
    protected HashMap stringTable = new HashMap(64);

    public AmfxOutput(SerializationContext context) {
        super(context);
    }

    public void reset() {
        super.reset();
        this.objectTable.clear();
        this.traitsTable.clear();
        this.stringTable.clear();
    }

    protected Amf3Output createAMF3Output() {
        return new Amf3Output(this.context);
    }

    public void writeObject(Object o) throws IOException {
        if (o == null) {
            this.writeAMFNull();
            return;
        }
        if (!this.context.legacyExternalizable && o instanceof Externalizable) {
            this.writeCustomObject(o);
        } else if (o instanceof String || o instanceof Character) {
            String s = o.toString();
            this.writeString(s);
        } else if (o instanceof Number) {
            if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
                int i = ((Number)o).intValue();
                this.writeAMFInt(i);
            } else if (!this.context.legacyBigNumbers && (o instanceof BigInteger || o instanceof BigDecimal)) {
                this.writeString(((Number)o).toString());
            } else {
                double d = ((Number)o).doubleValue();
                this.writeAMFDouble(d);
            }
        } else if (o instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o);
        } else if (o instanceof Date) {
            this.writeDate((Date)o);
        } else if (o instanceof Calendar) {
            this.writeDate(((Calendar)o).getTime());
        } else if (o instanceof Document) {
            String xml = this.documentToString(o);
            int len = xml.length() + 15;
            StringBuffer sb = new StringBuffer(len);
            sb.append("<xml>");
            this.writeEscapedString(sb, xml);
            sb.append("</xml>");
            this.writeUTF(sb);
            if (this.isDebug) {
                this.trace.writeString(xml);
            }
        } else if (o instanceof Enum && PropertyProxyRegistry.getRegistry().getProxy(o.getClass()) == null) {
            Enum enumValue = (Enum)o;
            this.writeString(enumValue.name());
        } else {
            Class<?> cls = o.getClass();
            if (o instanceof Map && this.context.legacyMap && !(o instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o);
            } else if (o instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o, null);
                } else {
                    this.writeArrayCollection((Collection)o, null);
                }
            } else if (cls.isArray()) {
                this.writeAMFArray(o, cls.getComponentType());
            } else {
                if (o instanceof RowSet) {
                    o = new PagedRowSet((RowSet)o, Integer.MAX_VALUE, false);
                } else if (o instanceof Throwable && this.context.legacyThrowable) {
                    o = new StatusInfoProxy((Throwable)o);
                }
                this.writeCustomObject(o);
            }
        }
    }

    public void writeObjectTraits(TraitsInfo ti) throws IOException {
        String className = ti.getClassName();
        if (className == null || className.length() == 0) {
            this.writeUTF("<object>");
        } else {
            int len = 127;
            StringBuffer sb = new StringBuffer(len);
            sb.append("<").append("object").append(" type=\"");
            sb.append(className);
            sb.append("\">");
            this.writeUTF(sb);
        }
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.objectTable.size() - 1);
        }
        if (ti.length() == 0 && className == null) {
            this.writeUTF("<traits/>");
        } else if (!this.byReference(ti)) {
            if (ti.isExternalizable()) {
                this.writeUTF("<traits externalizable=\"true\" />");
            } else {
                int count = ti.getProperties().size();
                if (count <= 0) {
                    this.writeUTF("<traits/>");
                } else {
                    this.writeUTF("<traits>");
                    for (int i = 0; i < count; ++i) {
                        String propName = ti.getProperty(i);
                        this.writeString(propName, true);
                    }
                    this.writeUTF("</traits>");
                }
            }
        }
    }

    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.writeObject(value);
    }

    public void writeObjectEnd() throws IOException {
        this.writeUTF("</object>");
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    public void writeUTF(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF-8");
        this.out.write(bytes);
    }

    protected void writeAMFBoolean(boolean b) throws IOException {
        if (b) {
            this.writeUTF("<true/>");
        } else {
            this.writeUTF("<false/>");
        }
        if (this.isDebug) {
            this.trace.write(b);
        }
    }

    protected void writeAMFDouble(double d) throws IOException {
        int buflen = 40;
        StringBuffer sb = new StringBuffer(buflen);
        sb.append("<double>");
        sb.append(d);
        sb.append("</double>");
        this.writeUTF(sb);
        if (this.isDebug) {
            this.trace.write(d);
        }
    }

    protected void writeAMFInt(int i) throws IOException {
        int buflen = 25;
        StringBuffer sb = new StringBuffer(buflen);
        sb.append("<int>");
        sb.append(i);
        sb.append("</int>");
        this.writeUTF(sb);
        if (this.isDebug) {
            this.trace.write(i);
        }
    }

    protected void writeByteArray(byte[] ba) throws IOException {
        int length = ba.length * 2;
        int len = 23 + length;
        StringBuffer sb = new StringBuffer(len);
        sb.append("<bytearray>");
        this.writeUTF(sb);
        Hex.Encoder encoder = new Hex.Encoder(ba.length * 2);
        encoder.encode(ba);
        String encoded = encoder.drain();
        this.writeUTF(encoded);
        this.writeUTF("</bytearray>");
        if (this.isDebug) {
            this.trace.startByteArray(this.objectTable.size() - 1, ba.length);
        }
    }

    protected void writeByteArray(Byte[] ba) throws IOException {
        int length = ba.length;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            Byte b = ba[i];
            bytes[i] = b == null ? (byte)0 : ba[i];
        }
        this.writeByteArray(bytes);
    }

    public void writeUTF(StringBuffer sb) throws IOException {
        byte[] bytes = sb.toString().getBytes("UTF-8");
        this.out.write(bytes);
    }

    protected void writeDate(Date d) throws IOException {
        if (!this.byReference(d)) {
            int buflen = 30;
            long time = d.getTime();
            StringBuffer sb = new StringBuffer(buflen);
            sb.append("<date>");
            sb.append(time);
            sb.append("</date>");
            this.writeUTF(sb);
            if (this.isDebug) {
                this.trace.write(d);
            }
        }
    }

    protected void writeMapAsECMAArray(Map map) throws IOException {
        int len = 20;
        StringBuffer sb = new StringBuffer(len);
        sb.append("<").append("array").append(" ecma=\"true\">");
        this.writeUTF(sb);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectTable.size() - 1);
        }
        for (Object key : map.keySet()) {
            if (key == null) continue;
            String propName = key.toString();
            sb = new StringBuffer();
            sb.append("<").append("item").append(" name=\"").append(propName).append("\">");
            this.writeUTF(sb);
            if (this.isDebug) {
                this.trace.namedElement(propName);
            }
            this.writeObject(map.get(key));
            this.writeUTF("</item>");
        }
        this.writeUTF("</array>");
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
    }

    protected void writeAMFNull() throws IOException {
        this.writeUTF("<null/>");
        if (this.isDebug) {
            this.trace.writeNull();
        }
    }

    protected void writeString(String s) throws IOException {
        this.writeString(s, false);
        if (this.isDebug) {
            this.trace.writeString(s);
        }
    }

    protected void writeAMFArray(Object o, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o);
        } else if (componentType.equals(Byte.class)) {
            this.writeByteArray((Byte[])o);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o);
        } else {
            this.writeObjectArray((Object[])o, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        if (!this.byReference(col)) {
            ArrayCollection ac;
            if (col instanceof ArrayCollection) {
                ac = (ArrayCollection)col;
            } else {
                ac = new ArrayCollection(col);
                if (desc != null) {
                    ac.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac);
            this.writePropertyProxy(proxy, ac);
        }
    }

    protected void writeCustomObject(Object o) throws IOException {
        PropertyProxy proxy = null;
        if (o instanceof PropertyProxy) {
            proxy = (PropertyProxy)o;
            if ((o = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o, proxy.getDescriptor());
                }
                return;
            }
            if (o.getClass().isArray()) {
                this.writeObjectArray((Object[])o, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o instanceof Map && !(o instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o);
                return;
            }
        }
        if (!this.byReference(o)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o);
            }
            this.writePropertyProxy(proxy, o);
        }
    }

    protected void writePropertyProxy(PropertyProxy pp, Object instance) throws IOException {
        Object newInst = pp.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + pp.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            pp = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        List propertyNames = null;
        boolean externalizable = pp.isExternalizable(instance);
        if (!externalizable) {
            propertyNames = pp.getPropertyNames(instance);
            if (pp instanceof BeanProxy) {
                BeanProxy bp = (BeanProxy)pp;
                Iterator it = propertyNames.iterator();
                while (it.hasNext()) {
                    String propName = (String)it.next();
                    if (!bp.isWriteOnly(instance, propName)) continue;
                    it.remove();
                }
            }
        }
        TraitsInfo ti = new TraitsInfo(pp.getAlias(instance), pp.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti);
        if (externalizable) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Amf3Output objOut = this.createAMF3Output();
            objOut.setOutputStream(bout);
            ((Externalizable)instance).writeExternal(objOut);
            this.writeByteArray(bout.toByteArray());
        } else if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = pp.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writeString(String s, boolean isTrait) throws IOException {
        if (s.length() == 0) {
            this.writeUTF("<string/>");
        } else if (!this.byReference(s)) {
            int len = s.length() + 35;
            StringBuffer sb = new StringBuffer(len);
            sb.append("<string>");
            if (!isTrait) {
                this.writeEscapedString(sb, s);
            } else {
                sb.append(s);
            }
            sb.append("</string>");
            this.writeUTF(sb);
        }
    }

    protected void writeEscapedString(StringBuffer sb, String s) {
        StringBuffer temp = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= ' ') {
                if (c == '&') {
                    temp.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    temp.append("&lt;");
                    continue;
                }
                if (c > '\ud7ff' && (c < '\ue000' || c > '\ufffd')) {
                    temp.append("&#x").append(Integer.toHexString(c)).append(";");
                    continue;
                }
                temp.append(c);
                continue;
            }
            if (c == '\t' || c == '\n' || c == '\r') {
                temp.append(c);
                continue;
            }
            temp.append("&#x").append(Integer.toHexString(c)).append(";");
        }
        sb.append(temp);
    }

    protected void writeCharArrayAsString(Character[] ca) throws IOException {
        int length = ca.length;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            Character c = ca[i];
            chars[i] = c == null ? (char)'\u0000' : ca[i].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca) throws IOException {
        String str = new String(ca);
        this.writeString(str);
    }

    protected void writeCollection(Collection c, SerializationDescriptor descriptor) throws IOException {
        if (!this.byReference(c)) {
            this.writeObjectArrayDirectly(c.toArray(), descriptor);
        }
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        if (!this.byReference(values)) {
            this.writeObjectArrayDirectly(values, descriptor);
        }
    }

    protected void writeObjectArrayDirectly(Object[] values, SerializationDescriptor descriptor) throws IOException {
        int len = 25;
        StringBuffer sb = new StringBuffer(len);
        sb.append("<").append("array").append(" length=\"");
        sb.append(values.length);
        sb.append("\">");
        this.writeUTF(sb);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectTable.size() - 1);
        }
        for (int i = 0; i < values.length; ++i) {
            if (this.isDebug) {
                this.trace.arrayElement(i);
            }
            this.writeObject(values[i]);
        }
        this.writeUTF("</array>");
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        Class<?> aType = obj.getClass().getComponentType();
        if (aType.equals(Character.TYPE)) {
            char[] c = (char[])obj;
            this.writeCharArrayAsString(c);
        } else if (aType.equals(Byte.TYPE)) {
            this.writeByteArray((byte[])obj);
        } else if (!this.byReference(obj)) {
            int length = Array.getLength(obj);
            int buflen = 25;
            StringBuffer sb = new StringBuffer(buflen);
            sb.append("<").append("array").append(" length=\"");
            sb.append(length);
            sb.append("\">");
            this.writeUTF(sb);
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            if (aType.equals(Boolean.TYPE)) {
                boolean[] b = (boolean[])obj;
                for (int i = 0; i < b.length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    this.writeAMFBoolean(b[i]);
                }
            } else if (aType.equals(Integer.TYPE) || aType.equals(Short.TYPE)) {
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    int v = Array.getInt(obj, i);
                    this.writeAMFInt(v);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    double v = Array.getDouble(obj, i);
                    this.writeAMFDouble(v);
                }
            }
            this.writeUTF("</array>");
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(Object o) throws IOException {
        ref = this.objectTable.get(o);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("ref").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!this.isDebug) ** GOTO lbl21
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Object reference is not an Integer");
            }
        } else {
            this.objectTable.put(o, new Integer(this.objectTable.size()));
        }
lbl21:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(String s) throws IOException {
        ref = this.stringTable.get(s);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("string").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl21
                this.trace.writeStringRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("String reference is not an Integer");
            }
        } else {
            this.stringTable.put(s, new Integer(this.stringTable.size()));
        }
lbl21:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(TraitsInfo ti) throws IOException {
        if (ti.length() == 0 && ti.getClassName() == null) {
            return false;
        }
        ref = this.traitsTable.get(ti);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("traits").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl23
                this.trace.writeTraitsInfoRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Traits reference is not an Integer");
            }
        } else {
            this.traitsTable.put(ti, new Integer(this.traitsTable.size()));
        }
lbl23:
        // 3 sources

        return ref != null;
    }
}

