/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.AbstractMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SerializationFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10306;
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private Logger logger;

    public SerializationFilter(String logCategory) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger((String)logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void invoke(ActionContext context) throws IOException {
        block50: {
            block49: {
                block48: {
                    success = false;
                    debugTrace = Log.isDebug() != false && this.logger.hasTarget() != false ? new AmfTrace() : null;
                    context.setResponseMessage(new ActionMessage());
                    sc = SerializationContext.getSerializationContext();
                    try {
                        deserializer = sc.newMessageDeserializer();
                        in = FlexContext.getHttpRequest().getInputStream();
                        deserializer.initialize(sc, (InputStream)in, debugTrace);
                        reqLen = FlexContext.getHttpRequest().getContentLength();
                        context.setDeserializedBytes(reqLen);
                        if (context.isMPIenabled()) {
                            mpi = new MessagePerformanceInfo();
                            mpi.recordMessageSizes = context.isRecordMessageSizes();
                            mpi.recordMessageTimes = context.isRecordMessageTimes();
                            if (context.isRecordMessageTimes()) {
                                mpi.receiveTime = System.currentTimeMillis();
                            }
                            if (context.isRecordMessageSizes()) {
                                mpi.messageSize = reqLen;
                            }
                            context.setMPII(mpi);
                        }
                        m = new ActionMessage();
                        context.setRequestMessage(m);
                        deserializer.readMessage(m, context);
                        success = true;
                        var10_11 = null;
                        respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        ** if (debugTrace == null) goto lbl-1000
                    }
                    catch (Throwable var9_17) {
                        var10_13 = null;
                        respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (debugTrace != null) {
                            this.logger.debug(debugTrace.toString());
                        }
                        throw var9_17;
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.logger.debug(debugTrace.toString());
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block48;
                        catch (Throwable t) {
                            SerializationFilter.handleDeserializationException(context, t, this.logger);
                            var10_12 = null;
                            respMsg = context.getResponseMessage();
                            respMsg.setVersion(context.getVersion());
                            if (debugTrace != null) {
                                this.logger.debug(debugTrace.toString());
                            }
                        }
                    }
                }
                if (!success) break block49;
                this.next.invoke(context);
            }
            var13_18 = null;
            if (context.getStatus() == 2) break block50;
            outBuffer = new ByteArrayOutputStream();
            respMesg = context.getResponseMessage();
            debugTrace = Log.isDebug() != false && this.logger.hasTarget() != false ? new AmfTrace() : null;
            try {
                block51: {
                    serializationOverhead = 0L;
                    if (context.isRecordMessageTimes()) {
                        context.getMPIO().sendTime = System.currentTimeMillis();
                        if (context.isRecordMessageSizes()) {
                            serializationOverhead = System.currentTimeMillis();
                        }
                    }
                    serializer = sc.newMessageSerializer();
                    serializer.initialize(sc, outBuffer, debugTrace);
                    serializer.writeMessage(respMesg);
                    context.setSerializedBytes(outBuffer.size());
                    if (context.isRecordMessageSizes()) {
                        try {
                            context.getMPIO().messageSize = outBuffer.size();
                            if (context.isRecordMessageTimes()) {
                                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                context.getMPIO().addToOverhead(serializationOverhead);
                                context.getMPIO().sendTime = System.currentTimeMillis();
                            }
                            outBuffer = new ByteArrayOutputStream();
                            respMesg = context.getResponseMessage();
                            serializer.initialize(sc, outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                        }
                        catch (Exception e) {
                            if (!Log.isDebug()) break block51;
                            this.logger.debug("MPI set up error: " + e.toString());
                        }
                    }
                }
                context.setResponseOutput(outBuffer);
                var21_39 = null;
                ** if (debugTrace == null) goto lbl-1000
            }
            catch (Throwable var20_48) {
                var21_41 = null;
                if (debugTrace != null) {
                    this.logger.debug(debugTrace.toString());
                }
                throw var20_48;
            }
lbl-1000:
            // 1 sources

            {
                this.logger.debug(debugTrace.toString());
            }
lbl-1000:
            // 2 sources

            {
                break block50;
                catch (Exception e) {
                    SerializationFilter.handleSerializationException(sc, context, e, this.logger);
                    var21_40 = null;
                    if (debugTrace != null) {
                        this.logger.debug(debugTrace.toString());
                    }
                    break block50;
                }
            }
            {
                catch (Throwable t) {
                    this.unhandledError(context, t);
                    var13_19 = null;
                    if (context.getStatus() == 2) break block50;
                    outBuffer = new ByteArrayOutputStream();
                    respMesg = context.getResponseMessage();
                    debugTrace = Log.isDebug() != false && this.logger.hasTarget() != false ? new AmfTrace() : null;
                    try {
                        block52: {
                            serializationOverhead = 0L;
                            if (context.isRecordMessageTimes()) {
                                context.getMPIO().sendTime = System.currentTimeMillis();
                                if (context.isRecordMessageSizes()) {
                                    serializationOverhead = System.currentTimeMillis();
                                }
                            }
                            serializer = sc.newMessageSerializer();
                            serializer.initialize(sc, outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                            context.setSerializedBytes(outBuffer.size());
                            if (context.isRecordMessageSizes()) {
                                try {
                                    context.getMPIO().messageSize = outBuffer.size();
                                    if (context.isRecordMessageTimes()) {
                                        serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                        context.getMPIO().addToOverhead(serializationOverhead);
                                        context.getMPIO().sendTime = System.currentTimeMillis();
                                    }
                                    outBuffer = new ByteArrayOutputStream();
                                    respMesg = context.getResponseMessage();
                                    serializer.initialize(sc, outBuffer, debugTrace);
                                    serializer.writeMessage(respMesg);
                                }
                                catch (Exception e) {
                                    if (!Log.isDebug()) break block52;
                                    this.logger.debug("MPI set up error: " + e.toString());
                                }
                            }
                        }
                        context.setResponseOutput(outBuffer);
                        var21_42 = null;
                        ** if (debugTrace == null) goto lbl-1000
                    }
                    catch (Throwable var20_49) {
                        var21_44 = null;
                        if (debugTrace != null) {
                            this.logger.debug(debugTrace.toString());
                        }
                        throw var20_49;
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.logger.debug(debugTrace.toString());
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block50;
                        catch (Exception e) {
                            SerializationFilter.handleSerializationException(sc, context, e, this.logger);
                            var21_43 = null;
                            if (debugTrace != null) {
                                this.logger.debug(debugTrace.toString());
                            }
                            break block50;
                        }
                    }
                }
            }
            catch (Throwable var12_51) {
                block54: {
                    var13_20 = null;
                    if (context.getStatus() != 2) {
                        outBuffer = new ByteArrayOutputStream();
                        respMesg = context.getResponseMessage();
                        debugTrace = Log.isDebug() != false && this.logger.hasTarget() != false ? new AmfTrace() : null;
                        try {
                            block53: {
                                serializationOverhead = 0L;
                                if (context.isRecordMessageTimes()) {
                                    context.getMPIO().sendTime = System.currentTimeMillis();
                                    if (context.isRecordMessageSizes()) {
                                        serializationOverhead = System.currentTimeMillis();
                                    }
                                }
                                serializer = sc.newMessageSerializer();
                                serializer.initialize(sc, outBuffer, debugTrace);
                                serializer.writeMessage(respMesg);
                                context.setSerializedBytes(outBuffer.size());
                                if (context.isRecordMessageSizes()) {
                                    try {
                                        context.getMPIO().messageSize = outBuffer.size();
                                        if (context.isRecordMessageTimes()) {
                                            serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                            context.getMPIO().addToOverhead(serializationOverhead);
                                            context.getMPIO().sendTime = System.currentTimeMillis();
                                        }
                                        outBuffer = new ByteArrayOutputStream();
                                        respMesg = context.getResponseMessage();
                                        serializer.initialize(sc, outBuffer, debugTrace);
                                        serializer.writeMessage(respMesg);
                                    }
                                    catch (Exception e) {
                                        if (!Log.isDebug()) break block53;
                                        this.logger.debug("MPI set up error: " + e.toString());
                                    }
                                }
                            }
                            context.setResponseOutput(outBuffer);
                            var21_45 = null;
                            ** if (debugTrace == null) goto lbl-1000
                        }
                        catch (Throwable var20_50) {
                            var21_47 = null;
                            if (debugTrace != null) {
                                this.logger.debug(debugTrace.toString());
                            }
                            throw var20_50;
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.logger.debug(debugTrace.toString());
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block54;
                            catch (Exception e) {
                                SerializationFilter.handleSerializationException(sc, context, e, this.logger);
                                var21_46 = null;
                                if (debugTrace != null) {
                                    this.logger.debug(debugTrace.toString());
                                }
                            }
                        }
                    }
                }
                throw var12_51;
            }
        }
    }

    public static void handleDeserializationException(ActionContext actionContext, Throwable t, Logger logger) throws IOException {
        if (t instanceof EOFException) {
            actionContext.setStatus(2);
        } else {
            String message;
            MessageException methodResult;
            if (t instanceof IOException) {
                if (Log.isDebug()) {
                    logger.debug("IOException reading message - client closed socket before sending the message?");
                }
                throw (IOException)t;
            }
            actionContext.setStatus(1);
            MessageBody responseBody = new MessageBody();
            if (actionContext.getMessageNumber() < actionContext.getRequestMessage().getBodyCount()) {
                responseBody.setTargetURI(actionContext.getRequestMessageBody().getResponseURI());
            }
            if (actionContext.getVersion() == 0) {
                actionContext.setVersion(3);
            }
            actionContext.getResponseMessage().addBody(responseBody);
            if (t instanceof MessageException) {
                methodResult = (MessageException)((Object)t);
                message = methodResult.getMessage();
            } else {
                methodResult = new SerializationException();
                methodResult.setMessage(10307);
                methodResult.setRootCause(t);
                message = methodResult.getMessage();
            }
            responseBody.setData(methodResult.createErrorMessage());
            responseBody.setReplyMethod("/onStatus");
            if (Log.isError()) {
                logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString((Throwable)t));
            }
        }
    }

    public static void handleSerializationException(SerializationContext serializationContext, ActionContext actionContext, Throwable t, Logger logger) {
        ActionMessage responseMessage = new ActionMessage();
        actionContext.setResponseMessage(responseMessage);
        int bodyCount = actionContext.getRequestMessage().getBodyCount();
        actionContext.setMessageNumber(0);
        while (actionContext.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(actionContext.getRequestMessageBody().getResponseURI());
            actionContext.getResponseMessage().addBody(responseBody);
            if (t instanceof MessageException) {
                methodResult = ((MessageException)((Object)t)).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t.getMessage() != null && (message = t.getMessage()) == null) {
                    message = t.toString();
                }
                methodResult = new MessageException(message, t).createErrorMessage();
            }
            if (actionContext.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put("message", error.faultString);
                    aso.put("code", error.faultCode);
                    aso.put("details", error.faultDetail);
                    aso.put("rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                try {
                    Message inMessage = actionContext.getRequestMessageBody().getDataAsMessage();
                    if (inMessage.getClientId() != null) {
                        ((AbstractMessage)methodResult).setClientId(inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        ((ErrorMessage)methodResult).setCorrelationId(inMessage.getMessageId());
                        ((ErrorMessage)methodResult).setDestination(inMessage.getDestination());
                    }
                }
                catch (MessageException ignore) {
                    // empty catch block
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            actionContext.incrementMessageNumber();
        }
        if (Log.isError() && logger != null) {
            logger.error("Exception occurred during serialization: " + ExceptionUtil.toString((Throwable)t));
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = Log.isDebug() && logger.hasTarget() ? new AmfTrace() : null;
        MessageSerializer serializer = serializationContext.newMessageSerializer();
        serializer.initialize(serializationContext, outBuffer, debugTrace);
        try {
            serializer.writeMessage(actionContext.getResponseMessage());
            actionContext.setResponseOutput(outBuffer);
        }
        catch (IOException e) {
            MessageException ex = new MessageException();
            ex.setMessage(10308);
            ex.setRootCause(e);
            throw ex;
        }
    }

    private void unhandledError(ActionContext context, Throwable t) {
        MessageException methodResult;
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t instanceof MessageException) {
            methodResult = (MessageException)((Object)t);
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t);
        }
        responseBody.setData((Object)methodResult);
        responseBody.setReplyMethod("/onStatus");
        this.logger.info(t.getMessage());
    }
}

