/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.LocalizedException;
import flex.messaging.MessageBroker;
import flex.messaging.log.Log;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.ResourceLoader;
import flex.messaging.util.StringUtils;
import java.util.Map;

public class MessageException
extends LocalizedException {
    public static final String CODE_SERVER_RESOURCE_UNAVAILABLE = "Server.ResourceUnavailable";
    static final long serialVersionUID = 3310842114461162689L;
    protected String code;
    protected Map extendedData;
    protected ErrorMessage errorMessage;
    protected boolean logged;
    protected int statusCode;

    public MessageException() {
    }

    public MessageException(ResourceLoader loader) {
        super(loader);
    }

    public MessageException(String message) {
        this.setMessage(message);
    }

    public MessageException(String message, Throwable t) {
        this.setMessage(message);
        this.setRootCause(t);
    }

    public MessageException(Throwable t) {
        String rootMessage = t.getMessage();
        if (rootMessage == null) {
            rootMessage = t.toString();
        }
        this.setMessage(rootMessage);
        this.setRootCause(t);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDefaultLogMessageIntro() {
        return "Error handling message: ";
    }

    public Map getExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(Map extendedData) {
        this.extendedData = extendedData;
    }

    public ErrorMessage getErrorMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = this.createErrorMessage();
        }
        return this.errorMessage;
    }

    public void setErrorMessage(ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean isLogStackTraceEnabled() {
        return true;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void setLogged(boolean value) {
        this.logged = value;
    }

    public short getPreferredLogLevel() {
        return 8;
    }

    protected ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = MessageBroker.getSystemSettings().getResourceLoader();
        }
        return this.resourceLoader;
    }

    public Object getRootCauseErrorMessage() {
        if (this.rootCause == null) {
            return null;
        }
        return this.rootCause instanceof MessageException ? ((MessageException)((Object)this.rootCause)).createErrorMessage() : this.rootCause;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public ErrorMessage createErrorMessage() {
        ErrorMessage msg = new ErrorMessage();
        msg.faultCode = this.code != null ? this.code : "Server.Processing";
        msg.faultString = this.message;
        msg.faultDetail = this.details;
        msg.rootCause = this.getRootCauseErrorMessage();
        if (this.extendedData != null) {
            msg.extendedData = this.extendedData;
        }
        if (this.statusCode != 0) {
            msg.setHeader("DSStatusCode", this.statusCode);
        }
        return msg;
    }

    public void logAtHingePoint(Message inboundMessage, ErrorMessage outboundMessage, String logMessageIntro) {
        if (!this.isLogged()) {
            this.setLogged(true);
            short preferredLevel = this.getPreferredLogLevel();
            if (preferredLevel < Log.getTargetLevel()) {
                return;
            }
            StringBuffer output = new StringBuffer();
            output.append(logMessageIntro != null ? logMessageIntro : this.getDefaultLogMessageIntro());
            output.append(this.toString());
            output.append(StringUtils.NEWLINE);
            output.append("  incomingMessage: ");
            output.append(inboundMessage);
            output.append(StringUtils.NEWLINE);
            if (outboundMessage != null) {
                output.append("  errorReply: ");
                output.append(outboundMessage);
                output.append(StringUtils.NEWLINE);
            }
            if (this.isLogStackTraceEnabled()) {
                output.append(ExceptionUtil.exceptionFollowedByRootCausesToString((Throwable)((Object)this)));
                output.append(StringUtils.NEWLINE);
            }
            switch (preferredLevel) {
                case 1000: {
                    Log.getLogger((String)"Message.General").fatal(output.toString());
                    break;
                }
                case 8: {
                    Log.getLogger((String)"Message.General").error(output.toString());
                    break;
                }
                case 6: {
                    Log.getLogger((String)"Message.General").warn(output.toString());
                    break;
                }
                case 4: {
                    Log.getLogger((String)"Message.General").info(output.toString());
                    break;
                }
                case 2: {
                    Log.getLogger((String)"Message.General").debug(output.toString());
                    break;
                }
                default: {
                    Log.getLogger((String)"Message.General").fatal("Failed to log exception for handling message due to an invalid preferred log level: " + preferredLevel);
                }
            }
        }
    }
}

