/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.xml.parsers.ParserConfigurationException;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.impl.DefaultContainer;
import org.directwebremoting.impl.DwrXmlConfigurator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.xml.sax.SAXException;

public class ContainerUtil {
    public static final String INIT_CONFIG = "config";
    public static final String INIT_SKIP_DEFAULT = "skipDefaultConfig";
    public static final String INIT_LOGLEVEL = "logLevel";
    public static final String INIT_PUBLISH_CONTAINER = "publishContainerAs";
    public static final String INIT_CUSTOM_CONFIGURATOR = "customConfigurator";
    public static final String ATTRIBUTE_CONTAINER_LIST = "org.directwebremoting.ContainerList";
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$ContainerUtil == null ? (class$org$directwebremoting$impl$ContainerUtil = ContainerUtil.class$("org.directwebremoting.impl.ContainerUtil")) : class$org$directwebremoting$impl$ContainerUtil);
    static /* synthetic */ Class class$org$directwebremoting$Container;
    static /* synthetic */ Class class$org$directwebremoting$extend$AccessControl;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultAccessControl;
    static /* synthetic */ Class class$org$directwebremoting$extend$ConverterManager;
    static /* synthetic */ Class class$org$directwebremoting$dwrp$DefaultConverterManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$CreatorManager;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultCreatorManager;
    static /* synthetic */ Class class$org$directwebremoting$servlet$UrlProcessor;
    static /* synthetic */ Class class$org$directwebremoting$WebContextFactory$WebContextBuilder;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultWebContextBuilder;
    static /* synthetic */ Class class$org$directwebremoting$ServerContextFactory$ServerContextBuilder;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultServerContextBuilder;
    static /* synthetic */ Class class$org$directwebremoting$extend$AjaxFilterManager;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultAjaxFilterManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$Remoter;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultRemoter;
    static /* synthetic */ Class class$org$directwebremoting$extend$DebugPageGenerator;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultDebugPageGenerator;
    static /* synthetic */ Class class$org$directwebremoting$dwrp$PlainCallMarshaller;
    static /* synthetic */ Class class$org$directwebremoting$dwrp$HtmlCallMarshaller;
    static /* synthetic */ Class class$org$directwebremoting$servlet$PlainPollHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$HtmlPollHandler;
    static /* synthetic */ Class class$org$directwebremoting$extend$ScriptSessionManager;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultScriptSessionManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$PageNormalizer;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultPageNormalizer;
    static /* synthetic */ Class class$org$directwebremoting$extend$ServerLoadMonitor;
    static /* synthetic */ Class class$org$directwebremoting$impl$ThreadDroppingServerLoadMonitor;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultServerLoadMonitor;
    static /* synthetic */ Class class$org$directwebremoting$servlet$IndexHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$EngineHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$UtilHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$AuthHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$WebworkUtilHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$AboutHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$TestHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$InterfaceHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$PlainCallHandler;
    static /* synthetic */ Class class$org$directwebremoting$servlet$HtmlCallHandler;
    static /* synthetic */ Class class$javax$servlet$ServletConfig;
    static /* synthetic */ Class class$javax$servlet$http$HttpServlet;
    static /* synthetic */ Class class$org$directwebremoting$extend$Configurator;
    static /* synthetic */ Class class$java$lang$UnsupportedClassVersionError;
    static /* synthetic */ Class class$java$lang$LinkageError;
    static /* synthetic */ Class class$org$directwebremoting$impl$ContainerUtil;

    public static DefaultContainer createDefaultContainer(ServletConfig servletConfig) throws ServletException {
        try {
            String typeName = servletConfig.getInitParameter((class$org$directwebremoting$Container == null ? (class$org$directwebremoting$Container = ContainerUtil.class$("org.directwebremoting.Container")) : class$org$directwebremoting$Container).getName());
            if (typeName == null) {
                return new DefaultContainer();
            }
            log.debug("Using alternate Container implementation: " + typeName);
            Class type = LocalUtil.classForName(typeName);
            return (DefaultContainer)type.newInstance();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public static void setupDefaultContainer(DefaultContainer container, ServletConfig servletConfig) throws InstantiationException, IllegalAccessException {
        ContainerUtil.setupDefaults(container, servletConfig);
        ContainerUtil.setupFromServletConfig(container, servletConfig);
        container.setupFinished();
    }

    public static void setupDefaults(DefaultContainer container, ServletConfig servletConfig) throws InstantiationException, IllegalAccessException {
        container.addParameter((class$org$directwebremoting$extend$AccessControl == null ? (class$org$directwebremoting$extend$AccessControl = ContainerUtil.class$("org.directwebremoting.extend.AccessControl")) : class$org$directwebremoting$extend$AccessControl).getName(), (class$org$directwebremoting$impl$DefaultAccessControl == null ? (class$org$directwebremoting$impl$DefaultAccessControl = ContainerUtil.class$("org.directwebremoting.impl.DefaultAccessControl")) : class$org$directwebremoting$impl$DefaultAccessControl).getName());
        container.addParameter((class$org$directwebremoting$extend$ConverterManager == null ? (class$org$directwebremoting$extend$ConverterManager = ContainerUtil.class$("org.directwebremoting.extend.ConverterManager")) : class$org$directwebremoting$extend$ConverterManager).getName(), (class$org$directwebremoting$dwrp$DefaultConverterManager == null ? (class$org$directwebremoting$dwrp$DefaultConverterManager = ContainerUtil.class$("org.directwebremoting.dwrp.DefaultConverterManager")) : class$org$directwebremoting$dwrp$DefaultConverterManager).getName());
        container.addParameter((class$org$directwebremoting$extend$CreatorManager == null ? (class$org$directwebremoting$extend$CreatorManager = ContainerUtil.class$("org.directwebremoting.extend.CreatorManager")) : class$org$directwebremoting$extend$CreatorManager).getName(), (class$org$directwebremoting$impl$DefaultCreatorManager == null ? (class$org$directwebremoting$impl$DefaultCreatorManager = ContainerUtil.class$("org.directwebremoting.impl.DefaultCreatorManager")) : class$org$directwebremoting$impl$DefaultCreatorManager).getName());
        container.addParameter((class$org$directwebremoting$servlet$UrlProcessor == null ? (class$org$directwebremoting$servlet$UrlProcessor = ContainerUtil.class$("org.directwebremoting.servlet.UrlProcessor")) : class$org$directwebremoting$servlet$UrlProcessor).getName(), (class$org$directwebremoting$servlet$UrlProcessor == null ? (class$org$directwebremoting$servlet$UrlProcessor = ContainerUtil.class$("org.directwebremoting.servlet.UrlProcessor")) : class$org$directwebremoting$servlet$UrlProcessor).getName());
        container.addParameter((class$org$directwebremoting$WebContextFactory$WebContextBuilder == null ? (class$org$directwebremoting$WebContextFactory$WebContextBuilder = ContainerUtil.class$("org.directwebremoting.WebContextFactory$WebContextBuilder")) : class$org$directwebremoting$WebContextFactory$WebContextBuilder).getName(), (class$org$directwebremoting$impl$DefaultWebContextBuilder == null ? (class$org$directwebremoting$impl$DefaultWebContextBuilder = ContainerUtil.class$("org.directwebremoting.impl.DefaultWebContextBuilder")) : class$org$directwebremoting$impl$DefaultWebContextBuilder).getName());
        container.addParameter((class$org$directwebremoting$ServerContextFactory$ServerContextBuilder == null ? (class$org$directwebremoting$ServerContextFactory$ServerContextBuilder = ContainerUtil.class$("org.directwebremoting.ServerContextFactory$ServerContextBuilder")) : class$org$directwebremoting$ServerContextFactory$ServerContextBuilder).getName(), (class$org$directwebremoting$impl$DefaultServerContextBuilder == null ? (class$org$directwebremoting$impl$DefaultServerContextBuilder = ContainerUtil.class$("org.directwebremoting.impl.DefaultServerContextBuilder")) : class$org$directwebremoting$impl$DefaultServerContextBuilder).getName());
        container.addParameter((class$org$directwebremoting$extend$AjaxFilterManager == null ? (class$org$directwebremoting$extend$AjaxFilterManager = ContainerUtil.class$("org.directwebremoting.extend.AjaxFilterManager")) : class$org$directwebremoting$extend$AjaxFilterManager).getName(), (class$org$directwebremoting$impl$DefaultAjaxFilterManager == null ? (class$org$directwebremoting$impl$DefaultAjaxFilterManager = ContainerUtil.class$("org.directwebremoting.impl.DefaultAjaxFilterManager")) : class$org$directwebremoting$impl$DefaultAjaxFilterManager).getName());
        container.addParameter((class$org$directwebremoting$extend$Remoter == null ? (class$org$directwebremoting$extend$Remoter = ContainerUtil.class$("org.directwebremoting.extend.Remoter")) : class$org$directwebremoting$extend$Remoter).getName(), (class$org$directwebremoting$impl$DefaultRemoter == null ? (class$org$directwebremoting$impl$DefaultRemoter = ContainerUtil.class$("org.directwebremoting.impl.DefaultRemoter")) : class$org$directwebremoting$impl$DefaultRemoter).getName());
        container.addParameter((class$org$directwebremoting$extend$DebugPageGenerator == null ? (class$org$directwebremoting$extend$DebugPageGenerator = ContainerUtil.class$("org.directwebremoting.extend.DebugPageGenerator")) : class$org$directwebremoting$extend$DebugPageGenerator).getName(), (class$org$directwebremoting$impl$DefaultDebugPageGenerator == null ? (class$org$directwebremoting$impl$DefaultDebugPageGenerator = ContainerUtil.class$("org.directwebremoting.impl.DefaultDebugPageGenerator")) : class$org$directwebremoting$impl$DefaultDebugPageGenerator).getName());
        container.addParameter((class$org$directwebremoting$dwrp$PlainCallMarshaller == null ? (class$org$directwebremoting$dwrp$PlainCallMarshaller = ContainerUtil.class$("org.directwebremoting.dwrp.PlainCallMarshaller")) : class$org$directwebremoting$dwrp$PlainCallMarshaller).getName(), (class$org$directwebremoting$dwrp$PlainCallMarshaller == null ? (class$org$directwebremoting$dwrp$PlainCallMarshaller = ContainerUtil.class$("org.directwebremoting.dwrp.PlainCallMarshaller")) : class$org$directwebremoting$dwrp$PlainCallMarshaller).getName());
        container.addParameter((class$org$directwebremoting$dwrp$HtmlCallMarshaller == null ? (class$org$directwebremoting$dwrp$HtmlCallMarshaller = ContainerUtil.class$("org.directwebremoting.dwrp.HtmlCallMarshaller")) : class$org$directwebremoting$dwrp$HtmlCallMarshaller).getName(), (class$org$directwebremoting$dwrp$HtmlCallMarshaller == null ? (class$org$directwebremoting$dwrp$HtmlCallMarshaller = ContainerUtil.class$("org.directwebremoting.dwrp.HtmlCallMarshaller")) : class$org$directwebremoting$dwrp$HtmlCallMarshaller).getName());
        container.addParameter((class$org$directwebremoting$servlet$PlainPollHandler == null ? (class$org$directwebremoting$servlet$PlainPollHandler = ContainerUtil.class$("org.directwebremoting.servlet.PlainPollHandler")) : class$org$directwebremoting$servlet$PlainPollHandler).getName(), (class$org$directwebremoting$servlet$PlainPollHandler == null ? (class$org$directwebremoting$servlet$PlainPollHandler = ContainerUtil.class$("org.directwebremoting.servlet.PlainPollHandler")) : class$org$directwebremoting$servlet$PlainPollHandler).getName());
        container.addParameter((class$org$directwebremoting$servlet$HtmlPollHandler == null ? (class$org$directwebremoting$servlet$HtmlPollHandler = ContainerUtil.class$("org.directwebremoting.servlet.HtmlPollHandler")) : class$org$directwebremoting$servlet$HtmlPollHandler).getName(), (class$org$directwebremoting$servlet$HtmlPollHandler == null ? (class$org$directwebremoting$servlet$HtmlPollHandler = ContainerUtil.class$("org.directwebremoting.servlet.HtmlPollHandler")) : class$org$directwebremoting$servlet$HtmlPollHandler).getName());
        container.addParameter((class$org$directwebremoting$extend$ScriptSessionManager == null ? (class$org$directwebremoting$extend$ScriptSessionManager = ContainerUtil.class$("org.directwebremoting.extend.ScriptSessionManager")) : class$org$directwebremoting$extend$ScriptSessionManager).getName(), (class$org$directwebremoting$impl$DefaultScriptSessionManager == null ? (class$org$directwebremoting$impl$DefaultScriptSessionManager = ContainerUtil.class$("org.directwebremoting.impl.DefaultScriptSessionManager")) : class$org$directwebremoting$impl$DefaultScriptSessionManager).getName());
        container.addParameter((class$org$directwebremoting$extend$PageNormalizer == null ? (class$org$directwebremoting$extend$PageNormalizer = ContainerUtil.class$("org.directwebremoting.extend.PageNormalizer")) : class$org$directwebremoting$extend$PageNormalizer).getName(), (class$org$directwebremoting$impl$DefaultPageNormalizer == null ? (class$org$directwebremoting$impl$DefaultPageNormalizer = ContainerUtil.class$("org.directwebremoting.impl.DefaultPageNormalizer")) : class$org$directwebremoting$impl$DefaultPageNormalizer).getName());
        if (servletConfig.getServletContext().getServerInfo().startsWith("jetty-6")) {
            container.addParameter((class$org$directwebremoting$extend$ServerLoadMonitor == null ? (class$org$directwebremoting$extend$ServerLoadMonitor = ContainerUtil.class$("org.directwebremoting.extend.ServerLoadMonitor")) : class$org$directwebremoting$extend$ServerLoadMonitor).getName(), (class$org$directwebremoting$impl$ThreadDroppingServerLoadMonitor == null ? (class$org$directwebremoting$impl$ThreadDroppingServerLoadMonitor = ContainerUtil.class$("org.directwebremoting.impl.ThreadDroppingServerLoadMonitor")) : class$org$directwebremoting$impl$ThreadDroppingServerLoadMonitor).getName());
        } else {
            container.addParameter((class$org$directwebremoting$extend$ServerLoadMonitor == null ? (class$org$directwebremoting$extend$ServerLoadMonitor = ContainerUtil.class$("org.directwebremoting.extend.ServerLoadMonitor")) : class$org$directwebremoting$extend$ServerLoadMonitor).getName(), (class$org$directwebremoting$impl$DefaultServerLoadMonitor == null ? (class$org$directwebremoting$impl$DefaultServerLoadMonitor = ContainerUtil.class$("org.directwebremoting.impl.DefaultServerLoadMonitor")) : class$org$directwebremoting$impl$DefaultServerLoadMonitor).getName());
        }
        ContainerUtil.createUrlMapping(container, "/index.html", "indexHandlerUrl", class$org$directwebremoting$servlet$IndexHandler == null ? (class$org$directwebremoting$servlet$IndexHandler = ContainerUtil.class$("org.directwebremoting.servlet.IndexHandler")) : class$org$directwebremoting$servlet$IndexHandler);
        ContainerUtil.createUrlMapping(container, "/engine.js", "engineHandlerUrl", class$org$directwebremoting$servlet$EngineHandler == null ? (class$org$directwebremoting$servlet$EngineHandler = ContainerUtil.class$("org.directwebremoting.servlet.EngineHandler")) : class$org$directwebremoting$servlet$EngineHandler);
        ContainerUtil.createUrlMapping(container, "/util.js", "utilHandlerUrl", class$org$directwebremoting$servlet$UtilHandler == null ? (class$org$directwebremoting$servlet$UtilHandler = ContainerUtil.class$("org.directwebremoting.servlet.UtilHandler")) : class$org$directwebremoting$servlet$UtilHandler);
        ContainerUtil.createUrlMapping(container, "/auth.js", "authHandlerUrl", class$org$directwebremoting$servlet$AuthHandler == null ? (class$org$directwebremoting$servlet$AuthHandler = ContainerUtil.class$("org.directwebremoting.servlet.AuthHandler")) : class$org$directwebremoting$servlet$AuthHandler);
        ContainerUtil.createUrlMapping(container, "/webwork/DWRActionUtil.js", "webworkUtilHandlerUrl", class$org$directwebremoting$servlet$WebworkUtilHandler == null ? (class$org$directwebremoting$servlet$WebworkUtilHandler = ContainerUtil.class$("org.directwebremoting.servlet.WebworkUtilHandler")) : class$org$directwebremoting$servlet$WebworkUtilHandler);
        ContainerUtil.createUrlMapping(container, "/about", "aboutHandlerUrl", class$org$directwebremoting$servlet$AboutHandler == null ? (class$org$directwebremoting$servlet$AboutHandler = ContainerUtil.class$("org.directwebremoting.servlet.AboutHandler")) : class$org$directwebremoting$servlet$AboutHandler);
        ContainerUtil.createUrlMapping(container, "/test/", "testHandlerUrl", class$org$directwebremoting$servlet$TestHandler == null ? (class$org$directwebremoting$servlet$TestHandler = ContainerUtil.class$("org.directwebremoting.servlet.TestHandler")) : class$org$directwebremoting$servlet$TestHandler);
        ContainerUtil.createUrlMapping(container, "/interface/", "interfaceHandlerUrl", class$org$directwebremoting$servlet$InterfaceHandler == null ? (class$org$directwebremoting$servlet$InterfaceHandler = ContainerUtil.class$("org.directwebremoting.servlet.InterfaceHandler")) : class$org$directwebremoting$servlet$InterfaceHandler);
        ContainerUtil.createUrlMapping(container, "/call/plaincall/", "plainCallHandlerUrl", class$org$directwebremoting$servlet$PlainCallHandler == null ? (class$org$directwebremoting$servlet$PlainCallHandler = ContainerUtil.class$("org.directwebremoting.servlet.PlainCallHandler")) : class$org$directwebremoting$servlet$PlainCallHandler);
        ContainerUtil.createUrlMapping(container, "/call/plainpoll/", "plainPollHandlerUrl", class$org$directwebremoting$servlet$PlainPollHandler == null ? (class$org$directwebremoting$servlet$PlainPollHandler = ContainerUtil.class$("org.directwebremoting.servlet.PlainPollHandler")) : class$org$directwebremoting$servlet$PlainPollHandler);
        ContainerUtil.createUrlMapping(container, "/call/htmlcall/", "htmlCallHandlerUrl", class$org$directwebremoting$servlet$HtmlCallHandler == null ? (class$org$directwebremoting$servlet$HtmlCallHandler = ContainerUtil.class$("org.directwebremoting.servlet.HtmlCallHandler")) : class$org$directwebremoting$servlet$HtmlCallHandler);
        ContainerUtil.createUrlMapping(container, "/call/htmlpoll/", "htmlPollHandlerUrl", class$org$directwebremoting$servlet$HtmlPollHandler == null ? (class$org$directwebremoting$servlet$HtmlPollHandler = ContainerUtil.class$("org.directwebremoting.servlet.HtmlPollHandler")) : class$org$directwebremoting$servlet$HtmlPollHandler);
        container.addParameter("maxWaitAfterWrite", "500");
    }

    public static void createUrlMapping(DefaultContainer container, String url, String propertyName, Class handler) throws InstantiationException, IllegalAccessException {
        container.addParameter("url:" + url, handler.getName());
        container.addParameter(propertyName, url);
    }

    public static void setupFromServletConfig(DefaultContainer container, ServletConfig servletConfig) throws InstantiationException, IllegalAccessException {
        Enumeration en = servletConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = servletConfig.getInitParameter(name);
            container.addParameter(name, value);
        }
    }

    public static void prepareForWebContextFilter(ServletContext context, ServletConfig config, Container container, WebContextFactory.WebContextBuilder webContextBuilder, HttpServlet servlet) {
        context.setAttribute((class$org$directwebremoting$Container == null ? (class$org$directwebremoting$Container = ContainerUtil.class$("org.directwebremoting.Container")) : class$org$directwebremoting$Container).getName(), (Object)container);
        context.setAttribute((class$org$directwebremoting$WebContextFactory$WebContextBuilder == null ? (class$org$directwebremoting$WebContextFactory$WebContextBuilder = ContainerUtil.class$("org.directwebremoting.WebContextFactory$WebContextBuilder")) : class$org$directwebremoting$WebContextFactory$WebContextBuilder).getName(), (Object)webContextBuilder);
        context.setAttribute((class$javax$servlet$ServletConfig == null ? (class$javax$servlet$ServletConfig = ContainerUtil.class$("javax.servlet.ServletConfig")) : class$javax$servlet$ServletConfig).getName(), (Object)config);
        context.setAttribute((class$javax$servlet$http$HttpServlet == null ? (class$javax$servlet$http$HttpServlet = ContainerUtil.class$("javax.servlet.http.HttpServlet")) : class$javax$servlet$http$HttpServlet).getName(), (Object)servlet);
    }

    public static void configureFromSystemDwrXml(Container container) throws IOException, ParserConfigurationException, SAXException {
        DwrXmlConfigurator system = new DwrXmlConfigurator();
        system.setClassResourceName("/org/directwebremoting/dwr.xml");
        system.configure(container);
    }

    public static void configureFromDefaultDwrXml(Container container) throws IOException, ParserConfigurationException, SAXException {
        DwrXmlConfigurator local = new DwrXmlConfigurator();
        local.setServletResourceName("/WEB-INF/dwr.xml");
        local.configure(container);
    }

    public static boolean configureFromInitParams(Container container, ServletConfig servletConfig) throws IOException, ParserConfigurationException, SAXException {
        Enumeration en = servletConfig.getInitParameterNames();
        boolean foundConfig = false;
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = servletConfig.getInitParameter(name);
            if (name.startsWith(INIT_CONFIG)) {
                foundConfig = true;
                StringTokenizer st = new StringTokenizer(value, "\n,");
                while (st.hasMoreTokens()) {
                    String fileName = st.nextToken().trim();
                    DwrXmlConfigurator local = new DwrXmlConfigurator();
                    local.setServletResourceName(fileName);
                    local.configure(container);
                }
                continue;
            }
            if (!name.equals(INIT_CUSTOM_CONFIGURATOR)) continue;
            foundConfig = true;
            try {
                Configurator configurator = (Configurator)LocalUtil.classNewInstance(INIT_CUSTOM_CONFIGURATOR, value, class$org$directwebremoting$extend$Configurator == null ? ContainerUtil.class$("org.directwebremoting.extend.Configurator") : class$org$directwebremoting$extend$Configurator);
                configurator.configure(container);
                log.debug("Loaded config from: " + value);
            }
            catch (Exception ex) {
                log.warn("Failed to start custom configurator", ex);
            }
        }
        return foundConfig;
    }

    public static boolean configureFromAnnotations(Container container) {
        try {
            Class annotationCfgClass = LocalUtil.classForName("org.directwebremoting.annotations.AnnotationsConfigurator");
            Configurator configurator = (Configurator)annotationCfgClass.newInstance();
            configurator.configure(container);
            log.debug("Java5 AnnotationsConfigurator enabled");
            return true;
        }
        catch (UnsupportedClassVersionError ex) {
            return false;
        }
        catch (ClassNotFoundException ex) {
            log.warn("AnnotationsConfigurator is missing. Are you running from within an IDE?");
            return false;
        }
        catch (Exception ex) {
            log.warn("Failed to start annotations", ex);
            return false;
        }
        catch (Throwable ex) {
            if (ex.getClass().getName().equals((class$java$lang$UnsupportedClassVersionError == null ? (class$java$lang$UnsupportedClassVersionError = ContainerUtil.class$("java.lang.UnsupportedClassVersionError")) : class$java$lang$UnsupportedClassVersionError).getName())) {
                log.error("Caught impossible Throwable", ex);
                return false;
            }
            if (ex.getClass().getName().equals((class$java$lang$LinkageError == null ? (class$java$lang$LinkageError = ContainerUtil.class$("java.lang.LinkageError")) : class$java$lang$LinkageError).getName())) {
                log.error("Caught impossible Throwable", ex);
                return false;
            }
            if (ex instanceof Error) {
                log.fatal("Rethrowing Error:" + ex);
                throw (Error)ex;
            }
            log.error("Ilogical catch state", ex);
            return false;
        }
    }

    public static void configure(Container container, List configurators) {
        Iterator it = configurators.iterator();
        while (it.hasNext()) {
            Configurator configurator = (Configurator)it.next();
            log.debug("** Adding config from " + configurator);
            configurator.configure(container);
        }
    }

    public static void configureContainerFully(Container container, ServletConfig servletConfig) throws IOException, ParserConfigurationException, SAXException {
        ContainerUtil.configureFromSystemDwrXml(container);
        boolean foundConfig = ContainerUtil.configureFromInitParams(container, servletConfig);
        boolean skip = Boolean.valueOf(servletConfig.getInitParameter(INIT_SKIP_DEFAULT));
        IOException delayedIOException = null;
        if (!foundConfig && !skip) {
            try {
                ContainerUtil.configureFromDefaultDwrXml(container);
            }
            catch (IOException ex) {
                delayedIOException = ex;
            }
        }
        if (!ContainerUtil.configureFromAnnotations(container)) {
            log.debug("Java5 AnnotationsConfigurator disabled");
            if (delayedIOException != null) {
                throw delayedIOException;
            }
        }
    }

    public static void publishContainer(Container container, ServletConfig servletConfig) {
        ArrayList<Container> containers;
        ServletContext servletContext = servletConfig.getServletContext();
        String publishName = servletConfig.getInitParameter(INIT_PUBLISH_CONTAINER);
        if (publishName != null) {
            servletContext.setAttribute(publishName, (Object)container);
        }
        if ((containers = (ArrayList<Container>)servletContext.getAttribute(ATTRIBUTE_CONTAINER_LIST)) == null) {
            containers = new ArrayList<Container>();
        }
        containers.add(container);
        servletContext.setAttribute(ATTRIBUTE_CONTAINER_LIST, containers);
    }

    public static List getAllPublishedContainers(ServletContext servletContext) {
        ArrayList containers = (ArrayList)servletContext.getAttribute(ATTRIBUTE_CONTAINER_LIST);
        if (containers == null) {
            containers = new ArrayList();
        }
        return containers;
    }

    public static void shutdownServerLoadMonitorsInContainerList(List containers, String title) {
        if (containers == null || containers.size() == 0) {
            log.debug("No containers to shutdown for: " + title);
            return;
        }
        log.debug("Shutting down containers for: " + title);
        Iterator it = containers.iterator();
        while (it.hasNext()) {
            Container container = (Container)it.next();
            ServerLoadMonitor monitor = (ServerLoadMonitor)container.getBean((class$org$directwebremoting$extend$ServerLoadMonitor == null ? ContainerUtil.class$("org.directwebremoting.extend.ServerLoadMonitor") : class$org$directwebremoting$extend$ServerLoadMonitor).getName());
            monitor.shutdown();
        }
    }

    public static void debugConfig(Container container) {
        if (log.isDebugEnabled()) {
            log.debug("Container");
            log.debug("  Type: " + container.getClass().getName());
            Collection beanNames = container.getBeanNames();
            Iterator it = beanNames.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object object = container.getBean(name);
                if (object instanceof String) {
                    log.debug("  Param: " + name + " = " + object + " (" + object.getClass().getName() + ")");
                    continue;
                }
                log.debug("  Bean: " + name + " = " + object + " (" + object.getClass().getName() + ")");
            }
            AccessControl accessControl = (AccessControl)container.getBean((class$org$directwebremoting$extend$AccessControl == null ? (class$org$directwebremoting$extend$AccessControl = ContainerUtil.class$("org.directwebremoting.extend.AccessControl")) : class$org$directwebremoting$extend$AccessControl).getName());
            log.debug("AccessControl");
            log.debug("  Type: " + accessControl.getClass().getName());
            AjaxFilterManager ajaxFilterManager = (AjaxFilterManager)container.getBean((class$org$directwebremoting$extend$AjaxFilterManager == null ? (class$org$directwebremoting$extend$AjaxFilterManager = ContainerUtil.class$("org.directwebremoting.extend.AjaxFilterManager")) : class$org$directwebremoting$extend$AjaxFilterManager).getName());
            log.debug("AjaxFilterManager");
            log.debug("  Type: " + ajaxFilterManager.getClass().getName());
            ConverterManager converterManager = (ConverterManager)container.getBean((class$org$directwebremoting$extend$ConverterManager == null ? (class$org$directwebremoting$extend$ConverterManager = ContainerUtil.class$("org.directwebremoting.extend.ConverterManager")) : class$org$directwebremoting$extend$ConverterManager).getName());
            log.debug("ConverterManager");
            log.debug("  Type: " + converterManager.getClass().getName());
            CreatorManager creatorManager = (CreatorManager)container.getBean((class$org$directwebremoting$extend$CreatorManager == null ? (class$org$directwebremoting$extend$CreatorManager = ContainerUtil.class$("org.directwebremoting.extend.CreatorManager")) : class$org$directwebremoting$extend$CreatorManager).getName());
            log.debug("CreatorManager");
            log.debug("  Type: " + creatorManager.getClass().getName());
            Collection creatorNames = creatorManager.getCreatorNames();
            Iterator it2 = creatorNames.iterator();
            while (it2.hasNext()) {
                String creatorName = (String)it2.next();
                Creator creator = creatorManager.getCreator(creatorName);
                log.debug("  Creator: " + creatorName + " = " + creator + " (" + creator.getClass().getName() + ")");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

