/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import net.sf.swarmcache.CacheConfiguration;
import net.sf.swarmcache.HybridCache;
import net.sf.swarmcache.LRUCache;
import net.sf.swarmcache.MultiCache;
import net.sf.swarmcache.MultiCacheManager;
import net.sf.swarmcache.ObjectCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheFactory {
    Log log;
    private Class cacheType;
    private int lruCacheSize;
    private boolean isLRU;
    private MultiCacheManager manager;
    static /* synthetic */ Class class$net$sf$swarmcache$LRUCache;
    static /* synthetic */ Class class$net$sf$swarmcache$AutoCache;
    static /* synthetic */ Class class$net$sf$swarmcache$TimerCache;
    static /* synthetic */ Class class$net$sf$swarmcache$HybridCache;

    protected CacheFactory() {
        this.log = LogFactory.getLog(this.getClass());
    }

    public CacheFactory(CacheConfiguration conf) {
        block12: {
            this.log = LogFactory.getLog(this.getClass());
            this.cacheType = null;
            String cacheTypeProperty = conf.getCacheType();
            if (cacheTypeProperty == null) break block12;
            try {
                this.isLRU = false;
                if ("LRU".equals(cacheTypeProperty)) {
                    this.cacheType = class$net$sf$swarmcache$LRUCache == null ? (class$net$sf$swarmcache$LRUCache = CacheFactory.class$("net.sf.swarmcache.LRUCache")) : class$net$sf$swarmcache$LRUCache;
                    this.isLRU = true;
                } else if ("Auto".equals(cacheTypeProperty)) {
                    this.cacheType = class$net$sf$swarmcache$AutoCache == null ? (class$net$sf$swarmcache$AutoCache = CacheFactory.class$("net.sf.swarmcache.AutoCache")) : class$net$sf$swarmcache$AutoCache;
                } else if ("Timer".equals(cacheTypeProperty)) {
                    this.cacheType = class$net$sf$swarmcache$TimerCache == null ? (class$net$sf$swarmcache$TimerCache = CacheFactory.class$("net.sf.swarmcache.TimerCache")) : class$net$sf$swarmcache$TimerCache;
                } else if ("Hybrid".equals(cacheTypeProperty)) {
                    this.cacheType = class$net$sf$swarmcache$HybridCache == null ? (class$net$sf$swarmcache$HybridCache = CacheFactory.class$("net.sf.swarmcache.HybridCache")) : class$net$sf$swarmcache$HybridCache;
                    this.isLRU = true;
                } else {
                    throw new Exception("Unknown cache type: " + this.cacheType + ".");
                }
                if (this.isLRU) {
                    this.lruCacheSize = conf.getLRUCacheSize() != null ? Integer.parseInt(conf.getLRUCacheSize()) : 1000;
                }
                ObjectCache sampleCache = (ObjectCache)this.cacheType.newInstance();
                String channelProperties = conf.getChannelProperties();
                if (channelProperties == null) {
                    throw new Exception("Either the channel properties or the multicast IP address must be specified.");
                }
                this.log.debug((Object)("Creating a JavaGroups cache manager with properties: " + channelProperties));
                this.manager = MultiCacheManager.getManager(channelProperties);
            }
            catch (Exception e) {
                this.log.error((Object)"Problem instantiating cache:", (Throwable)e);
            }
        }
    }

    public ObjectCache createCache(String name) {
        MultiCache multi;
        block6: {
            ObjectCache cache;
            block5: {
                cache = null;
                multi = null;
                if (!this.manager.containsCache(name)) break block5;
                this.log.error((Object)("Cache of type [" + name + "] already exists."));
                break block6;
            }
            if (this.cacheType == null) break block6;
            try {
                cache = (ObjectCache)this.cacheType.newInstance();
                if (cache instanceof LRUCache) {
                    ((LRUCache)cache).setSize(this.lruCacheSize);
                } else if (cache instanceof HybridCache) {
                    ((HybridCache)cache).setSize(this.lruCacheSize);
                }
                cache.setType(name);
                multi = new MultiCache(cache, this.manager);
                this.manager.addCache(multi);
            }
            catch (Exception e) {
                this.log.error((Object)"Problem instantiating cache:");
                e.printStackTrace();
            }
        }
        return multi;
    }

    public MultiCacheManager getCacheManager() {
        return this.manager;
    }

    public void shutdown() {
        MultiCacheManager.shutDown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

