/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetByte
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetByte(int n) {
        super(n);
        this.rep = 1;
    }

    static byte[] charsToBytes(char[] cArray, byte by) throws SQLException {
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] > '\u00ff') {
                byArray[n] = by;
                if (by == 0) {
                    CharacterSet.failCharacterConversion(CharacterSet.make(31));
                }
            } else {
                byArray[n] = (byte)cArray[n];
            }
            ++n;
        }
        return byArray;
    }

    public byte[] convert(String string) throws SQLException {
        int n = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n, cArray, 0);
        return CharacterSetByte.charsToBytes(cArray, (byte)0);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 1) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else if (characterSet.rep == 2) {
            char[] cArray = CharacterSet.UTFToJavaChar(byArray, n, n2);
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            char[] cArray = string.toCharArray();
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        int n = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n, cArray, 0);
        try {
            return CharacterSetByte.charsToBytes(cArray, (byte)63);
        }
        catch (SQLException sQLException) {
            return new byte[0];
        }
    }

    int decode(CharacterWalker characterWalker) {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        CharacterSet.need(characterBuffer, 1);
        if (n < 256) {
            characterBuffer.bytes[characterBuffer.next] = (byte)n;
            ++characterBuffer.next;
        }
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        return characterSet.rep <= 1024;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.rep != 1;
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        return this.toString(byArray, n, n2, '\u0000');
    }

    private String toString(byte[] byArray, int n, int n2, char c) throws SQLException {
        try {
            return new String(byArray, n, n2, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("ascii not supported");
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            return this.toString(byArray, n, n2, '?');
        }
        catch (SQLException sQLException) {
            throw new Error("CharacterSetByte.toString");
        }
    }
}

