/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerClobAsciiInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerClobAsciiOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerClobCharacterReader;
import com.microsoft.sqlserver.jdbc.SQLServerClobWriter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;

public final class SQLServerClob
implements Clob,
Serializable {
    private String sData;
    SQLServerConnection con;
    private SQLCollation sqlCollation;

    public SQLServerClob(SQLServerConnection sQLServerConnection, String string) {
        this.con = sQLServerConnection;
        this.sData = string;
    }

    public InputStream getAsciiStream() throws SQLServerException {
        if (null != this.sqlCollation && !this.sqlCollation.supportsAsciiConversion()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{"java.sql.Clob", "AsciiStream"};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        }
        if (null == this.sData) {
            return null;
        }
        return new SQLServerClobAsciiInputStream(this);
    }

    void setSQLCollation(SQLCollation sQLCollation) {
        this.sqlCollation = sQLCollation;
    }

    public Reader getCharacterStream() throws SQLServerException {
        if (null == this.sData) {
            return null;
        }
        return new SQLServerClobCharacterReader(this);
    }

    public String getSubString(long l, int n) throws SQLServerException {
        Object[] objectArray;
        MessageFormat messageFormat;
        if ((null == this.sData || 0 == this.sData.length()) && 1L == l && n >= 0) {
            return "";
        }
        if (null == this.sData || l <= 0L || l > (long)this.sData.length()) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (n < 0) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (--l + (long)n > (long)this.sData.length()) {
            n = this.sData.length() - (int)l;
        }
        return this.sData.substring((int)l, (int)l + n);
    }

    public long length() throws SQLServerException {
        if (this.sData == null) {
            return 0L;
        }
        return this.sData.length();
    }

    public long position(Clob clob, long l) throws SQLServerException {
        try {
            if (null == clob || 0L == clob.length()) {
                return -1L;
            }
            return this.position(clob.getSubString(1L, (int)clob.length()), l);
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, null, sQLException.toString(), null, true);
            return 0L;
        }
    }

    public long position(String string, long l) throws SQLServerException {
        if (l <= 0L) {
            return -1L;
        }
        if (null == string || 0 == string.length()) {
            return -1L;
        }
        if (null == this.sData || 0 == this.sData.length()) {
            return -1L;
        }
        int n = this.sData.indexOf(string, (int)(l - 1L));
        if (-1 == n) {
            return n;
        }
        return n + 1;
    }

    public void truncate(long l) throws SQLException {
        if (null == this.sData || (long)this.sData.length() <= l) {
            return;
        }
        if (l < 0L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        this.sData = this.sData.substring(0, (int)l);
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        return new SQLServerClobAsciiOutputStream(this, l);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        return new SQLServerClobWriter(this, l);
    }

    public int setString(long l, String string) throws SQLException {
        if (null == string || 0 == string.length()) {
            return 0;
        }
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        Object object;
        Object object2;
        int n3;
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (0 == n2) {
            return 0;
        }
        int n4 = n3 = null == this.sData ? 0 : this.sData.length();
        if (l <= 0L || l > (long)(n3 + 1)) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            object = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object2).format(object), null, true);
        }
        if (n < 0 || n >= string.length()) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            object = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object2).format(object), null, true);
        }
        if (n2 < 0 || n + n2 > string.length()) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            object = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object2).format(object), null, true);
        }
        if (--l + (long)n2 > (long)n3) {
            object2 = new StringBuffer((int)(l + (long)n2));
            if (n3 > 0) {
                ((StringBuffer)object2).append(this.sData.substring(0, (int)l));
            }
            ((StringBuffer)object2).append(string.substring(n, n + n2));
            this.sData = ((StringBuffer)object2).toString();
        } else {
            object2 = this.sData.substring((int)(l + (long)n2));
            object = new StringBuffer((int)(l + (long)n2 + (long)((String)object2).length()));
            ((StringBuffer)object).append(this.sData.substring(0, (int)l));
            ((StringBuffer)object).append(string.substring(n, n + n2));
            ((StringBuffer)object).append((String)object2);
            this.sData = ((StringBuffer)object).toString();
        }
        return n2;
    }

    int read(int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (null == byArray) {
            return 0;
        }
        if (n < 0) {
            return 0;
        }
        if (n2 < 0 || n2 >= byArray.length) {
            return 0;
        }
        if (n3 <= 0) {
            return 0;
        }
        byte[] byArray2 = null;
        if (null != this.sData && this.sData.length() > 0) {
            byArray2 = this.sData.getBytes("US-ASCII");
        }
        int n5 = n4 = null == byArray2 ? 0 : byArray2.length;
        if (0 == n4) {
            return 0;
        }
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        if (n + n3 > n4) {
            n3 = n4 - n;
        }
        System.arraycopy(byArray2, n, byArray, n2, n3);
        return n3;
    }

    int read(int n, char[] cArray, int n2, int n3) {
        int n4;
        if (null == cArray) {
            return 0;
        }
        if (n < 0) {
            return 0;
        }
        if (n2 < 0 || n2 >= cArray.length) {
            return 0;
        }
        if (n3 <= 0) {
            return 0;
        }
        int n5 = n4 = null == this.sData ? 0 : this.sData.length();
        if (0 == n4) {
            return 0;
        }
        if (n2 + n3 > cArray.length) {
            n3 = cArray.length - n2;
        }
        if (n + n3 > n4) {
            n3 = n4 - n;
        }
        this.sData.getChars(n, n + n3, cArray, n2);
        return n3;
    }
}

