/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SLocaleMapItem;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;

final class SQLCollation
implements Serializable {
    private static final int MASK_LCID = 1048575;
    private final int info;
    private final int lcid;
    private final int codePage;
    private final int sortId;
    static final int TDS_COLLATION_BYTES = 5;
    private String codePageCharset;
    private static final String charsetNotSupported = "Not Supported";
    private static final int CP_UNKNOWN = -1;
    private static final int CP_UNICODE = 0;
    private static final int CP_437 = 437;
    private static final int CP_850 = 850;
    private static final int CP_874 = 874;
    private static final int CP_932 = 932;
    private static final int CP_936 = 936;
    private static final int CP_949 = 949;
    private static final int CP_950 = 950;
    private static final int CP_1250 = 1250;
    private static final int CP_1251 = 1251;
    private static final int CP_1252 = 1252;
    private static final int CP_1253 = 1253;
    private static final int CP_1254 = 1254;
    private static final int CP_1255 = 1255;
    private static final int CP_1256 = 1256;
    private static final int CP_1257 = 1257;
    private static final int CP_1258 = 1258;
    private static final int[] validCodePages = new int[]{1252, 0, 1250, 1251, 1257, 850, 950, 437, 932, 936, 949, 1253, 1254, 1255, 1256, 874, 1258};
    private static String[] codePageCharsetCache = new String[validCodePages.length];
    private static final int ECOLL_80 = 1;
    private static final int ECOLL_90 = 2;
    private static final SLocaleMapItem[] localeMap = new SLocaleMapItem[]{new SLocaleMapItem(1025, 1256, false, 1), new SLocaleMapItem(1028, 950, false, 1), new SLocaleMapItem(1029, 1250, false, 1), new SLocaleMapItem(1030, 1252, false, 1), new SLocaleMapItem(1032, 1253, false, 1), new SLocaleMapItem(1033, 1252, false, 1), new SLocaleMapItem(1034, 1252, false, 1), new SLocaleMapItem(1035, 1252, false, 1), new SLocaleMapItem(1036, 1252, false, 1), new SLocaleMapItem(1037, 1255, false, 1), new SLocaleMapItem(1038, 1250, false, 1), new SLocaleMapItem(1039, 1252, false, 1), new SLocaleMapItem(1041, 932, false, 1), new SLocaleMapItem(1042, 949, false, 1), new SLocaleMapItem(1045, 1250, false, 1), new SLocaleMapItem(1048, 1250, false, 1), new SLocaleMapItem(1049, 1251, false, 1), new SLocaleMapItem(1050, 1250, false, 1), new SLocaleMapItem(1051, 1250, false, 1), new SLocaleMapItem(1052, 1250, false, 1), new SLocaleMapItem(1054, 874, false, 1), new SLocaleMapItem(1055, 1254, false, 1), new SLocaleMapItem(1058, 1251, false, 1), new SLocaleMapItem(1060, 1250, false, 1), new SLocaleMapItem(1061, 1257, false, 1), new SLocaleMapItem(1062, 1257, false, 1), new SLocaleMapItem(1063, 1257, false, 1), new SLocaleMapItem(1066, 1258, false, 1), new SLocaleMapItem(1071, 1251, true, 1), new SLocaleMapItem(1081, 0, true, 1), new SLocaleMapItem(2052, 936, false, 1), new SLocaleMapItem(2087, 1257, true, 1), new SLocaleMapItem(3082, 1252, false, 1), new SLocaleMapItem(66567, 1252, false, 1), new SLocaleMapItem(66574, 1250, false, 1), new SLocaleMapItem(66577, 932, false, 1), new SLocaleMapItem(66578, 949, true, 1), new SLocaleMapItem(66615, 1252, false, 1), new SLocaleMapItem(133124, 936, false, 1), new SLocaleMapItem(197636, 950, false, 1), new SLocaleMapItem(1041, 932, false, 2), new SLocaleMapItem(2052, 936, false, 2), new SLocaleMapItem(133124, 936, false, 2), new SLocaleMapItem(197636, 950, false, 2), new SLocaleMapItem(1028, 950, false, 2), new SLocaleMapItem(1081, 0, false, 2), new SLocaleMapItem(1068, 1251, false, 2), new SLocaleMapItem(1087, 1251, false, 2), new SLocaleMapItem(1091, 1254, false, 2), new SLocaleMapItem(1092, 1251, false, 2), new SLocaleMapItem(1071, 1251, false, 2), new SLocaleMapItem(1114, 0, false, 2), new SLocaleMapItem(1125, 0, false, 2), new SLocaleMapItem(2092, 1254, false, 2), new SLocaleMapItem(3076, 950, false, 2), new SLocaleMapItem(134148, 950, false, 2), new SLocaleMapItem(1042, 949, false, 2)};
    private static final int[] codePageFromSortId = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 437, 437, 437, 437, 437, 437, -1, -1, -1, -1, 850, 850, 850, 850, 850, 850, -1, -1, -1, 850, 1252, 1252, 1252, 1252, 1252, 850, 850, 850, 850, 850, 850, 850, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1252, 1252, 1252, 1252, 1252, -1, -1, -1, -1, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, -1, -1, -1, -1, -1, 1251, 1251, 1251, 1251, 1251, -1, -1, -1, 1253, 1253, 1253, -1, -1, -1, -1, -1, 1253, 1253, 1253, -1, 1253, -1, -1, -1, 1254, 1254, 1254, -1, -1, -1, -1, -1, 1255, 1255, 1255, -1, -1, -1, -1, -1, 1256, 1256, 1256, -1, -1, -1, -1, -1, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1252, 1252, 1252, 1252, -1, -1, -1, -1, -1, 932, 932, 949, 949, 950, 950, 936, 936, 932, 949, 950, 936, 874, 874, 874, -1, -1, -1, 1252, 1252, 1252, 1252, 1252, 1252, 1252, 1252, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    SQLCollation(TDSReader tDSReader) throws SQLServerException {
        this.info = tDSReader.readInt();
        this.lcid = this.info & 0xFFFFF;
        this.sortId = tDSReader.readUnsignedByte();
        this.codePage = this.getCodePageFromTDSCollation();
        this.codePageCharset = charsetNotSupported;
        for (int i = 0; i < validCodePages.length; ++i) {
            if (validCodePages[i] != this.codePage) continue;
            this.codePageCharset = codePageCharsetCache[i];
            if (null != this.codePageCharset) break;
            this.codePageCharset = SQLCollation.codePageCharsetCache[i] = SQLCollation.getCodePageCharset(this.codePage);
            break;
        }
        if (charsetNotSupported == this.codePageCharset) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_codePageNotSupported"));
            Object[] objectArray = new Object[]{new Integer(this.codePage)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    private static String getCodePageCharset(int n) {
        switch (n) {
            case 874: {
                if (!Charset.isSupported("TIS-620")) break;
                return "TIS-620";
            }
            case 0: {
                return "UTF-16LE";
            }
            default: {
                int n2;
                String[] stringArray = new String[]{"windows-", "x-windows", "CP", "MS"};
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (!Charset.isSupported(stringArray[n2] + n)) continue;
                    return stringArray[n2] + n;
                }
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    try {
                        " ".getBytes(stringArray[n2] + n);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        continue;
                    }
                    return stringArray[n2] + n;
                }
            }
        }
        return charsetNotSupported;
    }

    void writeCollation(TDSWriter tDSWriter) throws SQLServerException {
        tDSWriter.writeInt(this.info);
        tDSWriter.writeByte((byte)(this.sortId & 0xFF));
    }

    String getCharset() {
        return this.codePageCharset;
    }

    boolean supportsAsciiConversion() {
        switch (this.codePage) {
            case 0: 
            case 874: 
            case 932: 
            case 936: 
            case 949: 
            case 950: 
            case 1250: 
            case 1251: 
            case 1252: 
            case 1253: 
            case 1254: 
            case 1255: 
            case 1256: 
            case 1257: 
            case 1258: {
                return true;
            }
        }
        return false;
    }

    boolean supportsFastAsciiConversion() {
        switch (this.codePage) {
            case 874: 
            case 1250: 
            case 1251: 
            case 1252: 
            case 1253: 
            case 1254: 
            case 1255: 
            case 1256: 
            case 1257: 
            case 1258: {
                return true;
            }
        }
        return false;
    }

    private int getCodePageFromTDSCollation() throws SQLServerException {
        if (0 != this.sortId) {
            int n = codePageFromSortId[this.sortId];
            if (-1 == n) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownSortId"));
                Object[] objectArray = new Object[]{new Integer(this.sortId)};
                throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
            }
            return n;
        }
        for (int i = 0; i < localeMap.length; ++i) {
            if (this.lcid != SQLCollation.localeMap[i].lcid) continue;
            return SQLCollation.localeMap[i].codePage;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownLCID"));
        Object[] objectArray = new Object[]{Integer.toHexString(this.lcid).toUpperCase()};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }
}

