/*
 * Decompiled with CFR 0.152.
 */
package jofc2.model.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jofc2.model.elements.BarChart;
import jofc2.model.elements.HorizontalBarChart;
import jofc2.model.elements.LineChart;
import jofc2.model.elements.NullElement;
import jofc2.model.elements.PieChart;
import jofc2.model.metadata.Alias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
implements Serializable {
    public static final String ON_CLICK_TOGGLE_VISIBILITY = "toggle-visibility";
    private static final long serialVersionUID = 3975314200083173622L;
    private final String type;
    private Float alpha;
    private String text;
    @Alias(value="font-size")
    private Integer fontSize;
    @Alias(value="tip")
    private String tooltip;
    @Alias(value="gradient-fill")
    private Boolean gradientFill;
    @Alias(value="key-on-click")
    private String key_on_click;
    private List<Object> values = new ArrayList<Object>();

    protected Element(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public Element setAlpha(Float alpha) {
        this.alpha = alpha;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Element setText(String text) {
        this.text = text;
        return this;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public Element setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public Element setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Boolean getGradientFill() {
        return this.gradientFill;
    }

    public void setGradientFill(Boolean gradientFill) {
        this.gradientFill = gradientFill;
    }

    public double getMaxValue() {
        double max = 0.0;
        for (Object obj : this.getValues()) {
            if (obj == null) continue;
            if (obj instanceof Number) {
                max = Math.max(max, ((Number)obj).doubleValue());
                continue;
            }
            if (obj instanceof LineChart.Dot) {
                max = Math.max(max, ((LineChart.Dot)obj).getValue() != null ? ((LineChart.Dot)obj).getValue().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof BarChart.Bar) {
                max = Math.max(max, ((BarChart.Bar)obj).getTop() != null ? ((BarChart.Bar)obj).getTop().doubleValue() : 0.0);
                max = Math.max(max, ((BarChart.Bar)obj).getBottom() != null ? ((BarChart.Bar)obj).getBottom().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof PieChart.Slice) {
                max = Math.max(max, ((PieChart.Slice)obj).getValue() != null ? ((PieChart.Slice)obj).getValue().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof HorizontalBarChart.Bar) {
                max = Math.max(max, ((HorizontalBarChart.Bar)obj).getLeft() != null ? ((HorizontalBarChart.Bar)obj).getLeft().doubleValue() : 0.0);
                max = Math.max(max, ((HorizontalBarChart.Bar)obj).getRight() != null ? ((HorizontalBarChart.Bar)obj).getRight().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof NullElement) continue;
            throw new IllegalArgumentException("Cannot process Objects of Class: " + String.valueOf(obj.getClass()));
        }
        return max;
    }

    public double getMinValue() {
        Double min = null;
        for (Object obj : this.getValues()) {
            if (obj == null) continue;
            if (obj instanceof Number) {
                min = this.nullSafeMin(min, ((Number)obj).doubleValue());
                continue;
            }
            if (obj instanceof LineChart.Dot) {
                min = this.nullSafeMin(min, ((LineChart.Dot)obj).getValue() != null ? ((LineChart.Dot)obj).getValue().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof BarChart.Bar) {
                min = this.nullSafeMin(min, ((BarChart.Bar)obj).getTop() != null ? ((BarChart.Bar)obj).getTop().doubleValue() : 0.0);
                min = this.nullSafeMin(min, ((BarChart.Bar)obj).getBottom() != null ? ((BarChart.Bar)obj).getBottom().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof PieChart.Slice) {
                min = this.nullSafeMin(min, ((PieChart.Slice)obj).getValue() != null ? ((PieChart.Slice)obj).getValue().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof HorizontalBarChart.Bar) {
                min = this.nullSafeMin(min, ((HorizontalBarChart.Bar)obj).getLeft() != null ? ((HorizontalBarChart.Bar)obj).getLeft().doubleValue() : 0.0);
                min = this.nullSafeMin(min, ((HorizontalBarChart.Bar)obj).getRight() != null ? ((HorizontalBarChart.Bar)obj).getRight().doubleValue() : 0.0);
                continue;
            }
            if (obj instanceof NullElement) continue;
            throw new IllegalArgumentException("Cannot process Objects of Class: " + String.valueOf(obj.getClass()));
        }
        if (min == null) {
            min = 0.0;
        }
        return min;
    }

    private Double nullSafeMin(Double min, double doubleValue) {
        if (min == null) {
            min = doubleValue;
        }
        min = Math.min(min, doubleValue);
        return min;
    }

    public String getKey_on_click() {
        return this.key_on_click;
    }

    public void setKey_on_click(String key_on_click) {
        this.key_on_click = key_on_click;
    }

    public void setToggleVisibility() {
        this.key_on_click = ON_CLICK_TOGGLE_VISIBILITY;
    }
}

