/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.internal.fxg.dom.AbstractShapeNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import flash.swf.types.LineStyle;
import flash.swf.types.Rect;
import flash.swf.types.ShapeRecord;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipseNode
extends AbstractShapeNode {
    public double width = 0.0;
    public double height = 0.0;

    @Override
    public String getNodeName() {
        return "Ellipse";
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name);
        } else {
            super.setAttribute(name, value);
        }
    }

    @Override
    public Rect getBounds(List<ShapeRecord> records, LineStyle ls) {
        int x1 = 0;
        int y1 = 0;
        int x2 = (int)(this.width * 20.0);
        int y2 = (int)(this.height * 20.0);
        if (ls != null) {
            int width = 20;
            if (width < ls.width) {
                width = ls.width;
            }
            int stroke = (int)Math.rint((double)width / 2.0);
            x1 -= stroke;
            y1 -= stroke;
            x2 += stroke;
            y2 += stroke;
        }
        return new Rect(x1, x2, y1, y2);
    }
}

