/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http.proxy;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.services.http.ExternalProxySettings;
import flex.messaging.services.http.httpclient.FlexGetMethod;
import flex.messaging.services.http.httpclient.FlexPostMethod;
import flex.messaging.services.http.proxy.CookieInfo;
import flex.messaging.services.http.proxy.ProxyContext;
import flex.messaging.services.http.proxy.ProxyException;
import flex.messaging.services.http.proxy.ProxyFilter;
import flex.messaging.services.http.proxy.ProxyUtil;
import flex.messaging.services.http.proxy.RequestUtil;
import flex.messaging.services.http.proxy.Target;
import flex.messaging.util.StringUtils;
import flex.messaging.util.URLEncoder;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;

public class RequestFilter
extends ProxyFilter {
    private static final int CAUGHT_ERROR = 10706;
    private static final int UNKNOWN_HOST = 10707;
    private static final int INVALID_METHOD = 10719;
    private static final String STRING_JSESSIONID = "jsessionid";

    public void invoke(ProxyContext context) {
        this.setupRequest(context);
        RequestFilter.copyCookiesToEndpoint(context);
        RequestFilter.copyHeadersToEndpoint(context);
        this.addCustomHeaders(context);
        this.recordRequestHeaders(context);
        this.sendRequest(context);
        if (this.next != null) {
            this.next.invoke(context);
        }
    }

    protected void setupRequest(ProxyContext context) {
        String proxyServer;
        ExternalProxySettings externalProxy = context.getExternalProxySettings();
        if (externalProxy != null && (proxyServer = externalProxy.getProxyServer()) != null) {
            context.getTarget().getHostConfig().setProxy(proxyServer, externalProxy.getProxyPort());
            if (context.getProxyCredentials() != null) {
                context.getHttpClient().getState().setProxyCredentials(ProxyUtil.getDefaultAuthScope(), (Credentials)context.getProxyCredentials());
            }
        }
        String method = context.getMethod();
        String encodedPath = context.getTarget().getEncodedPath();
        if ("POST".equals(method)) {
            FlexPostMethod postMethod = new FlexPostMethod(encodedPath);
            context.setHttpMethod((HttpMethodBase)postMethod);
            if (context.hasAuthorization()) {
                postMethod.setConnectionForced(true);
            }
        } else if ("GET".equals(method)) {
            FlexGetMethod getMethod = new FlexGetMethod(context.getTarget().getEncodedPath());
            context.setHttpMethod((HttpMethodBase)getMethod);
            if (context.hasAuthorization()) {
                getMethod.setConnectionForced(true);
            }
        } else if ("HEAD".equals(method)) {
            HeadMethod headMethod = new HeadMethod(encodedPath);
            context.setHttpMethod((HttpMethodBase)headMethod);
        } else if ("PUT".equals(method)) {
            PutMethod putMethod = new PutMethod(encodedPath);
            context.setHttpMethod((HttpMethodBase)putMethod);
        } else if ("OPTIONS".equals(method)) {
            OptionsMethod optionsMethod = new OptionsMethod(encodedPath);
            context.setHttpMethod((HttpMethodBase)optionsMethod);
        } else if ("DELETE".equals(method)) {
            DeleteMethod deleteMethod = new DeleteMethod(encodedPath);
            context.setHttpMethod((HttpMethodBase)deleteMethod);
        } else if ("TRACE".equals(method)) {
            TraceMethod traceMethod = new TraceMethod(encodedPath);
            context.setHttpMethod((HttpMethodBase)traceMethod);
        } else {
            ProxyException pe = new ProxyException(10719);
            pe.setDetails(10719, "1", new Object[]{method});
            throw pe;
        }
        HttpMethodBase httpMethod = context.getHttpMethod();
        if (httpMethod instanceof EntityEnclosingMethod) {
            ((EntityEnclosingMethod)httpMethod).setContentChunked(context.getContentChunked());
        }
    }

    public static void copyCookiesToEndpoint(ProxyContext context) {
        HttpServletRequest clientRequest = FlexContext.getHttpRequest();
        if (clientRequest != null) {
            javax.servlet.http.Cookie[] cookies = clientRequest.getCookies();
            HttpState initState = context.getHttpClient().getState();
            if (cookies != null) {
                TreeMap<Integer, ArrayList<CookieInfo>> cookieMap = new TreeMap<Integer, ArrayList<CookieInfo>>();
                for (int i = 0; i < cookies.length; ++i) {
                    javax.servlet.http.Cookie cookie = cookies[i];
                    CookieInfo origCookie = new CookieInfo(cookie.getName(), cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getMaxAge(), null, cookie.getSecure());
                    CookieInfo newCookie = RequestUtil.createCookie(origCookie, context, context.getTarget().getUrl().getHost(), context.getTarget().getUrl().getPath());
                    if (newCookie == null) continue;
                    Integer pathInt = 0 - newCookie.path.length();
                    ArrayList<CookieInfo> list = (ArrayList<CookieInfo>)cookieMap.get(pathInt);
                    if (list == null) {
                        list = new ArrayList<CookieInfo>();
                        cookieMap.put(pathInt, list);
                    }
                    list.add(newCookie);
                }
                for (ArrayList list : cookieMap.values()) {
                    for (CookieInfo cookieInfo : list) {
                        FlexSession flexSession;
                        if (Log.isInfo()) {
                            String str = "-- Cookie in request: " + cookieInfo;
                            Log.getLogger((String)"Service.HTTP").debug(str);
                        }
                        Cookie cookie = new Cookie(cookieInfo.domain, cookieInfo.name, cookieInfo.value, cookieInfo.path, cookieInfo.maxAge, cookieInfo.secure);
                        if (context.isLocalDomain() && STRING_JSESSIONID.equalsIgnoreCase(cookieInfo.clientName) && (flexSession = FlexContext.getFlexSession()) != null && flexSession.isValid()) {
                            String sessionId = flexSession.getId();
                            String cookieValue = cookie.getValue();
                            if (!cookieValue.contains(sessionId)) {
                                int colonIndex = cookieValue.indexOf(":");
                                if (colonIndex != -1) {
                                    boolean isWebSphere;
                                    ServletContext servletContext = FlexContext.getServletContext();
                                    String serverInfo = servletContext != null ? servletContext.getServerInfo() : null;
                                    boolean bl = isWebSphere = serverInfo != null ? serverInfo.contains("WebSphere") : false;
                                    if (isWebSphere) {
                                        String cacheId = cookieValue.substring(0, 4);
                                        String cloneId = cookieValue.substring(colonIndex);
                                        String wsSessionId = cacheId + sessionId + cloneId;
                                        cookie.setValue(wsSessionId);
                                    } else {
                                        cookie.setValue(sessionId);
                                    }
                                } else {
                                    cookie.setValue(sessionId);
                                }
                            }
                        }
                        initState.addCookie(cookie);
                    }
                }
            }
        }
    }

    public static void copyHeadersToEndpoint(ProxyContext context) {
        HttpServletRequest clientRequest = FlexContext.getHttpRequest();
        if (clientRequest != null) {
            Enumeration headerNames = clientRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (RequestUtil.ignoreHeader(headerName, context)) continue;
                Enumeration headers = clientRequest.getHeaders(headerName);
                while (headers.hasMoreElements()) {
                    String value = (String)headers.nextElement();
                    context.getHttpMethod().addRequestHeader(headerName, value);
                    if (!Log.isInfo()) continue;
                    Log.getLogger((String)"Service.HTTP").debug("-- Header in request: " + headerName + " : " + value);
                }
            }
        }
    }

    protected void addCustomHeaders(ProxyContext context) {
        Map customHeaders;
        HttpMethodBase httpMethod = context.getHttpMethod();
        String contentType = context.getContentType();
        if (contentType != null) {
            httpMethod.setRequestHeader("Content-Type", contentType);
        }
        if ((customHeaders = context.getHeaders()) != null) {
            for (String name : customHeaders.keySet()) {
                Object value = customHeaders.get(name);
                if (value == null) {
                    httpMethod.setRequestHeader(name, "");
                    continue;
                }
                if (value instanceof String) {
                    httpMethod.setRequestHeader(name, (String)value);
                    continue;
                }
                if (value instanceof List) {
                    List valueList = (List)value;
                    for (Object currentValue : valueList) {
                        if (currentValue == null) {
                            httpMethod.addRequestHeader(name, "");
                            continue;
                        }
                        httpMethod.addRequestHeader(name, (String)currentValue);
                    }
                    continue;
                }
                if (!value.getClass().isArray()) continue;
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    Object currentValue;
                    currentValue = valueArray[i];
                    if (currentValue == null) {
                        httpMethod.addRequestHeader(name, "");
                        continue;
                    }
                    httpMethod.addRequestHeader(name, (String)currentValue);
                }
            }
        }
        if (context.isSoapRequest()) {
            context.getHttpMethod().setRequestHeader("Content-Type", "text/xml; charset=utf-8");
            String soapAction = null;
            Header header = context.getHttpMethod().getRequestHeader("SOAPAction");
            if (header != null) {
                soapAction = header.getValue();
            }
            if (soapAction == null) {
                HttpServletRequest clientRequest = FlexContext.getHttpRequest();
                if (clientRequest != null) {
                    soapAction = clientRequest.getHeader("SOAPAction");
                }
                if (soapAction != null && !soapAction.startsWith("\"") && !soapAction.endsWith("\"")) {
                    soapAction = "\"" + soapAction + "\"";
                }
                context.getHttpMethod().setRequestHeader("SOAPAction", soapAction);
            }
        }
    }

    protected void recordRequestHeaders(ProxyContext context) {
        Header[] headers;
        if (context.getRecordHeaders() && (headers = context.getHttpMethod().getRequestHeaders()) != null) {
            HashMap<String, Object> recordedHeaders = new HashMap<String, Object>();
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                String headerName = header.getName();
                String headerValue = header.getValue();
                Object existingHeaderValue = recordedHeaders.get(headerName);
                if (existingHeaderValue != null) {
                    ArrayList headerValues;
                    if (existingHeaderValue instanceof String) {
                        headerValues = new ArrayList();
                        headerValues.add(existingHeaderValue);
                        headerValues.add(headerValue);
                        recordedHeaders.put(headerName, headerValues);
                        continue;
                    }
                    if (!(existingHeaderValue instanceof ArrayList)) continue;
                    headerValues = (ArrayList)existingHeaderValue;
                    headerValues.add(headerValue);
                    continue;
                }
                recordedHeaders.put(headerName, headerValue);
            }
            context.setRequestHeaders(recordedHeaders);
        }
    }

    protected void sendRequest(ProxyContext context) {
        ProxyException pe;
        Object req;
        Target target = context.getTarget();
        String method = context.getMethod();
        HttpMethodBase httpMethod = context.getHttpMethod();
        if (httpMethod instanceof EntityEnclosingMethod) {
            Object data = this.processBody(context);
            Class<?> dataClass = data.getClass();
            if (data instanceof String) {
                String requestString = (String)data;
                if (Log.isInfo()) {
                    Logger logger = Log.getLogger((String)"Service.HTTP");
                    logger.debug("-- Begin " + method + " request --");
                    logger.debug(StringUtils.prettifyString((String)requestString));
                    logger.debug("-- End " + method + " request --");
                }
                try {
                    StringRequestEntity requestEntity = new StringRequestEntity(requestString, null, "UTF-8");
                    ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)requestEntity);
                }
                catch (UnsupportedEncodingException ex) {
                    ProxyException pe2 = new ProxyException(10706);
                    pe2.setDetails(10706, "1", new Object[]{ex});
                    throw pe2;
                }
            } else if (dataClass.isArray() && Byte.TYPE.equals(dataClass.getComponentType())) {
                byte[] dataBytes = (byte[])data;
                ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(dataBytes, context.getContentType());
                ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)requestEntity);
            } else if (data instanceof InputStream) {
                InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)data, context.getContentType());
                ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)requestEntity);
            }
        } else if (httpMethod instanceof GetMethod && (req = this.processBody(context)) instanceof String) {
            String requestString = (String)req;
            if (Log.isInfo()) {
                Logger logger = Log.getLogger((String)"Service.HTTP");
                logger.debug("-- Begin " + method + " request --");
                logger.debug(StringUtils.prettifyString((String)requestString));
                logger.debug("-- End " + method + " request --");
            }
            if (!"".equals(requestString)) {
                String query = context.getHttpMethod().getQueryString();
                query = query != null ? query + "&" + requestString : requestString;
                context.getHttpMethod().setQueryString(query);
            }
        }
        context.getHttpClient().setHostConfiguration(target.getHostConfig());
        try {
            context.getHttpClient().executeMethod((HttpMethod)context.getHttpMethod());
        }
        catch (UnknownHostException uhex) {
            pe = new ProxyException();
            pe.setMessage(10707, new Object[]{uhex.getMessage()});
            pe.setCode("Server.Proxy.Request.Failed");
            throw pe;
        }
        catch (Exception ex) {
            pe = new ProxyException(10706);
            pe.setDetails(10706, "1", new Object[]{ex.getMessage()});
            pe.setCode("Server.Proxy.Request.Failed");
            throw pe;
        }
    }

    protected Object processBody(ProxyContext context) {
        Object body = context.getBody();
        if (body == null) {
            return "";
        }
        if (body instanceof String) {
            return (String)body;
        }
        if (body instanceof Map) {
            Map params = (Map)body;
            StringBuffer postData = new StringBuffer();
            boolean formValues = false;
            for (String name : params.keySet()) {
                if (!formValues) {
                    formValues = true;
                } else {
                    postData.append("&");
                }
                Object vals = params.get(name);
                if (vals == null) {
                    this.encodeParam(postData, name, "");
                }
                if (vals instanceof String) {
                    String val = (String)vals;
                    this.encodeParam(postData, name, val);
                    continue;
                }
                if (vals instanceof List) {
                    List valLists = (List)vals;
                    for (int i = 0; i < valLists.size(); ++i) {
                        Object o = valLists.get(i);
                        String val = "";
                        if (o != null) {
                            val = o.toString();
                        }
                        if (i > 0) {
                            postData.append("&");
                        }
                        this.encodeParam(postData, name, val);
                    }
                    continue;
                }
                if (!vals.getClass().isArray()) continue;
                for (int i = 0; i < Array.getLength(vals); ++i) {
                    Object o = Array.get(vals, i);
                    String val = "";
                    if (o != null) {
                        val = o.toString();
                    }
                    if (i > 0) {
                        postData.append("&");
                    }
                    this.encodeParam(postData, name, val);
                }
            }
            return postData.toString();
        }
        if (body.getClass().isArray()) {
            return body;
        }
        if (body instanceof InputStream) {
            return body;
        }
        return body.toString();
    }

    protected void encodeParam(StringBuffer buf, String name, String val) {
        name = URLEncoder.encode((String)name);
        val = URLEncoder.encode((String)val);
        buf.append(name);
        buf.append("=");
        buf.append(val);
    }
}

