/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.classloader;

import com.opensymphony.xwork2.util.classloader.ResourceStore;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileResourceStore
implements ResourceStore {
    private static final Logger LOG = LoggerFactory.getLogger(FileResourceStore.class);
    private final File root;

    public FileResourceStore(File pFile) {
        this.root = pFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(String pResourceName) {
        FileInputStream fis = null;
        try {
            File file = this.getFile(pResourceName);
            byte[] data = new byte[(int)file.length()];
            fis = new FileInputStream(file);
            fis.read(data);
            byte[] byArray = data;
            this.closeQuietly(fis);
            return byArray;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to read file [#0]", e, pResourceName);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.closeQuietly(fis);
        }
    }

    @Override
    public void write(String pResourceName, byte[] pData) {
    }

    private void closeQuietly(InputStream is) {
        block3: {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Unable to close file input stream", e, new String[0]);
            }
        }
    }

    private File getFile(String pResourceName) {
        String fileName = pResourceName.replace('/', File.separatorChar);
        return new File(this.root, fileName);
    }

    public String toString() {
        return this.getClass().getName() + this.root.toString();
    }
}

