/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.NoParameters;
import com.opensymphony.xwork2.interceptor.ParameterNameAware;
import com.opensymphony.xwork2.security.AcceptedPatternsChecker;
import com.opensymphony.xwork2.security.ExcludedPatternsChecker;
import com.opensymphony.xwork2.util.ClearableValueStack;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.MemberAccessValueStack;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class ParametersInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ParametersInterceptor.class);
    protected static final int PARAM_NAME_MAX_LENGTH = 100;
    private int paramNameMaxLength = 100;
    private boolean devMode = false;
    protected boolean ordered = false;
    private ValueStackFactory valueStackFactory;
    private ExcludedPatternsChecker excludedPatterns;
    private AcceptedPatternsChecker acceptedPatterns;
    static final Comparator<String> rbCollator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int l2;
            int l1 = ParametersInterceptor.countOGNLCharacters(s1);
            return l1 < (l2 = ParametersInterceptor.countOGNLCharacters(s2)) ? -1 : (l2 < l1 ? 1 : s1.compareTo(s2));
        }
    };

    @Inject
    public void setValueStackFactory(ValueStackFactory valueStackFactory) {
        this.valueStackFactory = valueStackFactory;
    }

    @Inject(value="devMode")
    public void setDevMode(String mode) {
        this.devMode = "true".equalsIgnoreCase(mode);
    }

    @Inject
    public void setExcludedPatterns(ExcludedPatternsChecker excludedPatterns) {
        this.excludedPatterns = excludedPatterns;
    }

    @Inject
    public void setAcceptedPatterns(AcceptedPatternsChecker acceptedPatterns) {
        this.acceptedPatterns = acceptedPatterns;
    }

    public void setParamNameMaxLength(int paramNameMaxLength) {
        this.paramNameMaxLength = paramNameMaxLength;
    }

    private static int countOGNLCharacters(String s) {
        int count = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c != '.' && c != '[') continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (!(action instanceof NoParameters)) {
            ActionContext ac = invocation.getInvocationContext();
            Map<String, Object> parameters = this.retrieveParameters(ac);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting params " + this.getParameterLogMap(parameters), new String[0]);
            }
            if (parameters != null) {
                Map<String, Object> contextMap = ac.getContextMap();
                try {
                    ReflectionContextState.setCreatingNullObjects(contextMap, true);
                    ReflectionContextState.setDenyMethodExecution(contextMap, true);
                    ReflectionContextState.setReportingConversionErrors(contextMap, true);
                    ValueStack stack = ac.getValueStack();
                    this.setParameters(action, stack, parameters);
                }
                finally {
                    ReflectionContextState.setCreatingNullObjects(contextMap, false);
                    ReflectionContextState.setDenyMethodExecution(contextMap, false);
                    ReflectionContextState.setReportingConversionErrors(contextMap, false);
                }
            }
        }
        return invocation.invoke();
    }

    protected Map<String, Object> retrieveParameters(ActionContext ac) {
        return ac.getParameters();
    }

    protected void addParametersToContext(ActionContext ac, Map<String, Object> newParams) {
    }

    protected void setParameters(Object action, ValueStack stack, Map<String, Object> parameters) {
        boolean memberAccessStack;
        TreeMap acceptableParameters;
        TreeMap<String, Object> params;
        if (this.ordered) {
            params = new TreeMap(this.getOrderedComparator());
            acceptableParameters = new TreeMap(this.getOrderedComparator());
            params.putAll(parameters);
        } else {
            params = new TreeMap<String, Object>(parameters);
            acceptableParameters = new TreeMap();
        }
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.isAcceptableParameter(name, action)) continue;
            acceptableParameters.put(name, entry.getValue());
        }
        ValueStack newStack = this.valueStackFactory.createValueStack(stack);
        boolean clearableStack = newStack instanceof ClearableValueStack;
        if (clearableStack) {
            ((ClearableValueStack)((Object)newStack)).clearContextValues();
            Map<String, Object> context = newStack.getContext();
            ReflectionContextState.setCreatingNullObjects(context, true);
            ReflectionContextState.setDenyMethodExecution(context, true);
            ReflectionContextState.setReportingConversionErrors(context, true);
            context.put("com.opensymphony.xwork2.ActionContext.locale", stack.getContext().get("com.opensymphony.xwork2.ActionContext.locale"));
        }
        if (memberAccessStack = newStack instanceof MemberAccessValueStack) {
            MemberAccessValueStack accessValueStack = (MemberAccessValueStack)((Object)newStack);
            accessValueStack.setAcceptProperties(this.acceptedPatterns.getAcceptedPatterns());
            accessValueStack.setExcludeProperties(this.excludedPatterns.getExcludedPatterns());
        }
        for (Map.Entry entry : acceptableParameters.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                newStack.setParameter(name, value);
            }
            catch (RuntimeException e) {
                if (!this.devMode) continue;
                this.notifyDeveloperParameterException(action, name, e.getMessage());
            }
        }
        if (clearableStack && stack.getContext() != null && newStack.getContext() != null) {
            stack.getContext().put("com.opensymphony.xwork2.ActionContext.conversionErrors", newStack.getContext().get("com.opensymphony.xwork2.ActionContext.conversionErrors"));
        }
        this.addParametersToContext(ActionContext.getContext(), acceptableParameters);
    }

    protected void notifyDeveloperParameterException(Object action, String property, String message) {
        String developerNotification = LocalizedTextUtil.findText(ParametersInterceptor.class, "devmode.notification", ActionContext.getContext().getLocale(), "Developer Notification:\n{0}", new Object[]{"Unexpected Exception caught setting '" + property + "' on '" + action.getClass() + ": " + message});
        LOG.error(developerNotification, new String[0]);
        if (action instanceof ValidationAware) {
            Collection<String> messages = ((ValidationAware)action).getActionMessages();
            messages.add(message);
            ((ValidationAware)action).setActionMessages(messages);
        }
    }

    protected boolean isAcceptableParameter(String name, Object action) {
        ParameterNameAware parameterNameAware = action instanceof ParameterNameAware ? (ParameterNameAware)action : null;
        return this.acceptableName(name) && (parameterNameAware == null || parameterNameAware.acceptableParameterName(name));
    }

    protected Comparator<String> getOrderedComparator() {
        return rbCollator;
    }

    protected String getParameterLogMap(Map<String, Object> parameters) {
        if (parameters == null) {
            return "NONE";
        }
        StringBuilder logEntry = new StringBuilder();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            logEntry.append(String.valueOf(entry.getKey()));
            logEntry.append(" => ");
            if (entry.getValue() instanceof Object[]) {
                Object[] valueArray = (Object[])entry.getValue();
                logEntry.append("[ ");
                if (valueArray.length > 0) {
                    for (int indexA = 0; indexA < valueArray.length - 1; ++indexA) {
                        Object valueAtIndex = valueArray[indexA];
                        logEntry.append(String.valueOf(valueAtIndex));
                        logEntry.append(", ");
                    }
                    logEntry.append(String.valueOf(valueArray[valueArray.length - 1]));
                }
                logEntry.append(" ] ");
                continue;
            }
            logEntry.append(String.valueOf(entry.getValue()));
        }
        return logEntry.toString();
    }

    protected boolean acceptableName(String name) {
        boolean accepted;
        boolean bl = accepted = this.isWithinLengthLimit(name) && !this.isExcluded(name) && this.isAccepted(name);
        if (this.devMode && accepted) {
            LOG.debug("Parameter [#0] was accepted and will be appended to action!", name);
        }
        return accepted;
    }

    protected boolean isWithinLengthLimit(String name) {
        boolean matchLength;
        boolean bl = matchLength = name.length() <= this.paramNameMaxLength;
        if (!matchLength) {
            this.notifyDeveloper("Parameter [#0] is too long, allowed length is [#1]", name, String.valueOf(this.paramNameMaxLength));
        }
        return matchLength;
    }

    protected boolean isAccepted(String paramName) {
        AcceptedPatternsChecker.IsAccepted result = this.acceptedPatterns.isAccepted(paramName);
        if (result.isAccepted()) {
            return true;
        }
        this.notifyDeveloper("Parameter [#0] didn't match accepted pattern [#1]!", paramName, result.getAcceptedPattern());
        return false;
    }

    protected boolean isExcluded(String paramName) {
        ExcludedPatternsChecker.IsExcluded result = this.excludedPatterns.isExcluded(paramName);
        if (result.isExcluded()) {
            this.notifyDeveloper("Parameter [#0] matches excluded pattern [#1]!", paramName, result.getExcludedPattern());
            return true;
        }
        return false;
    }

    private void notifyDeveloper(String message, String ... parameters) {
        if (this.devMode) {
            LOG.warn(message, parameters);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(message, parameters);
        }
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setAcceptParamNames(String commaDelim) {
        this.acceptedPatterns.setAcceptedPatterns(commaDelim);
    }

    public void setExcludeParams(String commaDelim) {
        this.excludedPatterns.setExcludedPatterns(commaDelim);
    }
}

