/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.NoParameters;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ParameterRemoverInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterRemoverInterceptor.class);
    private static final long serialVersionUID = 1L;
    private Set<String> paramNames = Collections.emptySet();
    private Set<String> paramValues = Collections.emptySet();

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext ac;
        Map<String, Object> parameters;
        if (!(invocation.getAction() instanceof NoParameters) && null != this.paramNames && (parameters = (ac = invocation.getInvocationContext()).getParameters()) != null) {
            for (String removeName : this.paramNames) {
                if (!parameters.containsKey(removeName)) continue;
                try {
                    String[] values = (String[])parameters.get(removeName);
                    String value = values[0];
                    if (null == value || !this.paramValues.contains(value)) continue;
                    parameters.remove(removeName);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error("Failed to convert parameter to string", e, new String[0]);
                }
            }
        }
        return invocation.invoke();
    }

    public void setParamNames(String paramNames) {
        this.paramNames = TextParseUtil.commaDelimitedStringToSet(paramNames);
    }

    public void setParamValues(String paramValues) {
        this.paramValues = TextParseUtil.commaDelimitedStringToSet(paramValues);
    }
}

