/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.ConversionPropertiesProcessor;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.TypeConverterCreator;
import com.opensymphony.xwork2.conversion.TypeConverterHolder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DefaultConversionPropertiesProcessor
implements ConversionPropertiesProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConversionPropertiesProcessor.class);
    private TypeConverterCreator converterCreator;
    private TypeConverterHolder converterHolder;

    @Inject
    public void setTypeConverterCreator(TypeConverterCreator converterCreator) {
        this.converterCreator = converterCreator;
    }

    @Inject
    public void setTypeConverterHolder(TypeConverterHolder converterHolder) {
        this.converterHolder = converterHolder;
    }

    @Override
    public void process(String propsName) {
        this.loadConversionProperties(propsName, false);
    }

    @Override
    public void processRequired(String propsName) {
        this.loadConversionProperties(propsName, true);
    }

    public void loadConversionProperties(String propsName, boolean require) {
        block9: {
            try {
                Iterator<URL> resources = ClassLoaderUtil.getResources(propsName, this.getClass(), true);
                while (resources.hasNext()) {
                    URL url = resources.next();
                    Properties props = new Properties();
                    props.load(url.openStream());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("processing conversion file [" + propsName + "]", new String[0]);
                    }
                    Iterator<Map.Entry<Object, Object>> i$ = props.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry<Object, Object> o;
                        Map.Entry<Object, Object> entry = o = i$.next();
                        String key = (String)entry.getKey();
                        try {
                            TypeConverter _typeConverter = this.converterCreator.createTypeConverter((String)entry.getValue());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("\t" + key + ":" + entry.getValue() + " [treated as TypeConverter " + _typeConverter + "]", new String[0]);
                            }
                            this.converterHolder.addDefaultMapping(key, _typeConverter);
                        }
                        catch (Exception e) {
                            LOG.error("Conversion registration error", e, new String[0]);
                        }
                    }
                }
            }
            catch (IOException ex) {
                if (require) {
                    throw new XWorkException("Cannot load conversion properties file: " + propsName, ex);
                }
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("Cannot load conversion properties file: #0", ex, propsName);
            }
        }
    }
}

