/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;
import net.sf.swarmcache.CacheConfiguration;
import net.sf.swarmcache.CacheFactory;
import net.sf.swarmcache.ObjectCache;

public class CacheTest {
    private static Random random = new Random();
    public static final int RANDOM_KEY_LENGTH = 20;
    public static final int RANDOM_VALUE_LENGTH = 1000;

    private static String readLine(InputStream in) throws IOException {
        String result = "";
        char c = (char)in.read();
        while (c != '\n' && c != '\u0000') {
            result = result + in.read();
            c = (char)in.read();
        }
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    private static String randomString(int length) {
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)(97 + (int)(Math.random() * 26.0));
            ++i;
        }
        return new String(chars);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Local: " + InetAddress.getLocalHost());
            System.out.println("Args: [[[<multicast IP>] <cache-type>] <lru-cache-size>]");
            CacheConfiguration conf = new CacheConfiguration();
            if (args.length > 0) {
                conf.setMulticastIP(args[0]);
            }
            if (args.length > 1) {
                conf.setCacheType(args[1]);
            }
            if (args.length > 2) {
                conf.setLRUCacheSize(args[2]);
            }
            boolean finalizerString = false;
            if ("Auto".equals(conf.getCacheType()) || "Hybrid".equals(conf.getCacheType())) {
                finalizerString = true;
            }
            String local = InetAddress.getLocalHost().getHostAddress();
            System.out.println("LOCAL: " + local);
            CacheFactory factory = new CacheFactory(conf);
            ObjectCache cache = factory.createCache("TEST");
            System.out.println("Cache has been initialized.");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("New stream created.");
            String input = in.readLine();
            while (input != null) {
                StringTokenizer st = new StringTokenizer(input);
                String command = st.nextToken();
                if ("PUT".equalsIgnoreCase(command)) {
                    String key = st.nextToken();
                    String value = st.nextToken();
                    if (finalizerString) {
                        cache.put((Serializable)((Object)key), new FinalizerString(value));
                    } else {
                        cache.put((Serializable)((Object)key), value);
                    }
                    System.out.println("Put '" + value + "' in to the cache with key '" + key + "'.");
                } else if ("GET".equalsIgnoreCase(command)) {
                    String key = st.nextToken();
                    Object o = cache.get((Serializable)((Object)key));
                    System.out.println("Getting '" + key + "' from cache returned '" + o + "'.");
                } else if ("CLEAR".equalsIgnoreCase(command)) {
                    String key = st.nextToken();
                    cache.clear((Serializable)((Object)key));
                    System.out.println("Cleared '" + key + "' from the cache.");
                } else if ("CLEARALL".equalsIgnoreCase(command)) {
                    cache.clearAll();
                    System.out.println("Cleared all keys from cache.");
                } else if ("FILL".equalsIgnoreCase(command)) {
                    int n = Integer.parseInt(st.nextToken());
                    int i = 0;
                    while (i < n) {
                        String key = CacheTest.randomString(20);
                        String value = CacheTest.randomString(1000);
                        cache.put((Serializable)((Object)key), value);
                        ++i;
                    }
                    System.out.println("Put " + n + " random strings of length " + 1000 + " in to the cache.");
                } else if ("LOADTEST".equalsIgnoreCase(command)) {
                    int numKeys = Integer.parseInt(st.nextToken());
                    int accessesPerSecond = Integer.parseInt(st.nextToken());
                    int writesPerThousand = Integer.parseInt(st.nextToken());
                    int numberOfSeconds = Integer.parseInt(st.nextToken());
                    int numberOfThreads = Integer.parseInt(st.nextToken());
                    int i = 0;
                    while (i < numberOfThreads) {
                        LoadTester tester = new LoadTester(cache, numKeys, accessesPerSecond, writesPerThousand, numberOfSeconds);
                        new Thread((Runnable)tester, "LoadTest-" + (i + 1)).start();
                        ++i;
                    }
                } else if ("MEMORY".equalsIgnoreCase(command)) {
                    int numberOfThreads = Integer.parseInt(st.nextToken());
                    System.out.println("Causing an OutOfMemoryError with " + numberOfThreads + " threads...");
                    int i = 0;
                    while (i < numberOfThreads) {
                        new Thread(new Runnable(){

                            public void run() {
                                LinkedList<String> l = new LinkedList<String>();
                                while (true) {
                                    l.add(CacheTest.randomString(1000));
                                }
                            }
                        }, "Memory-" + (i + 1)).start();
                        ++i;
                    }
                } else if ("CPU".equalsIgnoreCase(command)) {
                    final int numberOfSeconds = Integer.parseInt(st.nextToken());
                    System.out.println("Causing high CPU load for " + numberOfSeconds + " seconds...");
                    new Thread(new Runnable(){

                        public void run() {
                            long startTime = System.currentTimeMillis();
                            long endTime = startTime + (long)(1000 * numberOfSeconds);
                            while (System.currentTimeMillis() < endTime) {
                                double a = 0.0;
                                int i = 0;
                                while (i < 1000) {
                                    a = Math.random() * 50000.0;
                                    a = Math.sqrt(a);
                                    ++i;
                                }
                            }
                        }
                    }, "CPU-loader").start();
                } else {
                    System.out.println("Unrecognized command: '" + command + "'.");
                }
                input = in.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class FinalizerString {
        private String s;

        public FinalizerString(String string) {
            this.s = string;
        }

        public boolean equals(Object o) {
            return this.s.equals(o);
        }

        public String toString() {
            return this.s;
        }

        protected void finalize() throws Throwable {
            System.out.println("Finalized: \"" + this.s + "\".");
        }
    }

    public static class LoadTester
    implements Runnable {
        private ObjectCache cache;
        private int numKeys;
        private int operationsPerSecond;
        private int writesPerThousand;
        private int numberOfSeconds;

        public LoadTester(ObjectCache cache, int numKeys, int operationsPerSecond, int writesPerThousand, int numberOfSeconds) {
            this.cache = cache;
            this.numKeys = numKeys;
            this.operationsPerSecond = operationsPerSecond;
            this.writesPerThousand = writesPerThousand;
            this.numberOfSeconds = numberOfSeconds;
        }

        public void run() {
            System.out.println(">>> Thread " + Thread.currentThread().getName() + " starting load test.");
            this.loadTest();
            System.out.println(">>> Thread " + Thread.currentThread().getName() + " completed load test.");
        }

        private void loadTest() {
            int maxWaitTime = 2000 / this.operationsPerSecond;
            long startTime = System.currentTimeMillis();
            long stopTime = startTime + (long)(1000 * this.numberOfSeconds);
            long currentTime = System.currentTimeMillis();
            while (currentTime < stopTime) {
                int waitTime = random.nextInt(maxWaitTime);
                currentTime = System.currentTimeMillis();
                String key = "" + random.nextInt(this.numKeys);
                if (random.nextInt(1000) < this.writesPerThousand) {
                    this.cache.put((Serializable)((Object)key), key);
                } else {
                    this.cache.get((Serializable)((Object)key));
                }
                long pauseTime = (long)waitTime - (System.currentTimeMillis() - currentTime);
                if (pauseTime <= 0L) continue;
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }
}

