/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.ng;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

public class PrepareOperations {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareOperations.class);
    private Dispatcher dispatcher;
    private static final String STRUTS_ACTION_MAPPING_KEY = "struts.actionMapping";
    public static final String CLEANUP_RECURSION_COUNTER = "__cleanup_recursion_counter";
    private Logger log = LoggerFactory.getLogger(PrepareOperations.class);

    @Deprecated
    public PrepareOperations(ServletContext servletContext, Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public PrepareOperations(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ActionContext createActionContext(HttpServletRequest request, HttpServletResponse response) {
        ActionContext ctx;
        ActionContext oldContext;
        Integer counter = 1;
        Integer oldCounter = (Integer)request.getAttribute(CLEANUP_RECURSION_COUNTER);
        if (oldCounter != null) {
            counter = oldCounter + 1;
        }
        if ((oldContext = ActionContext.getContext()) != null) {
            ctx = new ActionContext(new HashMap(oldContext.getContextMap()));
        } else {
            ValueStack stack = ((ValueStackFactory)this.dispatcher.getContainer().getInstance(ValueStackFactory.class)).createValueStack();
            stack.getContext().putAll(this.dispatcher.createContextMap(request, response, null));
            ctx = new ActionContext(stack.getContext());
        }
        request.setAttribute(CLEANUP_RECURSION_COUNTER, (Object)counter);
        ActionContext.setContext((ActionContext)ctx);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupRequest(HttpServletRequest request) {
        Integer counterVal = (Integer)request.getAttribute(CLEANUP_RECURSION_COUNTER);
        if (counterVal != null) {
            counterVal = counterVal - 1;
            request.setAttribute(CLEANUP_RECURSION_COUNTER, (Object)counterVal);
            if (counterVal > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("skipping cleanup counter=" + counterVal, new String[0]);
                }
                return;
            }
        }
        try {
            this.dispatcher.cleanUpRequest(request);
        }
        finally {
            ActionContext.setContext(null);
            Dispatcher.setInstance(null);
        }
    }

    public void assignDispatcherToThread() {
        Dispatcher.setInstance(this.dispatcher);
    }

    public void setEncodingAndLocale(HttpServletRequest request, HttpServletResponse response) {
        this.dispatcher.prepare(request, response);
    }

    public HttpServletRequest wrapRequest(HttpServletRequest oldRequest) throws ServletException {
        HttpServletRequest request = oldRequest;
        try {
            request = this.dispatcher.wrapRequest(request);
            ServletActionContext.setRequest(request);
        }
        catch (IOException e) {
            throw new ServletException("Could not wrap servlet request with MultipartRequestWrapper!", (Throwable)e);
        }
        return request;
    }

    public ActionMapping findActionMapping(HttpServletRequest request, HttpServletResponse response) {
        return this.findActionMapping(request, response, false);
    }

    public ActionMapping findActionMapping(HttpServletRequest request, HttpServletResponse response, boolean forceLookup) {
        ActionMapping mapping;
        block4: {
            mapping = (ActionMapping)request.getAttribute(STRUTS_ACTION_MAPPING_KEY);
            if (mapping == null || forceLookup) {
                try {
                    mapping = ((ActionMapper)this.dispatcher.getContainer().getInstance(ActionMapper.class)).getMapping(request, this.dispatcher.getConfigurationManager());
                    if (mapping != null) {
                        request.setAttribute(STRUTS_ACTION_MAPPING_KEY, (Object)mapping);
                    }
                }
                catch (Exception ex) {
                    if (!this.dispatcher.isHandleException() && !this.dispatcher.isDevMode()) break block4;
                    this.dispatcher.sendError(request, response, 500, ex);
                }
            }
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDispatcher() {
        if (this.dispatcher == null) {
            throw new StrutsException("Something is seriously wrong, Dispatcher is not initialized (null) ");
        }
        try {
            this.dispatcher.cleanup();
        }
        finally {
            ActionContext.setContext(null);
        }
    }

    public boolean isUrlExcluded(HttpServletRequest request, List<Pattern> excludedPatterns) {
        if (excludedPatterns != null) {
            String uri = RequestUtils.getUri(request);
            for (Pattern pattern : excludedPatterns) {
                if (!pattern.matcher(uri).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

