/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.freemarker.ScopesHashModel;

public class FreemarkerTemplateEngine
extends BaseTemplateEngine {
    static Class bodyContent = null;
    protected FreemarkerManager freemarkerManager;
    private static final Logger LOG;

    @Inject
    public void setFreemarkerManager(FreemarkerManager mgr) {
        this.freemarkerManager = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Writer writer;
        ActionInvocation ai;
        ValueStack stack = templateContext.getStack();
        Map context = stack.getContext();
        ServletContext servletContext = (ServletContext)context.get("com.opensymphony.xwork2.dispatcher.ServletContext");
        HttpServletRequest req = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse res = (HttpServletResponse)context.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        Configuration config = this.freemarkerManager.getConfiguration(servletContext);
        List<Template> templates = templateContext.getTemplate().getPossibleTemplates(this);
        freemarker.template.Template template = null;
        String templateName = null;
        Throwable exception = null;
        for (Template t : templates) {
            templateName = this.getFinalTemplateName(t);
            try {
                template = config.getTemplate(templateName);
                break;
            }
            catch (ParseException e) {
                exception = e;
                break;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (template == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Could not load the FreeMarker template named '" + templateContext.getTemplate().getName() + "':", new String[0]);
                for (Template t : templates) {
                    LOG.error("Attempted: " + this.getFinalTemplateName(t), new String[0]);
                }
                LOG.error("The TemplateLoader provided by the FreeMarker Configuration was a: " + config.getTemplateLoader().getClass().getName(), new String[0]);
            }
            if (exception != null) {
                throw exception;
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rendering template " + templateName, new String[0]);
        }
        Object action = (ai = ActionContext.getContext().getActionInvocation()) == null ? null : ai.getAction();
        ScopesHashModel model = this.freemarkerManager.buildTemplateModel(stack, action, servletContext, req, res, config.getObjectWrapper());
        model.put("tag", templateContext.getTag());
        model.put("themeProperties", this.getThemeProps(templateContext.getTemplate()));
        final Writer wrapped = writer = templateContext.getWriter();
        writer = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                wrapped.write(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                wrapped.close();
            }
        };
        try {
            stack.push((Object)templateContext.getTag());
            template.process((Object)model, writer);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    protected String getSuffix() {
        return "ftl";
    }

    static {
        try {
            bodyContent = ClassLoaderUtil.loadClass((String)"javax.servlet.jsp.tagext.BodyContent", FreemarkerTemplateEngine.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOG = LoggerFactory.getLogger(FreemarkerTemplateEngine.class);
    }
}

