/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.NotTransactional;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionConfigurationAttributes;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAspectUtils;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(TransactionalTestExecutionListener.class);
    protected final TransactionAttributeSource attributeSource = new AnnotationTransactionAttributeSource();
    private TransactionConfigurationAttributes configurationAttributes;
    private volatile int transactionsStarted = 0;
    private final Map<Method, TransactionContext> transactionContextCache = Collections.synchronizedMap(new IdentityHashMap());

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        final Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        if (this.transactionContextCache.remove(testMethod) != null) {
            throw new IllegalStateException("Cannot start new transaction without ending existing transaction: Invoke endTransaction() before startNewTransaction().");
        }
        if (testMethod.isAnnotationPresent(NotTransactional.class)) {
            return;
        }
        TransactionAttribute transactionAttribute = this.attributeSource.getTransactionAttribute(testMethod, testContext.getTestClass());
        DelegatingTransactionAttribute transactionDefinition = null;
        if (transactionAttribute != null) {
            transactionDefinition = new DelegatingTransactionAttribute(transactionAttribute){

                public String getName() {
                    return testMethod.getName();
                }
            };
        }
        if (transactionDefinition != null) {
            PlatformTransactionManager tm;
            String qualifier;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Explicit transaction definition [" + transactionDefinition + "] found for test context [" + (Object)((Object)testContext) + "]"));
            }
            if (StringUtils.hasLength((String)(qualifier = transactionAttribute.getQualifier()))) {
                AutowireCapableBeanFactory bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
                tm = TransactionAspectUtils.getTransactionManager((BeanFactory)bf, (String)qualifier);
            } else {
                tm = this.getTransactionManager(testContext);
            }
            TransactionContext txContext = new TransactionContext(tm, (TransactionDefinition)transactionDefinition);
            this.runBeforeTransactionMethods(testContext);
            this.startNewTransaction(testContext, txContext);
            this.transactionContextCache.put(testMethod, txContext);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        TransactionContext txContext = this.transactionContextCache.remove(testMethod);
        if (txContext != null && !txContext.transactionStatus.isCompleted()) {
            try {
                this.endTransaction(testContext, txContext);
            }
            finally {
                this.runAfterTransactionMethods(testContext);
            }
        }
    }

    protected void runBeforeTransactionMethods(TestContext testContext) throws Exception {
        try {
            List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), BeforeTransaction.class);
            Collections.reverse(methods);
            for (Method method : methods) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @BeforeTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]"));
                }
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
        }
        catch (InvocationTargetException ex) {
            logger.error((Object)("Exception encountered while executing @BeforeTransaction methods for test context [" + (Object)((Object)testContext) + "]"), ex.getTargetException());
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
        }
    }

    protected void runAfterTransactionMethods(TestContext testContext) throws Exception {
        Throwable afterTransactionException = null;
        List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), AfterTransaction.class);
        for (Method method : methods) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @AfterTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]"));
                }
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (afterTransactionException == null) {
                    afterTransactionException = targetException;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]"), targetException);
            }
            catch (Exception ex) {
                if (afterTransactionException == null) {
                    afterTransactionException = ex;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]"), (Throwable)ex);
            }
        }
        if (afterTransactionException != null) {
            ReflectionUtils.rethrowException(afterTransactionException);
        }
    }

    private void startNewTransaction(TestContext testContext, TransactionContext txContext) throws Exception {
        txContext.startTransaction();
        ++this.transactionsStarted;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Began transaction (" + this.transactionsStarted + "): transaction manager [" + txContext.transactionManager + "]; rollback [" + this.isRollback(testContext) + "]"));
        }
    }

    private void endTransaction(TestContext testContext, TransactionContext txContext) throws Exception {
        boolean rollback = this.isRollback(testContext);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Ending transaction for test context [" + (Object)((Object)testContext) + "]; transaction manager [" + txContext.transactionStatus + "]; rollback [" + rollback + "]"));
        }
        txContext.endTransaction(rollback);
        if (logger.isInfoEnabled()) {
            logger.info((Object)(String.valueOf(rollback ? "Rolled back" : "Committed") + " transaction after test execution for test context [" + (Object)((Object)testContext) + "]"));
        }
    }

    protected final PlatformTransactionManager getTransactionManager(TestContext testContext) {
        String tmName = this.retrieveConfigurationAttributes(testContext).getTransactionManagerName();
        try {
            return (PlatformTransactionManager)testContext.getApplicationContext().getBean(tmName, PlatformTransactionManager.class);
        }
        catch (BeansException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Caught exception while retrieving transaction manager with bean name [" + tmName + "] for test context [" + (Object)((Object)testContext) + "]"), (Throwable)ex);
            }
            throw ex;
        }
    }

    protected final boolean isDefaultRollback(TestContext testContext) throws Exception {
        return this.retrieveConfigurationAttributes(testContext).isDefaultRollback();
    }

    protected final boolean isRollback(TestContext testContext) throws Exception {
        boolean rollback = this.isDefaultRollback(testContext);
        Rollback rollbackAnnotation = testContext.getTestMethod().getAnnotation(Rollback.class);
        if (rollbackAnnotation != null) {
            boolean rollbackOverride = rollbackAnnotation.value();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method-level @Rollback(" + rollbackOverride + ") overrides default rollback [" + rollback + "] for test context [" + (Object)((Object)testContext) + "]"));
            }
            rollback = rollbackOverride;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No method-level @Rollback override: using default rollback [" + rollback + "] for test context [" + (Object)((Object)testContext) + "]"));
        }
        return rollback;
    }

    private List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList results = new ArrayList();
        Class<?> current = clazz;
        while (current != null) {
            results.add(current);
            current = current.getSuperclass();
        }
        return results;
    }

    private List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Class<?> eachClass : this.getSuperClasses(clazz)) {
            Method[] methods;
            Method[] methodArray = methods = eachClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method eachMethod = methodArray[n2];
                Annotation annotation = eachMethod.getAnnotation(annotationType);
                if (annotation != null && !this.isShadowed(eachMethod, results)) {
                    results.add(eachMethod);
                }
                ++n2;
            }
        }
        return results;
    }

    private boolean isShadowed(Method method, List<Method> previousMethods) {
        for (Method each : previousMethods) {
            if (!this.isShadowed(method, each)) continue;
            return true;
        }
        return false;
    }

    private boolean isShadowed(Method current, Method previous) {
        if (!previous.getName().equals(current.getName())) {
            return false;
        }
        if (previous.getParameterTypes().length != current.getParameterTypes().length) {
            return false;
        }
        int i = 0;
        while (i < previous.getParameterTypes().length) {
            if (!previous.getParameterTypes()[i].equals(current.getParameterTypes()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private TransactionConfigurationAttributes retrieveConfigurationAttributes(TestContext testContext) {
        if (this.configurationAttributes == null) {
            boolean defaultRollback;
            String transactionManagerName;
            Class<?> clazz = testContext.getTestClass();
            Class<TransactionConfiguration> annotationType = TransactionConfiguration.class;
            TransactionConfiguration config = clazz.getAnnotation(annotationType);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved @TransactionConfiguration [" + config + "] for test class [" + clazz + "]"));
            }
            if (config != null) {
                transactionManagerName = config.transactionManager();
                defaultRollback = config.defaultRollback();
            } else {
                transactionManagerName = (String)AnnotationUtils.getDefaultValue(annotationType, (String)"transactionManager");
                defaultRollback = (Boolean)AnnotationUtils.getDefaultValue(annotationType, (String)"defaultRollback");
            }
            TransactionConfigurationAttributes configAttributes = new TransactionConfigurationAttributes(transactionManagerName, defaultRollback);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved TransactionConfigurationAttributes [" + configAttributes + "] for class [" + clazz + "]"));
            }
            this.configurationAttributes = configAttributes;
        }
        return this.configurationAttributes;
    }

    private static class TransactionContext {
        private final PlatformTransactionManager transactionManager;
        private final TransactionDefinition transactionDefinition;
        private TransactionStatus transactionStatus;

        public TransactionContext(PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
            this.transactionManager = transactionManager;
            this.transactionDefinition = transactionDefinition;
        }

        public void startTransaction() {
            this.transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        }

        public void endTransaction(boolean rollback) {
            if (rollback) {
                this.transactionManager.rollback(this.transactionStatus);
            } else {
                this.transactionManager.commit(this.transactionStatus);
            }
        }
    }
}

