/*
 * Decompiled with CFR 0.152.
 */
package jofc2.model.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jofc2.model.elements.Element;
import jofc2.model.metadata.Alias;
import jofc2.model.metadata.Converter;
import jofc2.util.PieChartSliceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieChart
extends Element {
    private static final long serialVersionUID = 8853434988212173862L;
    @Alias(value="start-angle")
    private Integer startAngle;
    private Collection<String> colours;
    private Boolean animate;
    private Integer border;
    private Integer radius;
    @Alias(value="no-labels")
    private Boolean noLabels;

    public PieChart() {
        super("pie");
    }

    public PieChart setAnimate(boolean animate) {
        this.animate = animate;
        return this;
    }

    public Boolean getAnimate() {
        return this.animate;
    }

    public Integer getStartAngle() {
        return this.startAngle;
    }

    public PieChart setStartAngle(Integer startAngle) {
        this.startAngle = startAngle;
        return this;
    }

    public Collection<String> getColours() {
        return this.colours;
    }

    public PieChart setColours(Collection<String> colours) {
        this.checkColours();
        this.colours = colours;
        return this;
    }

    public PieChart setColours(String ... colours) {
        this.checkColours();
        this.colours.clear();
        this.colours.addAll((Collection<String>)Arrays.asList(colours));
        return this;
    }

    public PieChart setColours(List<String> colours) {
        this.checkColours();
        this.colours.clear();
        this.colours.addAll(colours);
        return this;
    }

    public Integer getBorder() {
        return this.border;
    }

    public PieChart setBorder(Integer border) {
        this.border = border;
        return this;
    }

    public PieChart addValues(Number ... values) {
        this.getValues().addAll((Collection<Object>)Arrays.asList(values));
        return this;
    }

    public PieChart addValues(List<Number> values) {
        for (Number number : values) {
            if (number == null) continue;
            this.getValues().add(number);
        }
        return this;
    }

    public PieChart addSlice(Number value, String text) {
        return this.addSlices(new Slice(value, text));
    }

    public PieChart addSlices(Slice ... s) {
        this.getValues().addAll((Collection<Object>)Arrays.asList(s));
        return this;
    }

    public PieChart addSlices(List<Slice> values) {
        this.getValues().addAll(values);
        return this;
    }

    private synchronized void checkColours() {
        if (this.colours == null) {
            this.colours = new ArrayList<String>();
        }
    }

    public Boolean getNoLabels() {
        return this.noLabels;
    }

    public void setNoLabels(Boolean noLabels) {
        this.noLabels = noLabels;
    }

    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    @Converter(value=PieChartSliceConverter.class)
    public static class Slice
    implements Serializable {
        private static final long serialVersionUID = 6961394996186973937L;
        private final String label;
        private String tip;
        private String highlight = "alpha";
        private String text;
        private final Number value;

        public Slice(Number value, String label) {
            this.label = label;
            this.value = value;
        }

        public void setOnMouseOverAlpha() {
            this.highlight = "alpha";
        }

        public void setOnMouseOverBreakout() {
            this.highlight = null;
        }

        public Number getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getText() {
            return this.text;
        }

        public String getTip() {
            return this.tip;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public String getHighlight() {
            return this.highlight;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

