/*
 * Decompiled with CFR 0.152.
 */
package jofc2.model.elements;

import java.util.Arrays;
import java.util.List;
import jofc2.model.elements.Element;
import jofc2.model.metadata.Alias;
import jofc2.model.metadata.Converter;
import jofc2.util.BarConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChart
extends Element {
    private static final long serialVersionUID = 6695611795831460343L;
    private String colour;

    public BarChart() {
        this(Style.NORMAL);
    }

    public BarChart(Style style) {
        super(style.getStyle());
    }

    protected BarChart(String style) {
        super(style);
    }

    public BarChart addValues(Number ... values) {
        return this.addValues(Arrays.asList(values));
    }

    public BarChart addValues(List<Number> values) {
        for (Number number : values) {
            if (number == null) continue;
            this.addBars(new Bar(number));
        }
        return this;
    }

    public BarChart addBars(Bar ... bars) {
        return this.addBars(Arrays.asList(bars));
    }

    public BarChart addBars(List<Bar> bars) {
        this.getValues().addAll(bars);
        return this;
    }

    public String getColour() {
        return this.colour;
    }

    public BarChart setColour(String colour) {
        this.colour = colour;
        return this;
    }

    @Converter(value=BarConverter.class)
    public static class Bar {
        private Number top;
        private Number bottom;
        private String colour;
        @Alias(value="tip")
        private String tooltip;

        public Bar(Number top, Number bottom, String colour) {
            this.setTop(top);
            this.setBottom(bottom);
            this.setColour(colour);
        }

        public Bar(Number top, Number bottom) {
            this(top, bottom, null);
        }

        public Bar(Number top, String colour) {
            this(top, null, colour);
        }

        public Bar(Number top) {
            this(top, null, null);
        }

        public Number getTop() {
            return this.top;
        }

        public Bar setTop(Number top) {
            this.top = top;
            return this;
        }

        public Number getBottom() {
            return this.bottom;
        }

        public Bar setBottom(Number bottom) {
            this.bottom = bottom;
            return this;
        }

        public String getColour() {
            return this.colour;
        }

        public Bar setColour(String colour) {
            this.colour = colour;
            return this;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public Bar setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        NORMAL("bar"),
        THREED("bar_3d"),
        GLASS("bar_glass");

        private String style;

        private Style(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

