/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.util.ClassLoaderUtil;

public class IdentityXmlParser {
    List entities = new ArrayList();
    Map users = new HashMap();
    Map groups = new HashMap();

    public static Entity[] parseEntitiesResource(String resource) {
        return new IdentityXmlParser().parse(resource);
    }

    public static Entity[] parseEntitiesResource(InputStream inputStream) {
        return new IdentityXmlParser().parse(inputStream);
    }

    public Entity[] parse(String resource) {
        return this.parse(ClassLoaderUtil.getStream((String)resource));
    }

    public Entity[] parse(InputStream inputStream) {
        Document document;
        try {
            document = new SAXReader().read(inputStream);
        }
        catch (DocumentException e) {
            throw new RuntimeException("couldn't parse identities from stream '" + inputStream + "'");
        }
        Element identitiesRootElement = document.getRootElement();
        this.readUsers(identitiesRootElement.elements("user"));
        this.readGroups(identitiesRootElement.elements("group"));
        this.readParentGroups(identitiesRootElement.elements("group"));
        this.readMemberships(identitiesRootElement.elements("membership"));
        return this.entities.toArray(new Entity[this.entities.size()]);
    }

    private void readUsers(List userElements) {
        Iterator iter = userElements.iterator();
        while (iter.hasNext()) {
            Element userElement = (Element)iter.next();
            String name = userElement.attributeValue("name");
            String email = userElement.attributeValue("email");
            String password = userElement.attributeValue("password");
            User user = new User(name);
            user.setEmail(email);
            user.setPassword(password);
            this.users.put(name, user);
            this.entities.add(user);
        }
    }

    private void readGroups(List groupElements) {
        Iterator iter = groupElements.iterator();
        while (iter.hasNext()) {
            Element groupElement = (Element)iter.next();
            String name = groupElement.attributeValue("name");
            String type = groupElement.attributeValue("type");
            Group group = new Group(name);
            group.setType(type);
            this.entities.add(group);
            this.groups.put(name, group);
        }
    }

    private void readParentGroups(List groupElements) {
        Iterator iter = groupElements.iterator();
        while (iter.hasNext()) {
            Element groupElement = (Element)iter.next();
            String childName = groupElement.attributeValue("name");
            String parentName = groupElement.attributeValue("parent");
            if (parentName == null) continue;
            Group parent = (Group)this.groups.get(parentName);
            if (parent == null) {
                throw new RuntimeException("unexisting parent group '" + parentName + "'");
            }
            Group child = (Group)this.groups.get(childName);
            parent.addChild(child);
        }
    }

    private void readMemberships(List membershipElements) {
        Iterator iter = membershipElements.iterator();
        while (iter.hasNext()) {
            Element membershipElement = (Element)iter.next();
            String role = membershipElement.attributeValue("role");
            String userName = membershipElement.attributeValue("user");
            User user = (User)this.users.get(userName);
            if (user == null) {
                throw new RuntimeException("unexisting membership user '" + userName + "'");
            }
            String groupName = membershipElement.attributeValue("group");
            Group group = (Group)this.groups.get(groupName);
            if (group == null) {
                throw new RuntimeException("unexisting membership group '" + groupName + "'");
            }
            Membership membership = new Membership();
            membership.setRole(role);
            group.addMembership(membership);
            user.addMembership(membership);
            this.entities.add(membership);
        }
    }
}

