/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.test;

import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.exception.JRealTimeException;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.service.EdnaSocketApiService;
import cn.gyee.appsoft.jrt.service.IOperatorRealTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LinuxSocketUnit {
    protected static final Logger logger = Logger.getLogger((String)LinuxSocketUnit.class.getName());
    private static IOperatorRealTime operator;

    public static void main(String[] args) throws Exception {
        LinuxSocketUnit.createOperator();
        LinuxSocketUnit.getRealTimeData();
        LinuxSocketUnit.getMutRealTimeData();
        LinuxSocketUnit.getHisRawData();
        LinuxSocketUnit.getHisSnapData();
        LinuxSocketUnit.getSingleHisSnapData();
        LinuxSocketUnit.getHistoryMatrixSnapData();
        LinuxSocketUnit.getAvgHisSnapData();
        LinuxSocketUnit.getSingleAvgHisSnapData();
        LinuxSocketUnit.getMaxHisSnapData();
        LinuxSocketUnit.getSingleMaxHisSnapData();
        LinuxSocketUnit.getMinHisSnapData();
        LinuxSocketUnit.getSingleMinHisSnapData();
        LinuxSocketUnit.getRealTimeServices();
        LinuxSocketUnit.getLongId();
    }

    public static void createOperator() {
        operator = new EdnaSocketApiService();
    }

    public static void getRealTimeData() {
        logger.info((Object)"========================\u83b7\u53d6\u5355\u70b9\u5b9e\u65f6\u6570\u636e");
        long startTime = System.currentTimeMillis();
        PointData pd = operator.getRealTimeData("SIS.CALCUNIV.GLJ00639");
        if (pd != null) {
            System.out.println("UTC\u65f6\u95f4: ===" + pd.getUtcTime());
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getMutRealTimeData() {
        logger.info((Object)"========================\u83b7\u53d6\u591a\u70b9\u5b9e\u65f6\u6570\u636e");
        long startTime = System.currentTimeMillis();
        ArrayList<String> list = new ArrayList<String>();
        list.add("SIS.KLUNIV.KL000001");
        list.add("SIS.KLUNIV.KL000759");
        List<PointData> pds = operator.getRealTimeData(list);
        if (!pds.isEmpty()) {
            for (PointData pd : pds) {
                System.out.println("\u503c: ===" + pd.getValue() + pd.getPointId());
            }
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getHisRawData() {
        logger.info((Object)"========================\u83b7\u53d6\u5355\u70b9\u5386\u53f2\u539f\u59cb\u6570\u636e");
        long startTime = System.currentTimeMillis();
        List<PointData> pds = operator.getHistoryRawData("SIS.KLUNIV.KL000001", "2014-04-22 18:26:50", "2014-04-22 18:26:55");
        for (PointData pd : pds) {
            System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
            System.out.println("=================================================");
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e\u96c6\u5408");
        long startTime = System.currentTimeMillis();
        List<PointData> pds = operator.getHistorySnapData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00", 900);
        for (PointData pd : pds) {
            System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
            System.out.println("=================================================");
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getSingleHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e");
        long startTime = System.currentTimeMillis();
        PointData pd = operator.getHistorySnapData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00");
        System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
        System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
        System.out.println("\u503c: ===" + pd.getValue());
        System.out.println("\u72b6\u6001: ===" + pd.getStatus());
        System.out.println("=================================================");
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getHistoryMatrixSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\u591a\u70b9\u540c\u4e00\u65f6\u523b\u5386\u53f2\u5feb\u7167\u6570\u636e");
        long startTime = System.currentTimeMillis();
        ArrayList<String> list = new ArrayList<String>();
        list.add("SIS.KLUNIV.KL000001");
        list.add("SIS.KLUNIV.KL000002");
        List<PointData> pds = operator.getHistoryMatrixSnapData(list, "2014-04-22 09:54:34");
        if (!pds.isEmpty()) {
            for (PointData pd : pds) {
                System.out.println("\u503c: ===" + pd.getValue());
            }
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getAvgHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\uff08\u5e73\u5747\u503c\uff09\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e\u96c6\u5408");
        long startTime = System.currentTimeMillis();
        List<PointData> pds = operator.getAvgHistoryData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00", 900);
        for (PointData pd : pds) {
            System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
            System.out.println("=================================================");
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getSingleAvgHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\uff08\u5e73\u5747\u503c\uff09\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e");
        long startTime = System.currentTimeMillis();
        PointData pd = operator.getAvgHistoryData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00");
        System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
        System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
        System.out.println("\u503c: ===" + pd.getValue());
        System.out.println("\u72b6\u6001: ===" + pd.getStatus());
        System.out.println("=================================================");
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getMaxHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\uff08\u6700\u5927\u503c\uff09\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e\u96c6\u5408");
        long startTime = System.currentTimeMillis();
        List<PointData> pds = operator.getMaxHistoryData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00", 900);
        for (PointData pd : pds) {
            System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
            System.out.println("=================================================");
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getSingleMaxHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\uff08\u6700\u5927\u503c\uff09\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e\u96c6\u5408");
        long startTime = System.currentTimeMillis();
        PointData pd = operator.getMaxHistoryData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00");
        System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
        System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
        System.out.println("\u503c: ===" + pd.getValue());
        System.out.println("\u72b6\u6001: ===" + pd.getStatus());
        System.out.println("=================================================");
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getMinHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\uff08\u6700\u5c0f\u503c\uff09\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e\u96c6\u5408");
        long startTime = System.currentTimeMillis();
        List<PointData> pds = operator.getMinHistoryData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00", 900);
        for (PointData pd : pds) {
            System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
            System.out.println("=================================================");
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getSingleMinHisSnapData() {
        logger.info((Object)"========================\u83b7\u53d6\uff08\u6700\u5c0f\u503c\uff09\u5355\u70b9\u5386\u53f2\u5feb\u7167\u6570\u636e\u96c6\u5408");
        long startTime = System.currentTimeMillis();
        PointData pd = operator.getMinHistoryData("sis.calcuniv.hnj00009", "2014-06-27 00:00:00", "2014-06-29 00:00:00");
        System.out.println("UTC\u65f6\u95f4: ===" + EdnaApiHelper.parseUTCLongToDate(pd.getUtcTime().intValue()));
        System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
        System.out.println("\u503c: ===" + pd.getValue());
        System.out.println("\u72b6\u6001: ===" + pd.getStatus());
        System.out.println("=================================================");
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getRealTimeServices() {
        logger.info((Object)"========================\u83b7\u53d6EDNA\u6240\u6709\u670d\u52a1");
        long startTime = System.currentTimeMillis();
        List<String> serviceNames = operator.getRealTimeServices();
        if (serviceNames == null) {
            System.out.println("getRealTimeServices\u65b9\u6cd5\uff1a\u6ca1\u6709\u83b7\u53d6\u5230Edna\u670d\u52a1\uff01");
        } else {
            for (String name : serviceNames) {
                System.out.println("\u670d\u52a1\u540d\u79f0\u4e3a\uff1a " + name);
            }
        }
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void getLongId() {
        logger.info((Object)"========================\u901a\u8fc7FullName\u83b7\u53d6longID");
        long startTime = System.currentTimeMillis();
        String longId = operator.getLongId("SIS.JGUNIV.JG000010");
        System.out.println("longID\uff1a " + longId);
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void addPoint() throws JRealTimeException {
        logger.info((Object)"========================\u521b\u5efa\u6d4b\u70b9");
        long startTime = System.currentTimeMillis();
        ArrayList<PointInfo> pis = new ArrayList<PointInfo>();
        int i = 10;
        while (i < 100) {
            PointInfo pi = new PointInfo("LdS000" + i, "LDS000" + i, "desc", "kw", "AI", "EXT000" + i, "extdesc");
            pis.add(pi);
            ++i;
        }
        operator.createPoint("192.168.1.111", "8989", pis);
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void writePoint_more() throws InterruptedException {
        logger.info((Object)"========================\u5199\u5165\u5b9e\u65f6\u6570\u636e");
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        int i = 1;
        while (i < 2) {
            PointData pd = new PointData("WLJ00158", 88888.0, 0, 0, (short)3);
            pds.add(pd);
            ++i;
        }
        int n = 1;
        do {
            operator.writePoint("12.0.1.30", "10035", pds);
            Thread.sleep(5000L);
        } while (++n != 500);
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }

    public static void updatePoint() throws Exception {
        logger.info((Object)"========================\u5199\u5165\u5b9e\u65f6\u6570\u636e");
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        PointData pd = new PointData();
        pd.setPointId("SIS.KLDQUNIV.KLSC1198");
        pd.setUtcTime(EdnaApiHelper.parseDateStringToUTC("2014-03-01 00:00:00"));
        pd.setStatus(Short.parseShort("3"));
        pd.setValue(888888.0);
        pds.add(pd);
        int num = operator.putHistoryData("SIS.KLDQUNIV.KLSC1198", pds);
        System.out.println("\u5f71\u54cd\u884c\u6570: " + num);
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 ");
    }
}

