/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.test;

import cn.gyee.appsoft.jrt.exception.JRealTimeException;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.service.EdnaApiService;
import cn.gyee.appsoft.jrt.service.IOperatorRealTime;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class JEdnaTest {
    private static IOperatorRealTime operator;

    public static void createOperator() throws JRealTimeException {
        operator = new EdnaApiService();
    }

    public static void addPoint() throws JRealTimeException {
        ArrayList<PointInfo> pis = new ArrayList<PointInfo>();
        int i = 10;
        while (i < 100) {
            PointInfo pi = new PointInfo("LdS000" + i, "LDS000" + i, "desc", "kw", "AI", "EXT000" + i, "extdesc");
            pis.add(pi);
            ++i;
        }
        operator.createPoint("192.168.1.111", "8989", pis);
    }

    public static void getRTPointValue() throws JRealTimeException {
        PointData pd = operator.getRealTimeData("LSDEMO.UNIVSERV.LDS00010");
        if (pd != null) {
            System.out.println("UTC\u65f6\u95f4: ===" + pd.getUtcTime());
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
        }
    }

    public static void getRTallPointValue() throws JRealTimeException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("LSDEMO.UNIVSERV.LDS00010");
        list.add("LSDEMO.UNIVSERV.LDS00011");
        List<PointData> pds = operator.getRealTimeData(list);
        if (!pds.isEmpty()) {
            for (PointData pd : pds) {
                System.out.println("\u503c: ===" + pd.getValue());
            }
        }
    }

    public static void getHisRaw() throws JRealTimeException {
        List<PointData> pds = operator.getHistoryRawData("LSDEMO.UNIVSERV.LDS00010", "2013-12-25 10:25:03", "2013-12-25 10:26:03");
        for (PointData pd : pds) {
            System.out.println("UTC\u65f6\u95f4: ===" + pd.getUtcTime());
            System.out.println("\u6beb\u79d2\u65f6\u95f4: ===" + pd.getMsTime());
            System.out.println("\u503c: ===" + pd.getValue());
            System.out.println("\u72b6\u6001: ===" + pd.getStatus());
            System.out.println("=================================================");
        }
    }

    public static void getMatrixHisSnap() throws JRealTimeException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("LSDEMO.UNIVSERV.LDS00010");
        list.add("LSDEMO.UNIVSERV.LDS00011");
        List<PointData> pds = operator.getHistoryMatrixSnapData(list, "2014-03-10 11:25:25");
        if (!pds.isEmpty()) {
            for (PointData pd : pds) {
                System.out.println("\u503c: ===" + pd.getValue());
            }
        }
    }

    public static void writePoint_more() throws JRealTimeException, ParseException, InterruptedException {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        int i = 1;
        while (i < 3) {
            PointData pd = new PointData("LDS0001" + i, 88888.0, 0, 0, (short)2);
            pds.add(pd);
            ++i;
        }
        int n = 1;
        do {
            operator.writePoint("192.168.1.111", "8989", pds);
            Thread.sleep(500L);
        } while (++n != 5);
    }

    public static void main(String[] args) throws Exception {
        JEdnaTest.createOperator();
        JEdnaTest.getMatrixHisSnap();
    }
}

