/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.socket;

import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketWriteEntry {
    protected final Log logger = LogFactory.getLog(this.getClass());
    int MAX_PACKET_SIZE = 8192;
    private DatagramPacket packet;
    private ByteBuffer data = ByteBuffer.allocate(this.MAX_PACKET_SIZE);
    private boolean ackPacket = false;
    private String ip;
    private Integer port;

    static byte[] toLH(int n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return b;
    }

    static byte[] toHH(int n) {
        byte[] b = new byte[4];
        b[3] = (byte)(n & 0xFF);
        b[2] = (byte)(n >> 8 & 0xFF);
        b[1] = (byte)(n >> 16 & 0xFF);
        b[0] = (byte)(n >> 24 & 0xFF);
        return b;
    }

    static byte[] toLH(short n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return b;
    }

    static byte[] toHH(short n) {
        byte[] b = new byte[2];
        b[1] = (byte)(n & 0xFF);
        b[0] = (byte)(n >> 8 & 0xFF);
        return b;
    }

    static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return SocketWriteEntry.getBytes(intBits);
    }

    static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    static final String padRight(String str, int len) {
        char[] chars = new char[len];
        int i = 0;
        while (i < chars.length) {
            chars[i] = '\u0000';
            ++i;
        }
        char[] strChars = str.toCharArray();
        len = strChars.length < len ? strChars.length : --len;
        System.arraycopy(strChars, 0, chars, 0, len);
        return new String(chars);
    }

    public SocketWriteEntry() {
        this.packet = new DatagramPacket(this.data.array(), this.data.capacity());
    }

    public void disconnect(Socket socket) {
        try {
            try {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)("\u5173\u95ed\u8fde\u63a5\u51fa\u9519!" + e.getMessage()));
                socket = null;
            }
        }
        finally {
            socket = null;
        }
    }

    public synchronized Socket connect(String ip, Integer port) {
        Socket socket = null;
        try {
            socket = new Socket(InetAddress.getByName(ip), (int)port);
            socket.setSoTimeout(10000);
        }
        catch (IOException e) {
            this.logger.error((Object)("\u8fde\u63a5\u670d\u52a1Ip\u5931\u8d25!" + e.getMessage()));
        }
        return socket;
    }

    public void sendAndReceive(Socket socket) {
        this.packet.setLength(this.data.position());
        this.packet.setSocketAddress(socket.getRemoteSocketAddress());
        try {
            try {
                socket.getOutputStream().write(this.data.array(), 0, this.data.position());
                this.packet.setLength(this.data.capacity());
                if (this.ackPacket) {
                    socket.getInputStream().read(this.data.array());
                }
            }
            catch (IOException e) {
                this.logger.error((Object)("\u5199\u5165\u6570\u636e\u5f02\u5e38!" + e.getMessage()));
                this.disconnect(socket);
            }
        }
        finally {
            this.disconnect(socket);
        }
    }

    public synchronized int writeSinglePoint(String ip, Integer port, String point, PointData[] vals) {
        Socket socket = this.connect(ip, port);
        if (vals.length > 500) {
            this.logger.error((Object)"writeSinglePoint failed . msg : maximum 500.");
            return -103;
        }
        if (socket == null) {
            return -1;
        }
        this.data.put(new byte[]{-2, -2});
        this.data.put(SocketWriteEntry.toLH(vals.length * 16 + 12 + 61));
        this.data.put(SocketWriteEntry.toLH((short)7));
        this.data.put(SocketWriteEntry.toLH((short)vals.length));
        this.data.put(SocketWriteEntry.padRight(point, 61).getBytes());
        int i = 0;
        while (i < vals.length) {
            this.data.put(SocketWriteEntry.toLH(vals[i].getUtcTime()));
            this.data.put(SocketWriteEntry.toLH((short)0));
            this.data.put(SocketWriteEntry.toLH(vals[i].getStatus()));
            this.data.put(SocketWriteEntry.getBytes(vals[i].getValue()));
            ++i;
        }
        this.data.put(new byte[]{-17, -17});
        this.sendAndReceive(socket);
        return 0;
    }

    public synchronized int writeMultiPoint(String ip, Integer port, List<PointData> pds) {
        Socket socket = this.connect(ip, port);
        if (pds.size() > 100) {
            System.out.println("writeMultiPoint failed . msg : maximum 100.");
            return -103;
        }
        if (socket == null) {
            return -1;
        }
        this.data.clear();
        this.data.put(new byte[]{-2, -2});
        this.data.put(SocketWriteEntry.toLH(pds.size() * 77 + 12));
        this.data.put(SocketWriteEntry.toLH((short)6));
        this.data.put(SocketWriteEntry.toLH((short)pds.size()));
        for (PointData p : pds) {
            this.data.put(SocketWriteEntry.toLH(p.getUtcTime()));
            this.data.put(SocketWriteEntry.toLH((short)0));
            this.data.put(SocketWriteEntry.padRight(p.getPointId(), 61).getBytes());
            this.data.put(SocketWriteEntry.toLH(p.getStatus()));
            this.data.put(SocketWriteEntry.getBytes(p.getValue()));
        }
        this.data.put(new byte[]{-17, -17});
        this.sendAndReceive(socket);
        return 0;
    }

    public synchronized int deleteConfigRec(String ip, Integer port, String shortid) throws IOException {
        Socket socket = this.connect(ip, port);
        if (socket == null) {
            return -1;
        }
        this.data.clear();
        this.data.put(new byte[]{-2, -2});
        this.data.put(SocketWriteEntry.toLH(73));
        this.data.put(SocketWriteEntry.toLH((short)14));
        this.data.put(SocketWriteEntry.toLH((short)1));
        this.data.put(SocketWriteEntry.padRight(shortid.toUpperCase(), 61).getBytes());
        this.data.put(new byte[]{-17, -17});
        this.sendAndReceive(socket);
        return 0;
    }

    public synchronized int SendConfigRec(String ip, Integer port, List<PointInfo> pis) {
        Socket socket = this.connect(ip, port);
        if (socket == null) {
            return -1;
        }
        for (PointInfo p : pis) {
            this.data.clear();
            this.data.put(new byte[]{-2, -2});
            this.data.put(SocketWriteEntry.toLH(619));
            this.data.put(SocketWriteEntry.toLH((short)5));
            this.data.put(SocketWriteEntry.toLH((short)1));
            this.data.put(SocketWriteEntry.padRight(p.getPointId(), 9).getBytes());
            this.data.put(SocketWriteEntry.padRight(p.getLongId(), 61).getBytes());
            this.data.put(SocketWriteEntry.padRight(p.getDesc(), 25).getBytes());
            this.data.put(SocketWriteEntry.padRight(p.getUnits(), 9).getBytes());
            this.data.put(SocketWriteEntry.padRight(p.getPointType(), 3).getBytes());
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.padRight("", 17).getBytes());
            this.data.put(SocketWriteEntry.padRight("", 17).getBytes());
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.getBytes(0.0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.getBytes(0.0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.getBytes(0.0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.getBytes(0.0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.getBytes(0.0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.getBytes(0.0));
            this.data.put(SocketWriteEntry.toLH(1));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.toLH(0));
            this.data.put(SocketWriteEntry.toLH(9999));
            this.data.put(SocketWriteEntry.getBytes(p.getHistoryDeadBand()));
            this.data.put(SocketWriteEntry.toLH(1));
            this.data.put(SocketWriteEntry.padRight(p.getLongId(), 129).getBytes());
            this.data.put(SocketWriteEntry.padRight(p.getDesc(), 225).getBytes());
            this.data.put(new byte[]{-17, -17});
            this.sendAndReceive(socket);
        }
        return 0;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean isAckPacket() {
        return this.ackPacket;
    }

    public void setAckPacket(boolean ackPacket) {
        this.ackPacket = ackPacket;
    }
}

