/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.socket;

import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.socket.Crc16;
import cn.gyee.appsoft.jrt.socket.RealTimeServiceInfo;
import cn.gyee.appsoft.jrt.socket.ServiceInfo;
import cn.gyee.appsoft.jrt.socket.SocketEdnaHelper;
import cn.gyee.appsoft.jrt.socket.SocketEntry1;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketEntry {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int MAX_PACKET_SIZE = 8192;
    private DatagramPacket packet;
    private ByteBuffer _data;
    private Crc16 crc;
    private Map<String, RealTimeServiceInfo> servMap;
    private Map<String, String> _shortidToLongidMaps;
    private Map<String, String> _longidToShortidTagMaps;
    private boolean isConnected = false;
    private String ipAddress;
    private Integer port;
    public static int HIST_AVG = 1;
    public static int HIST_SNAP = 2;
    public static int HIST_MIN = 3;
    public static int HIST_MAX = 4;

    public SocketEntry(String ipAddress, Integer port) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.servMap = new HashMap<String, RealTimeServiceInfo>();
        this._longidToShortidTagMaps = new HashMap<String, String>();
        this._shortidToLongidMaps = new HashMap<String, String>();
        this._data = ByteBuffer.allocate(this.MAX_PACKET_SIZE);
        this.packet = new DatagramPacket(this._data.array(), this._data.capacity());
        this.crc = new Crc16();
    }

    private synchronized DatagramSocket connect(String ipAddress, Integer port) {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.connect(InetAddress.getByName(ipAddress), port);
            this.isConnected = true;
        }
        catch (SocketException se) {
            this.logger.error((Object)("\u8fde\u63a5Edna\u76ee\u5f55\u670d\u52a1\u5931\u8d25!" + se.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u8fde\u63a5Edna\u76ee\u5f55\u670d\u52a1\u5931\u8d25!" + ue.getMessage()));
        }
        return socket;
    }

    public void disconnect(DatagramSocket socket) {
        if (socket != null) {
            socket.close();
            this.isConnected = false;
        } else {
            socket = null;
        }
    }

    public void sendAndReceive(DatagramSocket socket) {
        int crc16 = this.crc.getCrc16(this._data.array(), this._data.position());
        this._data.put(SocketEdnaHelper.toLH(crc16), 0, 2);
        this.packet.setLength(this._data.position());
        this.packet.setSocketAddress(socket.getRemoteSocketAddress());
        try {
            socket.send(this.packet);
            this.packet.setLength(this._data.capacity());
            socket.receive(this.packet);
        }
        catch (IOException e) {
            this.logger.error((Object)("IO\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    private ServiceInfo loadServiceInfo(String siteName, String serviceName) {
        ServiceInfo info = null;
        DatagramSocket socket = this.connect(this.getIpAddress(), this.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)512));
        this._data.put(SocketEdnaHelper.toLH((short)1));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.padRight(siteName, 8).getBytes());
        this._data.put(SocketEdnaHelper.padRight(serviceName, 8).getBytes());
        int i = 0;
        while (i < 47) {
            this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
            this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
            ++i;
        }
        this.sendAndReceive(socket);
        this.disconnect(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        if (ret == 0) {
            String ipAddress = String.format("%d.%d.%d.%d", data[44] & 0xFF, data[45] & 0xFF, data[46] & 0xFF, data[47] & 0xFF);
            Integer port = Integer.valueOf(String.format("%x%x", data[42], data[43]), 16);
            if (!ipAddress.equals("0.0.0.0") && port != 0) {
                info = new ServiceInfo(ipAddress, port, serviceName);
            } else {
                this.logger.info((Object)("Service : " + serviceName + " not running. "));
            }
        }
        return info;
    }

    private String findHistoryName(ServiceInfo realTime) {
        String name = null;
        DatagramSocket socket = this.connect(realTime.getIpAddress(), realTime.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)7));
        this._data.put(SocketEdnaHelper.toLH((short)1));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this.sendAndReceive(socket);
        this.disconnect(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        try {
            if (ret == 0) {
                name = new String(data, 224, 64, "gb2312").replace('\u0000', ' ').trim();
            }
        }
        catch (UnsupportedEncodingException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        return name;
    }

    private String findCmcfgName(ServiceInfo realTime) {
        String name = null;
        DatagramSocket socket = this.connect(realTime.getIpAddress(), realTime.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)7));
        this._data.put(SocketEdnaHelper.toLH((short)1));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this.sendAndReceive(socket);
        this.disconnect(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        try {
            if (ret == 0) {
                name = new String(data, 296, 64, "gb2312").replace('\u0000', ' ').trim();
            }
        }
        catch (UnsupportedEncodingException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        return name;
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    private RealTimeServiceInfo findRealTimeServiceInfoByName(String fullPointName) {
        String[] info = fullPointName.split("\\.");
        if (info.length == 3) {
            info[0] = info[0].trim();
            info[1] = info[1].trim();
            info[2] = info[2].trim();
            if (info[0].length() > 8 || info[1].length() > 8 || info[2].length() > 8) {
                this.logger.error((Object)"\u9519\u8bef\u7684\u670d\u52a1\u540d\u79f0\u7684\u957f\u5ea6\uff0c\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e9!");
                return null;
            }
            String serviceName = (String.valueOf(info[0]) + "." + info[1]).toLowerCase();
            System.out.println("\u662f\u5426\u5305\u542b: " + this.servMap.containsKey(serviceName));
            if (!this.servMap.containsKey(serviceName)) {
                RealTimeServiceInfo result = this.loadRealtimeServiceInfo(info[0], info[1]);
                if (result != null) {
                    if (!this.servMap.containsKey(serviceName)) {
                        this.servMap.put(serviceName, result);
                    }
                } else {
                    System.out.println("\u8c03\u7528loadRealtimeServiceInfo\u65b9\u6cd5\uff1aresult is null");
                    return null;
                }
            }
            return this.servMap.get(serviceName);
        }
        System.out.println("\u51fa\u9519\u4e86!!");
        return null;
    }

    private synchronized RealTimeServiceInfo loadRealtimeServiceInfo(String siteName, String serviceName) {
        RealTimeServiceInfo info = null;
        ServiceInfo realTime = this.loadServiceInfo(siteName, serviceName);
        if (realTime != null) {
            String historyName = this.findHistoryName(realTime);
            String cmcfgName = this.findCmcfgName(realTime);
            if (historyName != null && !historyName.equals("") && cmcfgName != null && !cmcfgName.equals("")) {
                String[] detail = historyName.split("\\.");
                ServiceInfo history = this.loadServiceInfo(detail[0], detail[1]);
                detail = cmcfgName.split("\\.");
                ServiceInfo cmcfg = this.loadServiceInfo(detail[0], detail[1]);
                if (history != null) {
                    info = new RealTimeServiceInfo(realTime, history, cmcfg);
                }
            }
        }
        return info;
    }

    private synchronized String switchToShortid(RealTimeServiceInfo info, String fullPointName) {
        String key = fullPointName.toLowerCase();
        if (this._shortidToLongidMaps.containsKey(key)) {
            return this._shortidToLongidMaps.get(key);
        }
        if (info == null) {
            return fullPointName;
        }
        String[] detail = fullPointName.split("\\.");
        if (detail.length == 3 && detail[2].length() < 9) {
            return fullPointName;
        }
        StringBuilder longid = new StringBuilder(100);
        int i = 2;
        while (i < detail.length) {
            if (i == 2) {
                longid.append(detail[i]);
            } else {
                longid.append("." + detail[i]);
            }
            ++i;
        }
        ServiceInfo cmcfg = info.getCmcfgServ();
        DatagramSocket socket = null;
        socket = this.connect(cmcfg.getIpAddress(), cmcfg.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)1000));
        this._data.put(SocketEdnaHelper.toLH((short)1));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put("C7".getBytes());
        this._data.put(SocketEdnaHelper.padSpaceRight(longid.toString().toUpperCase(), 60).getBytes());
        this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
        this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
        this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
        this._data.put(SocketEdnaHelper.padRight("", 10).getBytes());
        this._data.put(SocketEdnaHelper.padRight("", 4).getBytes());
        this.sendAndReceive(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        if (ret == 0) {
            short count = SocketEdnaHelper.toHHShort(data, 2);
            byte[] keys = new byte[35];
            System.arraycopy(data, 96, keys, 0, 10);
            keys[10] = 0;
            if (count > 0) {
                this._data.clear();
                this._data.put(SocketEdnaHelper.toLH((short)1001));
                this._data.put(SocketEdnaHelper.toLH((short)1));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(keys);
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.padRight("", 4).getBytes());
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this.sendAndReceive(socket);
                data = this._data.array();
                ret = SocketEdnaHelper.toHHShort(data, 4);
                try {
                    if (ret == 0) {
                        String shortid = String.valueOf(detail[0]) + "." + detail[1] + "." + new String(data, 133, 8, "gb2312").replace('\u0000', ' ').trim();
                        this._shortidToLongidMaps.put(key, shortid);
                        return shortid;
                    }
                }
                catch (UnsupportedEncodingException ue) {
                    this.disconnect(socket);
                    this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
                }
            }
        }
        this.disconnect(socket);
        return fullPointName;
    }

    private synchronized String switchToLongid(RealTimeServiceInfo info, String fullPointName) {
        String key = fullPointName.toLowerCase();
        if (this._longidToShortidTagMaps.containsKey(key)) {
            return this._longidToShortidTagMaps.get(key);
        }
        if (info == null) {
            return fullPointName;
        }
        String[] detail = fullPointName.split("\\.");
        if (detail.length == 3 && detail[2].length() > 8) {
            return fullPointName;
        }
        StringBuilder shortid = new StringBuilder(100);
        int i = 2;
        while (i < detail.length) {
            if (i == 2) {
                shortid.append(detail[i]);
            } else {
                shortid.append("." + detail[i]);
            }
            ++i;
        }
        ServiceInfo cmcfg = info.getCmcfgServ();
        DatagramSocket socket = null;
        socket = this.connect(cmcfg.getIpAddress(), cmcfg.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)1000));
        this._data.put(SocketEdnaHelper.toLH((short)1));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put("C4".getBytes());
        this._data.put(SocketEdnaHelper.padSpaceRight(detail[0], 8).getBytes());
        this._data.put(SocketEdnaHelper.padSpaceRight(detail[1], 8).getBytes());
        this._data.put(SocketEdnaHelper.padSpaceRight(shortid.toString().toUpperCase(), 8).getBytes());
        this._data.put(SocketEdnaHelper.padSpaceRight("", 4).getBytes());
        this._data.put(SocketEdnaHelper.padSpaceRight("", 8).getBytes());
        this._data.put((byte)1);
        this._data.put(SocketEdnaHelper.padSpaceRight("", 10).getBytes());
        this.sendAndReceive(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        if (ret == 0) {
            short count = SocketEdnaHelper.toHHShort(data, 2);
            byte[] keys = new byte[35];
            System.arraycopy(data, 49, keys, 0, 10);
            keys[10] = 0;
            if (count > 0) {
                this._data.clear();
                this._data.put(SocketEdnaHelper.toLH((short)1001));
                this._data.put(SocketEdnaHelper.toLH((short)1));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(keys);
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.padRight("", 4).getBytes());
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this.sendAndReceive(socket);
                data = this._data.array();
                ret = SocketEdnaHelper.toHHShort(data, 4);
                try {
                    if (ret == 0) {
                        String longid = String.valueOf(detail[0]) + "." + detail[1] + "." + new String(data, 141, 60, "gb2312").replace('\u0000', ' ').trim();
                        this._longidToShortidTagMaps.put(key, longid);
                        return longid;
                    }
                }
                catch (UnsupportedEncodingException ue) {
                    this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
                }
            }
        }
        this.disconnect(socket);
        return fullPointName;
    }

    private PointData getRealtimeTagValue(ServiceInfo info, String fullPointName) {
        PointData pd = null;
        DatagramSocket socket = null;
        socket = this.connect(info.getIpAddress(), info.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)3));
        this._data.put(SocketEdnaHelper.toLH((short)1));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.padRight(fullPointName.split("\\.")[2].trim(), 8).getBytes());
        int i = 0;
        while (i < 31) {
            this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
            ++i;
        }
        this.sendAndReceive(socket);
        this.disconnect(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        try {
            String value;
            if (ret == 0 && !(value = new String(data, 48, 16, "gb2312").replace('\u0000', ' ').trim()).equals("")) {
                pd = new PointData();
                pd.setPointId(fullPointName);
                pd.setValue(Double.parseDouble(value));
                pd.setUtcTime(SocketEdnaHelper.toHHInt(data, 12));
                pd.setStatus(SocketEdnaHelper.toHHShort(data, 10));
            }
        }
        catch (UnsupportedEncodingException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        return pd;
    }

    private Map<String, PointData> getRealtimeTagValues(ServiceInfo info, List<String> fullPointNames, Map<String, String> maps) {
        PointData pd = null;
        HashMap<String, PointData> result = new HashMap<String, PointData>();
        DatagramSocket socket = null;
        try {
            socket = this.connect(info.getIpAddress(), info.getPort());
            socket.setSoTimeout(500);
            int size = fullPointNames.size();
            int maxPointsPerCall = 32;
            int loops = size % maxPointsPerCall == 0 ? size / maxPointsPerCall : size / maxPointsPerCall + 1;
            int index = 0;
            do {
                int remains = size - index * maxPointsPerCall;
                int start = index * maxPointsPerCall;
                int count = remains >= maxPointsPerCall ? maxPointsPerCall : remains;
                int end = start + count;
                this._data.clear();
                this._data.put(SocketEdnaHelper.toLH((short)3));
                this._data.put(SocketEdnaHelper.toLH((short)count));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                while (start < end) {
                    this._data.put(SocketEdnaHelper.padRight(fullPointNames.get(start), 8).getBytes());
                    ++start;
                }
                this.sendAndReceive(socket);
                byte[] data = this._data.array();
                short ret = SocketEdnaHelper.toHHShort(data, 4);
                int retCount = SocketEdnaHelper.toHHShort(data, 2);
                if (ret == 0) {
                    int i = 0;
                    while (i < retCount) {
                        String value;
                        String shortID = new String(data, 8 + 64 * i + 8, 8, "gb2312").replace('\u0000', ' ').trim().toLowerCase();
                        if (maps.containsKey(shortID) && !(value = new String(data, 8 + 64 * i + 40, 16, "gb2312").replace('\u0000', ' ').trim()).equals("")) {
                            pd = new PointData();
                            pd.setValue(Double.parseDouble(value));
                            pd.setUtcTime(SocketEdnaHelper.toHHInt(data, 8 + i * 64 + 4));
                            pd.setStatus(SocketEdnaHelper.toHHShort(data, 8 + i * 64 + 2));
                            pd.setPointId(shortID);
                            result.put(maps.get(shortID), pd);
                        }
                        ++i;
                    }
                }
                ++index;
            } while (--loops > 0);
        }
        catch (SocketException e) {
            this.logger.error((Object)("sokect\u5f02\u5e38!" + e.getMessage()));
        }
        catch (UnsupportedEncodingException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        this.disconnect(socket);
        return result;
    }

    public synchronized PointData getRealtimeTagValue(String fullPointName) {
        RealTimeServiceInfo servInfo = this.findRealTimeServiceInfoByName(fullPointName);
        if (servInfo != null) {
            return this.getRealtimeTagValue(servInfo.getRtServ(), this.switchToShortid(servInfo, fullPointName));
        }
        System.out.println("servInfo is null");
        return null;
    }

    public Map<String, PointData> getRealtimeTagValuesMap(String ... fullPointNames) {
        RealTimeServiceInfo info;
        HashMap group = new HashMap();
        HashMap<String, String> maps = new HashMap<String, String>();
        int i = 0;
        while (i < fullPointNames.length) {
            fullPointNames[i] = fullPointNames[i].toLowerCase();
            info = this.findRealTimeServiceInfoByName(fullPointNames[i]);
            if (info != null) {
                String service = fullPointNames[i].split("\\.")[1];
                if (!group.containsKey(service)) {
                    group.put(service, new ArrayList());
                }
                String shortid = this.switchToShortid(info, fullPointNames[i]).split("\\.")[2].toLowerCase();
                maps.put(shortid, fullPointNames[i]);
                ((List)group.get(service)).add(shortid);
            }
            ++i;
        }
        HashMap<String, PointData> result = new HashMap<String, PointData>();
        for (Map.Entry setEntry : group.entrySet()) {
            info = this.findRealTimeServiceInfoByName((String)maps.get(((List)setEntry.getValue()).get(0)));
            result.putAll(this.getRealtimeTagValues(info.getRtServ(), (List)setEntry.getValue(), maps));
        }
        return result;
    }

    public List<PointData> getRealtimeTagValuesList(String ... fullPointNames) {
        Map<String, PointData> map = this.getRealtimeTagValuesMap(fullPointNames);
        ArrayList<PointData> result = new ArrayList<PointData>();
        for (Map.Entry<String, PointData> setEntry : map.entrySet()) {
            result.add(setEntry.getValue());
        }
        return result;
    }

    public List<PointData> queryHistoryValue(ServiceInfo info, String fullPointName, int tStart, int tEnd, int period, int type) {
        ArrayList<PointData> result = new ArrayList<PointData>();
        DatagramSocket socket = null;
        socket = this.connect(info.getIpAddress(), info.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)550));
        this._data.put(SocketEdnaHelper.toLH((short)160));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        String[] names = fullPointName.split("\\.");
        this._data.put(SocketEdnaHelper.padRight(names[0].trim(), 8).getBytes());
        this._data.put(SocketEdnaHelper.padRight(names[1].trim(), 8).getBytes());
        this._data.put(SocketEdnaHelper.padRight(names[2].trim(), 8).getBytes());
        this._data.put((byte)0);
        this._data.put((byte)type);
        if (type != SocketEntry1.HIST_SNAP) {
            this._data.put(SocketEdnaHelper.toLH(tStart));
            this._data.put(SocketEdnaHelper.toLH(tEnd));
        } else {
            this._data.put(SocketEdnaHelper.toLH(tStart - period));
            this._data.put(SocketEdnaHelper.toLH(tEnd + period));
        }
        this._data.put(SocketEdnaHelper.toLH(period));
        this.sendAndReceive(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        int offset = 15;
        if (ret == 0) {
            int tTime = 0;
            PointData pd = null;
            int length = SocketEdnaHelper.toHHShort(data, 2);
            int i = 0;
            while (i < length) {
                tTime = SocketEdnaHelper.toHHInt(data, offset + i * 24);
                pd = new PointData();
                pd.setPointId(fullPointName);
                try {
                    pd.setValue(Double.parseDouble(new String(data, offset + i * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim()));
                }
                catch (NumberFormatException e) {
                    this.logger.error((Object)("\u67e5\u8be2\u5386\u53f2\u503c\uff0c\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38!" + e.getMessage()));
                }
                catch (UnsupportedEncodingException ue) {
                    this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
                }
                pd.setStatus(SocketEdnaHelper.toHHShort(data, offset + i * 24 + 4));
                pd.setUtcTime(SocketEdnaHelper.toHHInt(data, offset + i * 24));
                if (tTime >= tStart && tTime <= tEnd) {
                    result.add(pd);
                }
                ++i;
            }
            boolean bDone = data[14] == 1;
            byte[] nBi = new byte[7];
            while (!bDone) {
                System.arraycopy(data, 8, nBi, 0, 7);
                this._data.clear();
                this._data.put(SocketEdnaHelper.toLH((short)552));
                this._data.put(SocketEdnaHelper.toLH((short)160));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(nBi);
                this.sendAndReceive(socket);
                data = this._data.array();
                ret = SocketEdnaHelper.toHHShort(data, 4);
                offset = 15;
                if (ret != 0) break;
                tTime = 0;
                length = SocketEdnaHelper.toHHShort(data, 2);
                int i2 = 0;
                while (i2 < length) {
                    tTime = SocketEdnaHelper.toHHInt(data, offset + i2 * 24);
                    pd = new PointData();
                    pd.setPointId(fullPointName);
                    try {
                        pd.setValue(Double.parseDouble(new String(data, offset + i2 * 24 + 6, 16, "gb2312").replace('\u0000', ' ').trim()));
                    }
                    catch (NumberFormatException e) {
                        this.logger.error((Object)("\u67e5\u8be2\u5386\u53f2\u503c\uff0c\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38!" + e.getMessage()));
                    }
                    catch (UnsupportedEncodingException ue) {
                        this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
                    }
                    pd.setStatus(SocketEdnaHelper.toHHShort(data, offset + i2 * 24 + 4));
                    pd.setUtcTime(SocketEdnaHelper.toHHInt(data, offset + i2 * 24));
                    if (tTime >= tStart && tTime <= tEnd) {
                        result.add(pd);
                    }
                    ++i2;
                }
                boolean bl = bDone = data[14] == 1;
            }
        }
        this.disconnect(socket);
        return result;
    }

    public List<PointData> getHistoryMatrixValues(int utcStart, int utcEnd, int type, List<String> fullPointNames) {
        List<PointData> result = new ArrayList<PointData>();
        RealTimeServiceInfo info = null;
        for (String name : fullPointNames) {
            info = this.findRealTimeServiceInfoByName(name.toLowerCase().trim());
            if (info == null) continue;
            result = this.queryHistoryValue(info.getHistServ(), name.toLowerCase().trim(), utcStart, utcEnd, utcEnd - utcStart + 1, type);
        }
        return result;
    }

    public int deletePointRec(String fullPointName, int tStart, int tEnd) {
        RealTimeServiceInfo servInfo = this.findRealTimeServiceInfoByName(fullPointName);
        if (servInfo != null) {
            DatagramSocket socket = null;
            socket = this.connect(servInfo.getHistServ().getIpAddress(), servInfo.getHistServ().getPort());
            this._data.clear();
            this._data.put(SocketEdnaHelper.toLH((short)593));
            this._data.put(SocketEdnaHelper.toLH((short)1));
            this._data.put(SocketEdnaHelper.toLH((short)0));
            this._data.put(SocketEdnaHelper.toLH((short)0));
            String[] details = fullPointName.split("\\.");
            if (details.length != 3) {
                this.logger.error((Object)(String.valueOf(fullPointName) + " deletePointRec failed . msg : not a correct format."));
                return -102;
            }
            this._data.put(SocketEdnaHelper.padRight(details[0], 8).getBytes());
            this._data.put(SocketEdnaHelper.padRight(details[1], 8).getBytes());
            this._data.put(SocketEdnaHelper.padRight(details[2], 8).getBytes());
            int i = 0;
            while (i < 39) {
                this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
                this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
                this._data.put(SocketEdnaHelper.padRight("", 8).getBytes());
                ++i;
            }
            this._data.put(SocketEdnaHelper.toLH(tStart));
            i = 0;
            while (i < 39) {
                this._data.put(SocketEdnaHelper.toLH(0));
                ++i;
            }
            this._data.put(SocketEdnaHelper.toLH(tEnd));
            i = 0;
            while (i < 39) {
                this._data.put(SocketEdnaHelper.toLH(0));
                ++i;
            }
            this._data.put(SocketEdnaHelper.toLH(1));
            this.sendAndReceive(socket);
            this.disconnect(socket);
            byte[] data = this._data.array();
            short ret = SocketEdnaHelper.toHHShort(data, 4);
            if (ret == 0) {
                return SocketEdnaHelper.toHHInt(data, 968);
            }
            return ret;
        }
        this.logger.error((Object)(String.valueOf(fullPointName) + " findRealTimeServiceInfoByName failed."));
        return -100;
    }

    public int deletePointRec(String fullPointName, String startTime, String endTime) throws ParseException {
        return this.deletePointRec(fullPointName, EdnaApiHelper.parseDateStringToUTC(startTime), EdnaApiHelper.parseDateStringToUTC(endTime));
    }

    public int[] deletePointsRecs(String[] points, int[] tStart, int[] tEnd) {
        int[] result = new int[points.length];
        int i = 0;
        while (i < points.length) {
            result[i] = this.deletePointRec(points[i], tStart[i], tEnd[i]);
            ++i;
        }
        return result;
    }

    public List<PointData> getHistoryMatrixValues(String startTime, String endTime, int type, List<String> fullPointNames) {
        ArrayList<PointData> result = new ArrayList<PointData>();
        try {
            int utcStart = EdnaApiHelper.parseDateStringToUTC(startTime);
            int utcEnd = EdnaApiHelper.parseDateStringToUTC(endTime);
            return this.getHistoryMatrixValues(utcStart, utcEnd, type, fullPointNames);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return result;
        }
    }

    public List<PointData> getHistoryTagValues(String fullPointName, String startTime, String endTime, int period, int type) {
        List<PointData> result = new ArrayList<PointData>();
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(fullPointName = fullPointName.toLowerCase());
        if (info != null) {
            try {
                result = this.queryHistoryValue(info.getHistServ(), fullPointName, EdnaApiHelper.parseDateStringToUTC(startTime), EdnaApiHelper.parseDateStringToUTC(endTime), period, type);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int updateVals(String point, PointData ... vals) {
        if (vals.length > 160) {
            this.logger.error((Object)(String.valueOf(point) + " updateVals failed . msg : maximum 160."));
            return -103;
        }
        RealTimeServiceInfo servInfo = this.findRealTimeServiceInfoByName(point);
        if (servInfo != null) {
            DatagramSocket socket = null;
            socket = this.connect(servInfo.getHistServ().getIpAddress(), servInfo.getHistServ().getPort());
            this._data.clear();
            this._data.put(SocketEdnaHelper.toLH((short)574));
            this._data.put(SocketEdnaHelper.toLH((short)vals.length));
            this._data.put(SocketEdnaHelper.toLH((short)0));
            this._data.put(SocketEdnaHelper.toLH((short)0));
            String[] details = point.split("\\.");
            if (details.length != 3) {
                this.logger.error((Object)(String.valueOf(point) + " updateVals failed . msg : not a correct format."));
                return -102;
            }
            this._data.put(SocketEdnaHelper.padRight(details[0], 8).getBytes());
            this._data.put(SocketEdnaHelper.padRight(details[1], 8).getBytes());
            this._data.put(SocketEdnaHelper.padRight(details[2], 8).getBytes());
            this._data.put((byte)4);
            int i = 0;
            while (i < vals.length) {
                this._data.put(SocketEdnaHelper.toLH(vals[i].getUtcTime()));
                this._data.put(SocketEdnaHelper.toLH(vals[i].getStatus()));
                this._data.put(SocketEdnaHelper.padRight("" + vals[i].getValue(), 16).getBytes());
                this._data.put(new byte[2]);
                ++i;
            }
            this.sendAndReceive(socket);
            this.disconnect(socket);
            byte[] data = this._data.array();
            short ret = SocketEdnaHelper.toHHShort(data, 4);
            return ret;
        }
        this.logger.error((Object)(String.valueOf(point) + " findRealTimeServiceInfoByName failed."));
        return -100;
    }

    public synchronized List<String> getRTServs() {
        ArrayList<String> result = new ArrayList<String>();
        DatagramSocket socket = this.connect(this.getIpAddress(), this.getPort());
        this._data.clear();
        this._data.put(SocketEdnaHelper.toLH((short)519));
        this._data.put(SocketEdnaHelper.toLH((short)40));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.toLH((short)0));
        this._data.put(SocketEdnaHelper.padRight("SSERVER", 8).getBytes());
        this.sendAndReceive(socket);
        this.disconnect(socket);
        byte[] data = this._data.array();
        short ret = SocketEdnaHelper.toHHShort(data, 4);
        if (ret == 0) {
            int count = SocketEdnaHelper.toHHShort(data, 2);
            int i = 0;
            while (i <= count) {
                try {
                    String serv = new String(data, 18 + 74 * i + 8, 8, "gb2312").replace('\u0000', ' ').trim();
                    if (!result.contains(serv) && !serv.equals("")) {
                        result.add(serv);
                    }
                }
                catch (UnsupportedEncodingException ue) {
                    this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized List<PointData> getServAllPoints(String serv) {
        block11: {
            result = new ArrayList<PointData>();
            tagName = String.valueOf(serv) + ".a";
            socket = null;
            servInfo = this.findRealTimeServiceInfoByName(tagName);
            if (servInfo == null) break block11;
            socket = this.connect(servInfo.getRtServ().getIpAddress(), servInfo.getRtServ().getPort());
            this._data.clear();
            this._data.put(SocketEdnaHelper.toLH((short)1));
            this._data.put(SocketEdnaHelper.toLH((short)32));
            this._data.put(SocketEdnaHelper.toLH((short)0));
            this._data.put(SocketEdnaHelper.toLH((short)0));
            tStart = 0;
            i = 0;
            while (i < 32) {
                this._data.put(SocketEdnaHelper.toLH(tStart));
                tStart = (short)(tStart + 1);
                ++i;
            }
            this.sendAndReceive(socket);
            data = this._data.array();
            ret = SocketEdnaHelper.toHHShort(data, 4);
            if (ret != 0) break block11;
            count = SocketEdnaHelper.toHHShort(data, 2);
            name = "";
            try {
                i = 0;
                while (i < count) {
                    sVal = new String(data, 8 + i * 64 + 40, 16, "gb2312").replace('\u0000', ' ').trim();
                    pd = new PointData();
                    pd.setPointId(new String(data, 8 + i * 64 + 8, 8, "gb2312").replace('\u0000', ' ').trim());
                    if (!sVal.equals("")) {
                        pd.setValue(Double.parseDouble(sVal));
                        pd.setUtcTime(SocketEdnaHelper.toHHInt(data, 8 + i * 64 + 4));
                        pd.setStatus(SocketEdnaHelper.toHHShort(data, 8 + i * 64 + 2));
                        result.add(pd);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + e.getMessage()));
            }
            if (!name.equals("")) ** GOTO lbl91
            return result;
lbl-1000:
            // 1 sources

            {
                this._data.clear();
                this._data.put(SocketEdnaHelper.toLH((short)1));
                this._data.put(SocketEdnaHelper.toLH((short)32));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                i = 0;
                while (i < 32) {
                    this._data.put(SocketEdnaHelper.toLH(tStart));
                    tStart = (short)(tStart + 1);
                    ++i;
                }
                this.sendAndReceive(socket);
                data = this._data.array();
                ret = SocketEdnaHelper.toHHShort(data, 4);
                if (ret != 0) continue;
                count = SocketEdnaHelper.toHHShort(data, 2);
                name = "";
                try {
                    i = 0;
                    while (i < count) {
                        sVal = new String(data, 8 + i * 64 + 40, 16, "gb2312").replace('\u0000', ' ').trim();
                        pd = new PointData();
                        pd.setPointId(new String(data, 8 + i * 64 + 8, 8, "gb2312").replace('\u0000', ' ').trim());
                        if (!sVal.equals("")) {
                            pd.setValue(Double.parseDouble(sVal));
                            pd.setUtcTime(SocketEdnaHelper.toHHInt(data, 8 + i * 64 + 4));
                            pd.setStatus(SocketEdnaHelper.toHHShort(data, 8 + i * 64 + 2));
                            result.add(pd);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + e.getMessage()));
                }
                if (name.equals("")) break;
lbl91:
                // 3 sources

                ** while (count == 32 && ret == 0)
            }
        }
        return result;
    }

    public synchronized PointInfo readPointConfig(String fullPointName) {
        PointInfo pi = null;
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(fullPointName);
        if (info != null) {
            String[] detail = (fullPointName = this.switchToShortid(info, fullPointName)).split("\\.");
            if (detail.length == 3 && detail[2].length() > 8) {
                return null;
            }
            StringBuilder shortid = new StringBuilder(100);
            int i = 2;
            while (i < detail.length) {
                if (i == 2) {
                    shortid.append(detail[i]);
                } else {
                    shortid.append("." + detail[i]);
                }
                ++i;
            }
            ServiceInfo cmcfg = info.getCmcfgServ();
            DatagramSocket socket = null;
            try {
                socket = this.connect(cmcfg.getIpAddress(), cmcfg.getPort());
                this._data.clear();
                this._data.put(SocketEdnaHelper.toLH((short)1000));
                this._data.put(SocketEdnaHelper.toLH((short)1));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put(SocketEdnaHelper.toLH((short)0));
                this._data.put("C4".getBytes());
                this._data.put(SocketEdnaHelper.padSpaceRight(detail[0], 8).getBytes());
                this._data.put(SocketEdnaHelper.padSpaceRight(detail[1], 8).getBytes());
                this._data.put(SocketEdnaHelper.padSpaceRight(shortid.toString().toUpperCase(), 8).getBytes());
                this._data.put(SocketEdnaHelper.padSpaceRight("", 4).getBytes());
                this._data.put(SocketEdnaHelper.padSpaceRight("", 8).getBytes());
                this._data.put((byte)1);
                this._data.put(SocketEdnaHelper.padSpaceRight("", 10).getBytes());
                this.sendAndReceive(socket);
                byte[] data = this._data.array();
                short ret = SocketEdnaHelper.toHHShort(data, 4);
                if (ret == 0) {
                    short count = SocketEdnaHelper.toHHShort(data, 2);
                    byte[] keys = new byte[35];
                    System.arraycopy(data, 49, keys, 0, 10);
                    keys[10] = 0;
                    if (count > 0) {
                        this._data.clear();
                        this._data.put(SocketEdnaHelper.toLH((short)1001));
                        this._data.put(SocketEdnaHelper.toLH((short)1));
                        this._data.put(SocketEdnaHelper.toLH((short)0));
                        this._data.put(SocketEdnaHelper.toLH((short)0));
                        this._data.put(keys);
                        this._data.put(SocketEdnaHelper.toLH((short)0));
                        this._data.put(SocketEdnaHelper.padRight("", 4).getBytes());
                        this._data.put(SocketEdnaHelper.toLH((short)0));
                        this.sendAndReceive(socket);
                        data = this._data.array();
                        ret = SocketEdnaHelper.toHHShort(data, 4);
                        if (ret == 0) {
                            String longid = new String(data, 141, 60, "gb2312").replace('\u0000', ' ').trim();
                            String shortID = new String(data, 133, 8, "gb2312").replace('\u0000', ' ').trim();
                            pi = new PointInfo();
                            pi.setPointId(shortID);
                            pi.setLongId(longid);
                            pi.setPointType(new String(data, 209, 2, "gb2312").replace('\u0000', ' ').trim());
                            pi.setDesc(new String(data, 211, 24, "gb2312").replace('\u0000', ' ').trim());
                            pi.setUnits(new String(data, 235, 8, "gb2312").replace('\u0000', ' ').trim());
                        }
                    }
                }
            }
            catch (UnsupportedEncodingException ue) {
                this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
            }
        }
        return pi;
    }

    public synchronized String longidFromShortid(String fullPointName) {
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(fullPointName);
        if (info != null) {
            fullPointName = this.switchToLongid(info, fullPointName);
            return fullPointName;
        }
        return null;
    }

    public synchronized String shortidFromLongid(String fullPointName) {
        RealTimeServiceInfo info = this.findRealTimeServiceInfoByName(fullPointName);
        if (info != null) {
            fullPointName = this.switchToShortid(info, fullPointName);
            return fullPointName;
        }
        return null;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

