/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.service;

import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.service.IOperatorRealTime;
import cn.gyee.appsoft.jrt.socket.SocketEntry;
import cn.gyee.appsoft.jrt.socket.SocketWriteEntry;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EdnaSocketApiService1
implements IOperatorRealTime {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SocketEntry socketEntry;
    private SocketWriteEntry socketWriteEntry;

    @Override
    public void addPointMemory(String fullPointName, int refInterval) {
    }

    @Override
    public PointData getRealTimeData(String fullPointName) {
        return this.socketEntry.getRealtimeTagValue(fullPointName);
    }

    @Override
    public List<PointData> getRealTimeData(List<String> fullPointNames) {
        return this.socketEntry.getRealtimeTagValuesList(fullPointNames.toArray(new String[0]));
    }

    @Override
    public List<PointData> getHistoryRawData(String fullPointName, String beginTime, String endTime) {
        return null;
    }

    @Override
    public List<PointData> getHistorySnapData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = this.socketEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, SocketEntry.HIST_SNAP);
        return pds;
    }

    @Override
    public List<PointData> getHistoryMatrixSnapData(List<String> fullPointName, String hisTime) {
        ArrayList<PointData> list = new ArrayList();
        try {
            list = this.socketEntry.getHistoryMatrixValues(EdnaApiHelper.parseDateStringToUTC(hisTime), EdnaApiHelper.parseDateStringToUTC(hisTime), SocketEntry.HIST_SNAP, fullPointName);
        }
        catch (ParseException e) {
            this.logger.error((Object)("\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32\u9519\u8bef!" + e.getMessage()));
        }
        return list;
    }

    @Override
    public List<PointData> getAvgHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = this.socketEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, SocketEntry.HIST_AVG);
        return pds;
    }

    @Override
    public PointData getAvgHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.socketEntry.getHistoryTagValues(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue(), SocketEntry.HIST_AVG);
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<PointData> getMaxHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = this.socketEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, SocketEntry.HIST_MAX);
        return pds;
    }

    @Override
    public PointData getMaxHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.socketEntry.getHistoryTagValues(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue(), SocketEntry.HIST_MAX);
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<PointData> getMinHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = this.socketEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, SocketEntry.HIST_MIN);
        return pds;
    }

    @Override
    public PointData getMinHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.socketEntry.getHistoryTagValues(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue(), SocketEntry.HIST_MIN);
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<String> getRealTimeServices() {
        return this.socketEntry.getRTServs();
    }

    @Override
    public String getLongId(String fullPointName) {
        return null;
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, List<PointInfo> pis) {
        this.socketWriteEntry.SendConfigRec(serviceIp, Integer.parseInt(servicePort), pis);
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, PointInfo pi) {
        ArrayList<PointInfo> pis = new ArrayList<PointInfo>();
        pis.add(pi);
        this.socketWriteEntry.SendConfigRec(serviceIp, Integer.parseInt(servicePort), pis);
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, List<PointData> pds) {
        if (pds != null && !pds.isEmpty()) {
            if (pds.size() > 100) {
                HashMap<String, ArrayList<PointData>> map1 = new HashMap<String, ArrayList<PointData>>();
                Integer k = 0;
                Map<String, ArrayList<PointData>> map = this.newTableList((ArrayList)pds, 100, map1, k);
                for (Map.Entry<String, ArrayList<PointData>> entry : map.entrySet()) {
                    this.socketWriteEntry.writeMultiPoint(serviceIp, Integer.parseInt(servicePort), (List<PointData>)entry.getValue());
                }
            } else {
                this.socketWriteEntry.writeMultiPoint(serviceIp, Integer.parseInt(servicePort), pds);
            }
        }
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, PointData pd) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        pds.add(pd);
        this.socketWriteEntry.writeSinglePoint(serviceIp, Integer.parseInt(servicePort), pd.getPointId(), pds.toArray(new PointData[0]));
    }

    public Map<String, ArrayList<PointData>> newTableList(ArrayList<PointData> list, int num, Map<String, ArrayList<PointData>> map, Integer k) {
        ArrayList<PointData> tempList = new ArrayList<PointData>();
        int size = list.size();
        List newList = (List)list.clone();
        int i = 0;
        while (i < size) {
            if (i >= num) break;
            PointData pd = list.get(i);
            tempList.add(pd);
            ++i;
        }
        if (list != null && size != 0) {
            k = k + 1;
            map.put(String.valueOf(k), tempList);
            i = 0;
            while (i < tempList.size()) {
                PointData tempStr = (PointData)tempList.get(i);
                boolean isContains = newList.contains(tempStr);
                if (isContains) {
                    newList.remove(tempStr);
                }
                ++i;
            }
            this.newTableList((ArrayList)newList, num, map, k);
        }
        return map;
    }

    public SocketEntry getSocketEntry() {
        return this.socketEntry;
    }

    public void setSocketEntry(SocketEntry socketEntry) {
        this.socketEntry = socketEntry;
    }

    public SocketWriteEntry getSocketWriteEntry() {
        return this.socketWriteEntry;
    }

    public void setSocketWriteEntry(SocketWriteEntry socketWriteEntry) {
        this.socketWriteEntry = socketWriteEntry;
    }

    @Override
    public PointData getHistorySnapData(String fullPointName, String hisTime) {
        return null;
    }

    @Override
    public Integer putHistoryData(String fullPointName, List<PointData> pds) {
        return null;
    }
}

