/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.service;

import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.service.IOperatorRealTime;
import cn.gyee.appsoft.jrt.yb.ApiEntry;
import cn.gyee.appsoft.jrt.yb.ApiWriteEntry;
import cn.gyee.appsoft.jrt.yb.DNAPointVal;
import cn.gyee.appsoft.jrt.yb.DNAVal;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EdnaSocketApiService
implements IOperatorRealTime {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String address = "12.0.1.30";
    private Integer port = 6321;

    @Override
    public void addPointMemory(String fullPointName, int refInterval) {
    }

    @Override
    public PointData getRealTimeData(String fullPointName) {
        PointData pd = null;
        ApiEntry entry = null;
        try {
            entry = new ApiEntry(this.address, this.port);
            DNAVal dnaVal = entry.getRealtimeTagValue(fullPointName);
            pd = EdnaApiHelper.convertPointData(dnaVal, fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getRealTimeData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        return pd;
    }

    @Override
    public List<PointData> getRealTimeData(List<String> fullPointNames) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getRealtimeTagValues(fullPointNames.toArray(new String[0]));
            pds = EdnaApiHelper.convertPointDatas(map);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getRealTimeData-List\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        return pds;
    }

    @Override
    public List<PointData> getHistoryRawData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getHistoryTagRawValues(fullPointName, beginTime, endTime);
            pds = EdnaApiHelper.convertHistoryPointDatas(map, fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistoryRawData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public List<PointData> getHistorySnapData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, ApiEntry.HIST_SNAP);
            pds = EdnaApiHelper.convertHistoryPointDatas(map, fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistorySnapData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getHistorySnapData(String fullPointName, String hisTime) {
        PointData pd = null;
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getHistoryTagValues(fullPointName, hisTime, hisTime, 1L, ApiEntry.HIST_SNAP);
            pd = EdnaApiHelper.convertHistoryPointData(map.get(hisTime), fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistorySnapData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        return pd;
    }

    @Override
    public List<PointData> getHistoryMatrixSnapData(List<String> fullPointName, String hisTime) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getHistoryMatrixValues(hisTime, hisTime, ApiEntry.HIST_SNAP, fullPointName.toArray(new String[0]));
            pds = EdnaApiHelper.convertPointDatas(map);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getHistoryMatrixSnapData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public List<PointData> getAvgHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, ApiEntry.HIST_AVG);
            pds = EdnaApiHelper.convertHistoryPointDatas(map, fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getAvgHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getAvgHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.getAvgHistoryData(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<PointData> getMaxHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, ApiEntry.HIST_MAX);
            pds = EdnaApiHelper.convertHistoryPointDatas(map, fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getMaxHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getMaxHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.getMaxHistoryData(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<PointData> getMinHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        List<PointData> pds = new ArrayList<PointData>();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            Map<String, DNAVal> map = apiEntry.getHistoryTagValues(fullPointName, beginTime, endTime, period, ApiEntry.HIST_MIN);
            pds = EdnaApiHelper.convertHistoryPointDatas(map, fullPointName);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getMinHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        Collections.sort(pds);
        return pds;
    }

    @Override
    public PointData getMinHistoryData(String fullPointName, String beginTime, String endTime) {
        List<PointData> pds = this.getMinHistoryData(fullPointName, beginTime, endTime, EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
        PointData pd = null;
        if (!pds.isEmpty()) {
            pd = pds.get(0);
        }
        return pd;
    }

    @Override
    public List<String> getRealTimeServices() {
        ArrayList<String> result = new ArrayList();
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            result = apiEntry.getRTServs();
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("getRealTimeServices\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        return result;
    }

    @Override
    public String getLongId(String fullPointName) {
        return null;
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, List<PointInfo> pis) {
        ApiWriteEntry apiWriteEntry = null;
        try {
            apiWriteEntry = new ApiWriteEntry(false);
            apiWriteEntry.connect(serviceIp, Integer.parseInt(servicePort));
            apiWriteEntry.SendConfigRec(EdnaApiHelper.convertPointInfo(pis));
            apiWriteEntry.disconnect();
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("createPoint\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (IOException ie) {
            this.logger.error((Object)("IO\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + ie.getMessage()));
        }
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, PointInfo pi) {
        ArrayList<PointInfo> pis = new ArrayList<PointInfo>();
        pis.add(pi);
        this.createPoint(serviceIp, servicePort, pis);
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, List<PointData> pds) {
        if (pds != null && !pds.isEmpty()) {
            ApiWriteEntry apiWriteEntry = null;
            try {
                apiWriteEntry = new ApiWriteEntry(false);
                apiWriteEntry.connect(serviceIp, Integer.parseInt(servicePort));
                DNAPointVal[] vals = EdnaApiHelper.convertPointData(pds);
                apiWriteEntry.writeMultiPoint(vals);
                apiWriteEntry.disconnect();
            }
            catch (SocketException e) {
                e.printStackTrace();
                this.logger.error((Object)("\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
            }
            catch (IOException ie) {
                this.logger.error((Object)("IO\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + ie.getMessage()));
            }
        }
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, PointData pd) {
        ApiWriteEntry apiWriteEntry = null;
        try {
            apiWriteEntry = new ApiWriteEntry(false);
            apiWriteEntry.connect(serviceIp, Integer.parseInt(servicePort));
            DNAPointVal val = EdnaApiHelper.convertPointData(pd);
            apiWriteEntry.writeSinglePoint(pd.getPointId(), val.Val);
            apiWriteEntry.disconnect();
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (IOException ie) {
            this.logger.error((Object)("IO\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + ie.getMessage()));
        }
    }

    @Override
    public Integer putHistoryData(String fullPointName, List<PointData> pds) {
        Integer result = null;
        ApiEntry apiEntry = null;
        try {
            apiEntry = new ApiEntry(this.address, this.port);
            if (!pds.isEmpty()) {
                DNAVal[] vals = new DNAVal[pds.size()];
                int i = 0;
                while (i < vals.length) {
                    vals[i] = new DNAVal();
                    vals[i].DValue = pds.get(i).getValue() == null ? 0.0 : pds.get(i).getValue();
                    vals[i].Time = pds.get(i).getUtcTime();
                    vals[i].Status = pds.get(i).getStatus();
                    ++i;
                }
                result = apiEntry.updateVals(fullPointName, vals);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("putHistoryData\u901a\u8baf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770bIP\u5730\u5740\u548c\u7aef\u53e3!" + e.getMessage()));
        }
        catch (UnknownHostException ue) {
            this.logger.error((Object)("\u4e0d\u652f\u6301\u7f16\u7801\u7684\u5f02\u5e38!" + ue.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)("EDNA\u5f02\u5e38!" + ex.getMessage()));
        }
        return result;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

