/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.service;

import cn.gyee.appsoft.jrt.common.EdnaApiHelper;
import cn.gyee.appsoft.jrt.instep.Key;
import cn.gyee.appsoft.jrt.instep.YinBuNativeApi;
import cn.gyee.appsoft.jrt.model.PointData;
import cn.gyee.appsoft.jrt.model.PointInfo;
import cn.gyee.appsoft.jrt.service.IOperatorRealTime;
import com.excelsior.xFunction.xFunctionException;
import com.instep.jedna.calldll.CallNativeApi;
import com.instep.jedna.data.AddConfigRec;
import com.instep.jedna.data.BaseResponse;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EdnaApiService
implements IOperatorRealTime {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected YinBuNativeApi yb_api;

    public EdnaApiService() {
        try {
            this.yb_api = new YinBuNativeApi();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u6784\u9020\u65b9\u6cd5\u5931\u8d25! " + e.getMessage()));
        }
    }

    public void setYb_api(YinBuNativeApi yb_api) {
        this.yb_api = yb_api;
    }

    @Override
    public void addPointMemory(String fullPointName, int refInterval) {
        try {
            CallNativeApi.EzSvcAddPoint((String)fullPointName, (int)refInterval);
        }
        catch (xFunctionException e) {
            this.logger.error((Object)("\u7f8e\u56fdEDNA-\u8c03\u7528\u6dfb\u52a0\u70b9\u5230\u5185\u5b58\u65b9\u6cd5\u5931\u8d25! " + e.getMessage()));
        }
    }

    @Override
    public PointData getRealTimeData(String fullPointName) {
        PointData pd = null;
        try {
            pd = EdnaApiHelper.convertPointData(this.yb_api.DnaGetRTValue(fullPointName));
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5b9e\u65f6\u6570\u636e\u5931\u8d25! " + e.getMessage()));
        }
        return pd;
    }

    @Override
    public List<PointData> getHistoryRawData(String fullPointName, String beginTime, String endTime) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        try {
            Key key = this.yb_api.DnaGetHistRawUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime));
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                List<cn.gyee.appsoft.jrt.instep.PointData> pointDatas = Arrays.asList(pdsarr);
                for (cn.gyee.appsoft.jrt.instep.PointData pd : pointDatas) {
                    pds.add(EdnaApiHelper.convertPointData(pd));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u539f\u59cb\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pds;
    }

    @Override
    public List<PointData> getHistorySnapData(String fullPointName, String beginTime, String endTime, int period) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        try {
            Key key = this.yb_api.DnaGetHistSnapUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                List<cn.gyee.appsoft.jrt.instep.PointData> pointDatas = Arrays.asList(pdsarr);
                for (cn.gyee.appsoft.jrt.instep.PointData pd : pointDatas) {
                    pds.add(EdnaApiHelper.convertPointData(pd));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u5feb\u7167\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pds;
    }

    @Override
    public List<PointData> getAvgHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        try {
            Key key = this.yb_api.DnaGetHistAvgUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                List<cn.gyee.appsoft.jrt.instep.PointData> pointDatas = Arrays.asList(pdsarr);
                for (cn.gyee.appsoft.jrt.instep.PointData pd : pointDatas) {
                    pds.add(EdnaApiHelper.convertPointData(pd));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u5e73\u5747\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pds;
    }

    @Override
    public PointData getAvgHistoryData(String fullPointName, String beginTime, String endTime) {
        long startTime = System.currentTimeMillis();
        PointData pd = null;
        try {
            Key key = this.yb_api.DnaGetHistAvgUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                pd = EdnaApiHelper.convertPointData(pdsarr[0]);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u5e73\u5747\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pd;
    }

    @Override
    public List<PointData> getMaxHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        try {
            Key key = this.yb_api.DnaGetHistMaxUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                List<cn.gyee.appsoft.jrt.instep.PointData> pointDatas = Arrays.asList(pdsarr);
                for (cn.gyee.appsoft.jrt.instep.PointData pd : pointDatas) {
                    pds.add(EdnaApiHelper.convertPointData(pd));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u6700\u5927\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pds;
    }

    @Override
    public PointData getMaxHistoryData(String fullPointName, String beginTime, String endTime) {
        long startTime = System.currentTimeMillis();
        PointData pd = null;
        try {
            Key key = this.yb_api.DnaGetHistMaxUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                pd = EdnaApiHelper.convertPointData(pdsarr[0]);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u6700\u5927\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pd;
    }

    @Override
    public List<PointData> getMinHistoryData(String fullPointName, String beginTime, String endTime, int period) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        try {
            Key key = this.yb_api.DnaGetHistMinUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), period);
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                List<cn.gyee.appsoft.jrt.instep.PointData> pointDatas = Arrays.asList(pdsarr);
                for (cn.gyee.appsoft.jrt.instep.PointData pd : pointDatas) {
                    pds.add(EdnaApiHelper.convertPointData(pd));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u6700\u5c0f\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pds;
    }

    @Override
    public PointData getMinHistoryData(String fullPointName, String beginTime, String endTime) {
        long startTime = System.currentTimeMillis();
        PointData pd = null;
        try {
            Key key = this.yb_api.DnaGetHistMinUTC(fullPointName, EdnaApiHelper.parseDateStringToUTC(beginTime), EdnaApiHelper.parseDateStringToUTC(endTime), EdnaApiHelper.secondsDiff(EdnaApiHelper.toDate(endTime), EdnaApiHelper.toDate(beginTime)).intValue());
            cn.gyee.appsoft.jrt.instep.PointData[] pdsarr = this.yb_api.DnaGetNextHistBlockUTC(key);
            if (pdsarr.length > 0) {
                pd = EdnaApiHelper.convertPointData(pdsarr[0]);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5386\u53f2\u6570\u636e\u6700\u5c0f\u503c\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pd;
    }

    @Override
    public List<String> getRealTimeServices() {
        long startTime = System.currentTimeMillis();
        ArrayList<String> services = new ArrayList();
        try {
            String[] arr = this.yb_api.DnaGetRTServiceList();
            if (arr.length > 0) {
                services = Arrays.asList(arr);
            }
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u5b9e\u65f6\u670d\u52a1\u5217\u8868\u5931\u8d25! " + e.getMessage()));
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return services;
    }

    @Override
    public String getLongId(String fullPointName) {
        String result = "";
        try {
            result = this.yb_api.LongIdFromShortId(fullPointName);
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6longId\u5931\u8d25! " + e.getMessage()));
        }
        return result;
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, List<PointInfo> pis) {
        long startTime = System.currentTimeMillis();
        if (!pis.isEmpty()) {
            try {
                com.instep.jedna.data.Key key = CallNativeApi.DnaUniversalInitialize((boolean)false, (boolean)true, (boolean)true, (long)0xA00000L, (String)"szCacheFileName", (String)"szCacheDriveDir");
                Long lkey = key.getKey();
                if (lkey < 0L) {
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u521d\u59cb\u5316\u670d\u52a1\u5931\u8d25! Error(Key) = " + lkey));
                    return;
                }
                BaseResponse response = CallNativeApi.DnaUniversalDataConnect((long)lkey, (String)serviceIp, (short)Short.parseShort(servicePort), (String)serviceIp, (short)Short.parseShort(servicePort));
                int status = response.getReturnStatus();
                if (status != 0) {
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u8fde\u63a5\u670d\u52a1\u5931\u8d25! Error(status) = " + status));
                    return;
                }
                for (PointInfo pi : pis) {
                    response = CallNativeApi.DnaAddConfigRec((long)lkey, (AddConfigRec)EdnaApiHelper.convertPointCfg(pi));
                    status = response.getReturnStatus();
                    if (status == 0) continue;
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u5c06\u6d4b\u70b9\u4fe1\u606f\u6dfb\u52a0\u961f\u5217\u51fa\u73b0\u5f02\u5e38! Error(status) = " + status + " ; point= " + pi.getDesc()));
                    return;
                }
                response = CallNativeApi.DnaFlushUniversalRecord((long)lkey, (int)5);
                status = response.getReturnStatus();
                if (status != 0) {
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u5b9e\u65f6\u670d\u52a1\u5237\u65b0\u8bb0\u5f55\u5931\u8d25! Error(status) = " + status));
                    return;
                }
                if (CallNativeApi.IsDnaUniversalConnected((long)lkey)) {
                    CallNativeApi.DnaUniversalCloseSocketSoft((long)lkey);
                }
            }
            catch (xFunctionException e) {
                this.logger.error((Object)("\u7f8e\u56fdEDNA-\u521b\u5efa\u70b9\u5931\u8d25! " + e.getMessage()));
            }
            this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        }
    }

    @Override
    public void createPoint(String serviceIp, String servicePort, PointInfo pi) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointInfo> pis = new ArrayList<PointInfo>();
        pis.add(pi);
        this.createPoint(serviceIp, servicePort, pis);
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, List<PointData> pds) {
        long startTime = System.currentTimeMillis();
        if (!pds.isEmpty()) {
            try {
                com.instep.jedna.data.Key key = CallNativeApi.DnaUniversalInitialize((boolean)false, (boolean)true, (boolean)true, (long)0xA00000L, (String)"szCacheFileName", (String)"szCacheDriveDir");
                Long lkey = key.getKey();
                if (lkey < 0L) {
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u521d\u59cb\u5316\u670d\u52a1\u5931\u8d25! Error(Key) = " + lkey));
                    return;
                }
                BaseResponse response = CallNativeApi.DnaUniversalDataConnect((long)lkey, (String)serviceIp, (short)Short.parseShort(servicePort), (String)serviceIp, (short)Short.parseShort(servicePort));
                int status = response.getReturnStatus();
                if (status != 0) {
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u8fde\u63a5\u670d\u52a1\u5931\u8d25! Error(status) = " + status));
                    return;
                }
                long lTime = System.currentTimeMillis() / 1000L;
                for (PointData pd : pds) {
                    response = CallNativeApi.DnaAddRec((long)lkey, (String)pd.getPointId(), (long)lTime, (short)Short.parseShort("0"), (short)EdnaApiHelper.usStatus, (double)pd.getValue());
                    status = response.getReturnStatus();
                    if (status == 0) continue;
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u5c06\u6d4b\u70b9\u5199\u5165\u6570\u636e\u5f02\u5e38! Error(status) = " + status));
                    return;
                }
                response = CallNativeApi.DnaFlushUniversalRecord((long)lkey, (int)1);
                status = response.getReturnStatus();
                if (status != 0) {
                    this.logger.debug((Object)("\u7f8e\u56fdEDNA-\u5b9e\u65f6\u670d\u52a1\u5237\u65b0\u8bb0\u5f55\u5931\u8d25! Error(status) = " + status));
                    return;
                }
                if (CallNativeApi.IsDnaUniversalConnected((long)lkey)) {
                    CallNativeApi.DnaUniversalCloseSocketSoft((long)lkey);
                }
            }
            catch (xFunctionException e) {
                this.logger.error((Object)("\u7f8e\u56fdEDNA-\u521b\u5efa\u70b9\u5931\u8d25! " + e.getMessage()));
            }
            this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        }
    }

    @Override
    public void writePoint(String serviceIp, String servicePort, PointData pd) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        pds.add(pd);
        this.writePoint(serviceIp, servicePort, pds);
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
    }

    @Override
    public List<PointData> getRealTimeData(List<String> fullPointNames) {
        long startTime = System.currentTimeMillis();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        if (fullPointNames != null && !fullPointNames.isEmpty()) {
            try {
                cn.gyee.appsoft.jrt.instep.PointData[] pointDatas = this.yb_api.DNAGetRTAllList(fullPointNames.toArray(new String[0]));
                if (pointDatas != null && pointDatas.length > 0) {
                    int i = 0;
                    while (i < pointDatas.length) {
                        pds.add(EdnaApiHelper.convertPointData(pointDatas[i]));
                        ++i;
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.error((Object)("\u5317\u4eac\u5370\u6b65-\u83b7\u53d6\u591a\u70b9\u5b9e\u65f6\u6570\u636e\u5931\u8d25! " + e.getMessage()));
            }
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pds;
    }

    @Override
    public List<PointData> getHistoryMatrixSnapData(List<String> fullPointNames, String hisTime) {
        ArrayList<PointData> pds = new ArrayList<PointData>();
        long startTime = System.currentTimeMillis();
        if (fullPointNames != null && !fullPointNames.isEmpty()) {
            for (String pointName : fullPointNames) {
                List<PointData> list = this.getHistorySnapData(pointName, hisTime, hisTime, 1);
                pds.addAll(list);
            }
        }
        this.logger.debug((Object)("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " \u79d2 "));
        return pds;
    }

    @Override
    public PointData getHistorySnapData(String fullPointName, String hisTime) {
        return null;
    }

    @Override
    public Integer putHistoryData(String fullPointName, List<PointData> pds) {
        return null;
    }
}

