/*
 * Decompiled with CFR 0.152.
 */
package cn.gyee.appsoft.jrt.instep;

import cn.gyee.appsoft.jrt.instep.DnaPoint;
import cn.gyee.appsoft.jrt.instep.ICallNativeApi;
import cn.gyee.appsoft.jrt.instep.ICallNativeRemote;
import cn.gyee.appsoft.jrt.instep.Key;
import cn.gyee.appsoft.jrt.instep.PointData;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class YinBuNativeApi
implements ICallNativeRemote {
    protected static final Log logger = LogFactory.getLog(YinBuNativeApi.class);

    public static void main(String[] args) {
    }

    @Override
    public Key DnaGetHistSnapUTC(String pointName, int startUtc, int endUtc, int period) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHistSnapUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)endUtc > time) {
            endUtc = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHistSnapUTC(pointName, startUtc, endUtc, period, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public Key DnaGetHistMaxUTC(String pointName, int startUtc, int endUtc, int period) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHistSnapUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)endUtc > time) {
            endUtc = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHistMaxUTC(pointName, startUtc, endUtc, period, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public Key DnaGetHistMinUTC(String pointName, int startUtc, int endUtc, int period) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHistMinUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)endUtc > time) {
            endUtc = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHistMinUTC(pointName, startUtc, endUtc, period, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public Key DnaGetHistAvgUTC(String pointName, int startUtc, int endUtc, int period) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHistAvgUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)endUtc > time) {
            endUtc = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHistAvgUTC(pointName, startUtc, endUtc, period, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public Key DnaGetHistInterpUTC(String pointName, int startUtc, int endUtc, int period) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHistInterpUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)endUtc > time) {
            endUtc = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHistInterpUTC(pointName, startUtc, endUtc, period, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public Key DnaGetHistRawUTC(String pointName, int startUtc, int endUtc) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHistRawUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)endUtc > time) {
            endUtc = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHistRawUTC(pointName, startUtc, endUtc, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public Key DnaGetHSHistRawUTC(String szPoint, int tStart, short nStartMillis, int tEnd, short nEndMillis) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHSHistRawUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)tEnd > time) {
            tEnd = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHSHistRawUTC(szPoint, tStart, nStartMillis, tEnd, nEndMillis, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public Key DnaGetHSHistSnapUTC(String szPoint, int tStart, short nStartMillis, int tEnd, short nEndMillis, int tPeriod, short nPeriodMillis) throws RemoteException {
        logger.debug((Object)"Calling DnaGetHSHistSnapUTC....");
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis() / 1000L;
        if ((long)tEnd > time) {
            tEnd = (int)time;
        }
        IntByReference key = new IntByReference();
        int nRet = ICallNativeApi.INSTANCE.DnaGetHSHistSnapUTC(szPoint, tStart, nStartMillis, tEnd, nEndMillis, tPeriod, nPeriodMillis, key);
        return new Key(key.getValue(), nRet);
    }

    @Override
    public PointData[] DnaGetNextHistBlockUTC(Key key) throws RemoteException {
        logger.debug((Object)"Calling DnaGetNextHistBlockUTC....");
        DoubleByReference dValue = new DoubleByReference();
        IntByReference utcTime = new IntByReference();
        ShortByReference status = new ShortByReference();
        int nRet = -1;
        ArrayList<PointData> arrayList = new ArrayList<PointData>();
        do {
            short shortStatus;
            if ((nRet = ICallNativeApi.INSTANCE.DnaGetNextHistSmallUTC(key.getKey(), dValue, utcTime, status)) != 0 || (shortStatus = status.getValue()) == 3 && shortStatus == 2051) continue;
            PointData data = new PointData(dValue.getValue(), utcTime.getValue(), 0, status.getValue());
            arrayList.add(data);
        } while (nRet == 0);
        PointData[] rData = new PointData[arrayList.size()];
        rData = arrayList.toArray(rData);
        System.out.println("DataNums : " + rData.length);
        return rData;
    }

    @Override
    public PointData DnaGetRTValue(String point) throws RemoteException {
        logger.debug((Object)"Calling DnaGetRTValue....");
        DoubleByReference dValue = new DoubleByReference();
        IntByReference utcTime = new IntByReference();
        ShortByReference status = new ShortByReference();
        ICallNativeApi.INSTANCE.DNAGetRTShort(point, dValue, utcTime, status);
        PointData real = new PointData(dValue.getValue(), utcTime.getValue(), 0, status.getValue());
        return real;
    }

    @Override
    public PointData[] DnaGetNextHSHistBlockUTC(Key key) throws RemoteException {
        logger.debug((Object)"Calling DnaGetNextHSHistBlockUTC....");
        DoubleByReference dValue = new DoubleByReference();
        IntByReference utcTime = new IntByReference();
        ShortByReference msTime = new ShortByReference();
        ShortByReference status = new ShortByReference();
        int nRet = -1;
        ArrayList<PointData> arrayList = new ArrayList<PointData>();
        do {
            short shortStatus;
            if ((nRet = ICallNativeApi.INSTANCE.DnaGetNextHSHistSmallUTC(key.getKey(), dValue, utcTime, msTime, status)) != 0 || (shortStatus = status.getValue()) == 3 && shortStatus == 2051) continue;
            PointData data = new PointData(dValue.getValue(), utcTime.getValue(), 0, status.getValue());
            arrayList.add(data);
        } while (nRet == 0);
        PointData[] rData = new PointData[arrayList.size()];
        rData = arrayList.toArray(rData);
        return rData;
    }

    @Override
    public String[] DnaGetRTServiceList() throws RemoteException {
        logger.debug((Object)"Calling DnaGetRTServiceList....");
        ArrayList<String> returnArray = new ArrayList<String>();
        IntByReference pulKey = new IntByReference();
        byte[] szSvcName = new byte[300];
        byte[] szSvcDesc = new byte[300];
        byte[] szSvcType = new byte[300];
        byte[] szStatus = new byte[300];
        int nRet = ICallNativeApi.INSTANCE.DnaGetServiceEntry("SSERVER", "", pulKey, szSvcName, (short)300, szSvcDesc, (short)300, szSvcType, (short)300, szStatus, (short)300);
        if (nRet == 0) {
            if (new String(szStatus).contains("OK")) {
                returnArray.add(new String(szSvcName).trim());
            }
            while (ICallNativeApi.INSTANCE.DnaGetNextServiceEntry(pulKey.getValue(), szSvcName, (short)300, szSvcDesc, (short)300, szSvcType, (short)300, szStatus, (short)300) == 0) {
                if (!new String(szStatus).contains("OK")) continue;
                returnArray.add(new String(szSvcName).trim());
            }
        }
        String[] rtServiceList = new String[returnArray.size()];
        rtServiceList = returnArray.toArray(rtServiceList);
        return rtServiceList;
    }

    @Override
    public DnaPoint[] DnaGetAllPointFromService(String service) throws RemoteException {
        if (service.equals("")) {
            throw new RemoteException("Error empty service name");
        }
        ArrayList<DnaPoint> returnArray = new ArrayList<DnaPoint>();
        IntByReference pulKey = new IntByReference();
        DoubleByReference pdValue = new DoubleByReference();
        byte[] szPoint = new byte[300];
        byte[] szTime = new byte[300];
        byte[] szStatus = new byte[300];
        byte[] szDesc = new byte[300];
        byte[] szUnits = new byte[300];
        logger.debug((Object)"Calling DnaGetAllPointFromService....");
        int nRet = ICallNativeApi.INSTANCE.DnaGetPointEntry(service, (short)0, pulKey, szPoint, (short)300, pdValue, szTime, (short)300, szStatus, (short)300, szDesc, (short)300, szUnits, (short)300);
        if (nRet == 0) {
            DnaPoint dnaPoint = new DnaPoint();
            dnaPoint.setPointName(new String(szPoint).trim());
            dnaPoint.setDesc(new String(szDesc).trim());
            dnaPoint.setUnits(new String(szUnits).trim());
            returnArray.add(dnaPoint);
            while (ICallNativeApi.INSTANCE.DnaGetNextPointEntry(pulKey.getValue(), szPoint, (short)300, pdValue, szTime, (short)300, szStatus, (short)300, szDesc, (short)300, szUnits, (short)300) == 0) {
                dnaPoint = new DnaPoint();
                dnaPoint.setPointName(new String(szPoint).trim());
                dnaPoint.setDesc(new String(szDesc).trim());
                dnaPoint.setUnits(new String(szUnits).trim());
                returnArray.add(dnaPoint);
            }
        }
        DnaPoint[] dnaPoints = new DnaPoint[returnArray.size()];
        dnaPoints = returnArray.toArray(dnaPoints);
        return dnaPoints;
    }

    @Override
    public String LongIdFromShortId(String fullShortID) throws RemoteException {
        byte[] szLongID = new byte[300];
        logger.debug((Object)"Calling LongIdFromShortId....");
        int nRet = ICallNativeApi.INSTANCE.LongIdFromShortId(fullShortID, szLongID, (short)300);
        if (nRet == 0) {
            return new String(szLongID).trim();
        }
        return null;
    }

    @Override
    public PointData[] DNAGetRTAllList(String[] pszPoint) throws RemoteException {
        int nCount = pszPoint.length;
        short nSize = 200;
        byte[] pdValue = new byte[8 * nCount];
        String[] pszTime = new String[nCount];
        String[] pszStatus = new String[nCount];
        String[] pszDesc = new String[nCount];
        String[] pszUnits = new String[nCount];
        int i = 0;
        while (i < nCount) {
            pszTime[i] = new String(new char[nSize]);
            pszStatus[i] = new String(new char[nSize]);
            pszDesc[i] = new String(new char[nSize]);
            pszUnits[i] = new String(new char[nSize]);
            ++i;
        }
        logger.debug((Object)"Calling DNAGetRTAllList....");
        int nRet = ICallNativeApi.INSTANCE.DNAGetRTAllList((short)nCount, pszPoint, pdValue, pszTime, nSize, pszStatus, nSize, pszDesc, nSize, pszUnits, nSize);
        if (nRet == 0) {
            PointData[] points = new PointData[nCount];
            int i2 = 0;
            while (i2 < nCount) {
                points[i2] = new PointData(ByteBuffer.wrap(pdValue, i2 * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble(), 0, 0, 0);
                ++i2;
            }
            return points;
        }
        return null;
    }
}

