/*
 * Decompiled with CFR 0.152.
 */
package flex.rds.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;

public class RdsHttpResponseFormatter {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    int returnCount = 0;
    String errMessage;
    String encoding = "utf-8";

    public void add(String arg) {
        this.add(this.getBytes(arg));
    }

    public void add(byte[] buf) {
        try {
            this.bout.write(Integer.toString(buf.length).getBytes(this.encoding));
            this.bout.write(this.getBytes(":"));
            this.bout.write(buf);
            ++this.returnCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setError(int errorCode, String message, String details) {
        this.returnCount = errorCode;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(message);
        if (details != null) {
            pw.println();
            pw.println(details);
        }
        pw.flush();
        this.errMessage = sw.toString();
    }

    public void setError(int errorCode, String message, Throwable th) {
        Throwable tmpRoot = th;
        Throwable root = null;
        if (th != null) {
            while (root == null) {
                if (tmpRoot instanceof ServletException) {
                    ServletException se = (ServletException)tmpRoot;
                    if (se.getRootCause() == null) {
                        root = se;
                        continue;
                    }
                    tmpRoot = se.getRootCause();
                    continue;
                }
                root = tmpRoot;
            }
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.flush();
        this.setError(errorCode, message, sw.toString());
    }

    public void setError(String message, Throwable th) {
        this.setError(-1, message, th);
    }

    public int getReturnCount() {
        return this.returnCount;
    }

    public byte[] getBytes(String str) {
        try {
            return str.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public byte[] getMessageBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.returnCount < 0) {
                out.write(this.getBytes(Integer.toString(this.getReturnCount())));
                out.write(this.getBytes(":"));
                out.write(this.getBytes(this.errMessage));
            } else {
                out.write(this.getBytes(Integer.toString(this.getReturnCount())));
                out.write(this.getBytes(":"));
                out.write(this.bout.toByteArray());
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

