/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.ArrayDecoder;
import flex.messaging.io.amf.translator.decoder.DecoderFactory;
import java.lang.reflect.Array;
import java.util.Collection;

public class ReferenceAwareArrayDecoder
extends ArrayDecoder {
    public Object decodeObject(Object shell, Object encodedObject, Class desiredClass) {
        if (shell == null || encodedObject == null) {
            return null;
        }
        Class<?> arrayElementClass = desiredClass.getComponentType();
        if (encodedObject instanceof Collection) {
            return this.decodeArray(shell, (Collection)encodedObject, arrayElementClass);
        }
        if (encodedObject.getClass().isArray()) {
            return this.decodeArray(shell, encodedObject, arrayElementClass);
        }
        if (encodedObject instanceof String && Character.class.equals(arrayElementClass)) {
            return this.decodeArray(shell, (String)encodedObject, arrayElementClass);
        }
        return shell;
    }

    protected Object decodeArray(Object shellArray, Collection collection, Class arrayElementClass) {
        Object[] array = collection.toArray();
        TypeMarshallingContext.getTypeMarshallingContext().getKnownObjects().put(array, shellArray);
        return this.decodeArray(shellArray, array, arrayElementClass);
    }

    protected Object decodeArray(Object shellArray, Object array, Class arrayElementClass) {
        Object encodedValue = null;
        Object decodedValue = null;
        TypeMarshallingContext context = TypeMarshallingContext.getTypeMarshallingContext();
        ActionScriptDecoder decoder = null;
        int n = 0;
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            encodedValue = Array.get(array, i);
            if (encodedValue == null) {
                Array.set(shellArray, n, null);
            } else {
                Object ref = null;
                if (this.canUseByReference(encodedValue)) {
                    ref = context.getKnownObjects().get(encodedValue);
                }
                if (ref == null) {
                    decoder = DecoderFactory.getReferenceAwareDecoder(encodedValue, arrayElementClass);
                    decodedValue = decoder.decodeObject(encodedValue, arrayElementClass);
                    if (this.canUseByReference(decodedValue)) {
                        context.getKnownObjects().put(encodedValue, decodedValue);
                    }
                } else {
                    decodedValue = ref;
                }
                try {
                    Array.set(shellArray, n, decodedValue);
                }
                catch (IllegalArgumentException ex) {
                    Array.set(shellArray, n, null);
                }
            }
            ++n;
        }
        return shellArray;
    }
}

